/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import javax.swing.table.AbstractTableModel;

public class Table_SimpleModel
extends AbstractTableModel {
    protected Table_Abstract m_table;
    protected String m_colNameID;
    protected int m_colIndexID = -9999;

    public Table_SimpleModel(Table_Abstract table) {
        try {
            this.m_table = table;
            this.m_colNameID = table.name() + "ID";
            this.m_colIndexID = -9999;
            if (table.column_exists(this.m_colNameID)) {
                this.m_colIndexID = table.column_indexOfColumn(this.m_colNameID);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public boolean columnLocked(String colName) {
        try {
            boolean locked = colName.equalsIgnoreCase("ShotID") || colName.equalsIgnoreCase("ReceiverID");
            return locked;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return true;
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        try {
            if (obj == null) {
                return;
            }
            if (!(obj instanceof String)) {
                return;
            }
            String s = (String)obj;
            if (this.m_colIndexID < 0) {
                return;
            }
            int id = this.m_table.getInt(row, this.m_colIndexID);
            String colName = this.m_table.column_name(col);
            boolean locked = this.columnLocked(colName);
            if (locked) {
                return;
            }
            boolean isInt = colName.equalsIgnoreCase("LineNumber") || colName.equalsIgnoreCase("PointNumber") || colName.equalsIgnoreCase("PointIndex") || colName.equalsIgnoreCase("FFID") || colName.equalsIgnoreCase("LineNumber");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            if (isInt) {
                int val = Integer.parseInt(s);
                if (project.setTableValue_Int(this.m_table.name(), id, colName, val)) {
                    this.m_table.putInt(row, col, val);
                }
            } else {
                double val = Double.parseDouble(s);
                if (project.setTableValue(this.m_table.name(), id, colName, val)) {
                    this.m_table.putDouble(row, col, val);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        try {
            String colName = this.m_table.column_name(col);
            boolean locked = this.columnLocked(colName);
            return !locked && this.m_colIndexID >= 0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    @Override
    public String getColumnName(int column) {
        try {
            return this.m_table.column_name(column);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        if (this.m_table == null) {
            return 0;
        }
        return this.m_table.row_count();
    }

    @Override
    public int getColumnCount() {
        if (this.m_table == null) {
            return 0;
        }
        return this.m_table.column_count();
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            return this.m_table.getString(row, column, 5);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }
}

