/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Shared.ExceptionMonitor;
import javax.swing.table.AbstractTableModel;

public class Table_RowModel
extends AbstractTableModel {
    protected Table_Abstract m_table;
    protected int m_selectedRow = 0;

    public Table_RowModel(Table_Abstract table) {
        try {
            this.m_table = table;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int selectedRow() {
        return this.m_selectedRow;
    }

    public void setSelectedRow(int selectedRow) {
        try {
            this.m_selectedRow = selectedRow;
            this.fireTableStructureChanged();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        try {
            if (column == 0) {
                return "Column";
            }
            if (column == 1) {
                return "Value";
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public int getRowCount() {
        if (this.m_table == null) {
            return 0;
        }
        return this.m_table.column_count();
    }

    @Override
    public int getColumnCount() {
        if (this.m_table == null) {
            return 0;
        }
        return 2;
    }

    @Override
    public Object getValueAt(int row, int column) {
        try {
            if (this.m_table == null) {
                return "Error";
            }
            if (this.m_selectedRow < 0 || this.m_selectedRow >= this.m_table.row_count()) {
                return "Bad selected row number";
            }
            if (row < 0 || row >= this.m_table.column_count()) {
                return "Bad row number";
            }
            if (column == 0) {
                return this.m_table.column_name(row);
            }
            return this.m_table.getString(this.m_selectedRow, row, 5);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }
}

