/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Data.Sort;

import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;

public class SegySortEntry {
    protected int m_magic = 54564565;
    public int Key1;
    public int Key2;
    public int Count = 0;
    public int FileIndex = -9999;
    public long FilePosition = -9999L;

    public SegySortEntry(int key1, int key2) {
        this.Key1 = key1;
        this.Key2 = key2;
    }

    public SegySortEntry(RandomAccessFile file) throws Exception {
        try {
            int magic = file.readInt();
            if (magic != this.m_magic) {
                throw new Exception("magic != m_magic");
            }
            int version = file.readInt();
            if (version != 1000) {
                throw new Exception("bad version");
            }
            this.Key1 = file.readInt();
            this.Key2 = file.readInt();
            this.Count = file.readInt();
            this.FileIndex = file.readInt();
            this.FilePosition = file.readLong();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void save(RandomAccessFile file) throws Exception {
        try {
            int version = 1000;
            file.writeInt(this.m_magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.Key1);
                file.writeInt(this.Key2);
                file.writeInt(this.Count);
                file.writeInt(this.FileIndex);
                file.writeLong(this.FilePosition);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

