/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.TraceTable;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTable_Wrapper;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_PickCount
extends Action_Base {
    protected HashMap_Integers<Entry> m_mapShot = new HashMap_Integers();
    protected HashMap_Integers<Entry> m_mapRec = new HashMap_Integers();

    public Action_PickCount() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Shot/receiver fold, first break pick counts";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = true;
    }

    protected void merge(HashMap_Integers<Entry> map, Table_Abstract table) {
        try {
            String colName = table.name() + "ID";
            int indexID = table.column_indexOfColumn(colName);
            int indexCount = table.column_append("PickCount", DataType.Int);
            int indexFold = table.column_append("Fold", DataType.Int);
            int indexMinOff = table.column_append("MinOffset", DataType.Double);
            int indexMaxOff = table.column_append("MaxOffset", DataType.Double);
            for (int row = 0; row < table.row_count(); ++row) {
                int id = table.getInt(row, indexID);
                int count = 0;
                int fold = 0;
                double minx = 0.0;
                double maxx = 0.0;
                if (map.containsKey(id)) {
                    count = map.get((int)id).PickCount;
                    fold = map.get((int)id).Fold;
                    minx = map.get((int)id).MinOffset;
                    maxx = map.get((int)id).MaxOffset;
                }
                table.putInt(row, indexCount, count);
                table.putInt(row, indexFold, fold);
                table.putDouble(row, indexMinOff, minx);
                table.putDouble(row, indexMaxOff, maxx);
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            project.geometryDatabase().writeColumnContentsToDatabase(table, "PickCount");
            project.geometryDatabase().writeColumnContentsToDatabase(table, "Fold");
            project.geometryDatabase().writeColumnContentsToDatabase(table, "MinOffset");
            project.geometryDatabase().writeColumnContentsToDatabase(table, "MaxOffset");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable_Wrapper wrapper = project.traceTableWrapper();
            ITraceTable traceTable = wrapper.traceTable();
            int indexShotID = -9999;
            if (traceTable.column_exists("ShotID")) {
                indexShotID = traceTable.column_indexOfColumn("ShotID");
            }
            int indexRecID = -9999;
            if (traceTable.column_exists("ReceiverID")) {
                indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            }
            int indexPick = traceTable.column_indexOfColumn("FBP_User");
            int indexKilled = traceTable.column_indexOfColumn("Killed");
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotZ = shotTable.column_indexOfColumn("Elevation");
            int indexShotDead = shotTable.column_indexOfColumn("Killed");
            int indexShotDepth = -9999;
            if (shotTable.column_exists("PointDepth")) {
                indexShotDepth = shotTable.column_indexOfColumn("PointDepth");
            }
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecZ = recTable.column_indexOfColumn("Elevation");
            int indexRecDead = recTable.column_indexOfColumn("Killed");
            messageServer.setMessage_Level1("First pass");
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                int shotID = traceTable.getInt(row, indexShotID);
                int recID = traceTable.getInt(row, indexRecID);
                if (shotMap.containsKey(shotID) && recMap.containsKey(recID)) {
                    if (!this.m_mapRec.containsKey(recID)) {
                        this.m_mapRec.put(new Entry(recID), recID);
                    }
                    if (!this.m_mapShot.containsKey(shotID)) {
                        this.m_mapShot.put(new Entry(shotID), shotID);
                    }
                    ++this.m_mapShot.get((int)shotID).Fold;
                    ++this.m_mapRec.get((int)recID).Fold;
                    int shotRow = shotMap.get(shotID);
                    int recRow = recMap.get(recID);
                    double sx = shotTable.getDouble(shotRow, indexShotX);
                    double sy = shotTable.getDouble(shotRow, indexShotY);
                    double rx = recTable.getDouble(recRow, indexRecX);
                    double ry = recTable.getDouble(recRow, indexRecY);
                    double dx = rx - sx;
                    double dy = ry - sy;
                    double off = Math.sqrt(dx * dx + dy * dy);
                    float pick = traceTable.getFloat(row, indexPick);
                    int killed = traceTable.getInt(row, indexKilled);
                    if (!shotTable.getBool(shotRow, indexShotDead) && !recTable.getBool(recRow, indexRecDead)) {
                        this.m_mapShot.get(shotID).set_offset(off);
                        this.m_mapRec.get(recID).set_offset(off);
                        if (pick >= 1.0f && killed == 0) {
                            this.m_mapShot.get(shotID).increment();
                            this.m_mapRec.get(recID).increment();
                        }
                    }
                }
                if (row % 50000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)row / (double)(2L * traceTable.rowCount()));
            }
            this.merge(this.m_mapRec, project.receiverTable());
            this.merge(this.m_mapShot, project.shotTable());
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected class Entry {
        public int PickCount = 0;
        public int Fold = 0;
        public int ID;
        public double MaxOffset = 0.0;
        public double MinOffset = 1.0E20;

        public Entry(int id) {
            this.ID = id;
        }

        public void set_offset(double x) {
            if (x < this.MinOffset) {
                this.MinOffset = x;
            }
            if (x > this.MaxOffset) {
                this.MaxOffset = x;
            }
        }

        public void increment() {
            ++this.PickCount;
        }
    }
}

