/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.TraceTable;

import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTable_Wrapper;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.InteractiveMoveoutTrend;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_InteractiveTrend
extends Action_Base {
    public Action_InteractiveTrend() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Computing interactive trend";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = true;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            InteractiveMoveoutTrend trend = project.getInteractiveMoveoutTrend();
            trend.clear();
            ITraceTable_Wrapper wrapper = project.traceTableWrapper();
            ITraceTable traceTable = wrapper.traceTable();
            int indexInline = traceTable.column_indexOfColumn("Inline");
            int indexCrossline = traceTable.column_indexOfColumn("Crossline");
            int indexShotID = traceTable.column_indexOfColumn("ShotID");
            int indexRecID = traceTable.column_indexOfColumn("ReceiverID");
            int indexPick = traceTable.column_indexOfColumn("FBP_User");
            Table_Abstract shotTable = project.shotTable();
            HashMap_Integer shotMap = project.shotMap();
            int indexShotX = shotTable.column_indexOfColumn("Easting");
            int indexShotY = shotTable.column_indexOfColumn("Northing");
            int indexShotKilled = shotTable.column_indexOfColumn("Killed");
            Table_Abstract recTable = project.receiverTable();
            HashMap_Integer recMap = project.receiverMap();
            int indexRecX = recTable.column_indexOfColumn("Easting");
            int indexRecY = recTable.column_indexOfColumn("Northing");
            int indexRecKilled = recTable.column_indexOfColumn("Killed");
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                int shotID = traceTable.getInt(row, indexShotID);
                int recID = traceTable.getInt(row, indexRecID);
                float pick = traceTable.getFloat(row, indexPick);
                if (row % 100000L == 0L) {
                    double percent = 100.0 * (double)row / (double)traceTable.rowCount();
                    messageServer.setPercentDone(percent);
                }
                if (!(pick > 1.0f) || !(pick < 30000.0f) || !shotMap.containsKey(shotID) || !recMap.containsKey(recID)) continue;
                int shotRow = shotMap.get(shotID);
                int recRow = recMap.get(recID);
                double sx = shotTable.getDouble(shotRow, indexShotX);
                double sy = shotTable.getDouble(shotRow, indexShotY);
                boolean shotKilled = shotTable.getBool(shotRow, indexShotKilled);
                double rx = recTable.getDouble(recRow, indexRecX);
                double ry = recTable.getDouble(recRow, indexRecY);
                boolean recKilled = recTable.getBool(recRow, indexRecKilled);
                double midX = 0.5 * (sx + rx);
                double midY = 0.5 * (sy + ry);
                double dx = rx - sx;
                double dy = ry - sy;
                int off = (int)Math.sqrt(0.001 + dx * dx + dy * dy);
                trend.add(midX, midY, off, pick, false);
            }
            trend.computeAlphaBeta();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

