/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Sequence;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Base;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_SharedData;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_RunSequence
extends Action_Base {
    public EnsembleWorker_Sequence Sequence;
    protected EnsembleWorker_Base m_inputWorker;
    public EnsembleWorker_SharedData SharedData = new EnsembleWorker_SharedData();

    public Action_RunSequence() {
        this.RequiresRefractionStaticsProject = false;
        this.Description = "Execute processing sequence";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
        try {
            this.Description = this.Hasher.string_get("Description", "Run sequence");
            this.RequiresDelayTimeData = this.Hasher.bool_get("RequiresDelayTimeData", false);
            this.RequiresRefractionStaticsProject = this.Hasher.bool_get("RequiresRefractionStaticsProject", false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected boolean checkSequence() {
        try {
            if (this.Sequence.size() < 1) {
                this.FailureReason = "Sequence undefined";
                this.Failed = true;
                return false;
            }
            this.m_inputWorker = this.Sequence.worker(0);
            if (!this.m_inputWorker.isEnsembleSource()) {
                this.FailureReason = "Sequence has incorrect structure";
                this.Failed = true;
                return false;
            }
            if (!this.m_inputWorker.prepareSource()) {
                this.FailureReason = "Failed to prepare input source";
                this.Failed = true;
                return false;
            }
            this.SharedData.Batch = true;
            for (int n = 0; n < this.Sequence.size(); ++n) {
                this.Sequence.worker((int)n).SharedData = this.SharedData;
                this.Sequence.worker(n).getParametersFromWidget();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (!this.checkSequence()) {
                return false;
            }
            boolean bContainsConvergingPicker = false;
            int nIterations = 0;
            EnsembleWorker_Base convergingPicker = null;
            for (int n = 1; n < this.Sequence.size(); ++n) {
                EnsembleWorker_Base worker = this.Sequence.worker(n);
                if (!worker.ShortDescription.equals("CONVERGING_PICKER")) continue;
                bContainsConvergingPicker = true;
                worker.setParentSequence(this.Sequence);
                worker.readParameters(RefractionStaticsProject.singleton());
                nIterations = worker.getIterationCount();
                convergingPicker = worker;
            }
            if (convergingPicker == null) {
                while (this.m_inputWorker.hasMoreEnsembles() && !this.Halt) {
                    Ensemble ensemble = this.m_inputWorker.nextEnsemble();
                    for (int n = 1; n < this.Sequence.size(); ++n) {
                        EnsembleWorker_Base worker = this.Sequence.worker(n);
                        worker.performWork(ensemble);
                        ensemble = worker.output(0);
                    }
                    messageServer.setPercentDone(this.m_inputWorker.percentDone());
                    messageServer.setMessage_Level2(this.m_inputWorker.ActionString);
                }
                return true;
            }
            try {
                convergingPicker.setParentSequence(this.Sequence);
                convergingPicker.work_OverrideSequence(messageServer);
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                convergingPicker.setParentSequence(null);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

