/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.HybridGliDt;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Action_TableDataV2;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeMath;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.HybridGLI.HybridGliData;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_HybridGliDt_CreateModel
extends Action_Base {
    protected HybridGliData m_data;
    protected Grid3D RefractorElevationGrid;
    protected Grid3D SurfaceElevationGrid;
    protected Grid3D WeatheringVelocityGrid;
    protected Grid3D RefractorVelocityGrid;
    protected Grid3D WeatheringThicknessGrid;
    protected HashMap_Integers<Element> m_shotHash = new HashMap_Integers();
    protected HashMap_Integers<Element> m_recHash = new HashMap_Integers();
    protected double m_averageV0 = 2000.0;
    protected double m_preferredV0 = 2000.0;

    public Action_HybridGliDt_CreateModel() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create hybrid GLI - DT model";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
    }

    protected Element getShotElement(int row, int id) {
        try {
            if (!this.m_shotHash.containsKey(id)) {
                this.m_shotHash.put(new Element(row, id), id);
            }
            return this.m_shotHash.get(id);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected Element getRecElement(int row, int id) {
        try {
            if (!this.m_recHash.containsKey(id)) {
                this.m_recHash.put(new Element(row, id), id);
            }
            return this.m_recHash.get(id);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    protected void createTable(String tableName, HashMap_Integers<Element> hash) {
        try {
            IDatabaseConnection db = this.m_data.databaseConnection();
            db.dropTable(tableName);
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName(tableName);
            int indexID = ((Table_Abstract)table).column_append("ID", DataType.Int);
            int indexError = ((Table_Abstract)table).column_append("Residual", DataType.Double);
            int indexCount = ((Table_Abstract)table).column_append("TraceCount", DataType.Double);
            for (Element e : hash.getValues()) {
                int row = ((Table_Abstract)table).row_increment();
                ((Table_Abstract)table).putInt(row, indexID, e.ID);
                ((Table_Abstract)table).putDouble(row, indexError, e.AverageError);
                ((Table_Abstract)table).putDouble(row, indexCount, e.Count);
            }
            db.createDatabaseTable(table);
            db.appendTable(table, 0);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void computeElevation() {
        try {
            double z;
            double v1;
            double v0;
            int row;
            double sumV1 = 0.0;
            double count = 1.0E-20;
            Action_TableDataV2 table = this.DelayTimeData.Shot;
            for (row = 0; row < table.X.length; ++row) {
                if (!table.Alive[row]) continue;
                v0 = table.getVelocity(0, row);
                v1 = table.getVelocity(1, row);
                z = table.Z[row];
                this.SurfaceElevationGrid.interp_Add(table.X[row], table.Y[row], (float)z, 1.0f);
                this.RefractorVelocityGrid.interp_Add(table.X[row], table.Y[row], (float)v1, 1.0f);
                sumV1 += v1;
                count += 1.0;
            }
            table = this.DelayTimeData.Receiver;
            for (row = 0; row < table.X.length; ++row) {
                if (!table.Alive[row]) continue;
                v0 = table.getVelocity(0, row);
                v1 = table.getVelocity(1, row);
                z = table.Z[row];
                this.SurfaceElevationGrid.interp_Add(table.X[row], table.Y[row], (float)z, 1.0f);
                this.RefractorVelocityGrid.interp_Add(table.X[row], table.Y[row], (float)v1, 1.0f);
                sumV1 += v1;
                count += 1.0;
            }
            double avgV1 = sumV1 / count;
            this.m_averageV0 = this.m_preferredV0;
            this.m_averageV0 = Math.max(this.m_averageV0, 0.2 * avgV1);
            this.m_averageV0 = Math.min(this.m_averageV0, 0.8 * avgV1);
            this.m_averageV0 = this.m_preferredV0;
            this.WeatheringVelocityGrid.setValue((float)this.m_averageV0);
            this.SurfaceElevationGrid.interp_Finish(13);
            this.RefractorVelocityGrid.interp_Finish(13);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void updateRefractorElevation(float weight, double delayTime, double surfaceX, double surfaceY, double surfaceZ, double azimuth) {
        try {
            float refractorVel = this.RefractorVelocityGrid.getNearestValue(surfaceX, surfaceY);
            float averageV0 = (float)this.m_averageV0;
            double sin = Math.sin(azimuth);
            double cos = Math.cos(azimuth);
            delayTime = Math.max(delayTime, 2.0);
            delayTime = 0.001 * delayTime;
            double predictedThickness = delayTime * (double)(refractorVel * averageV0) / Math.sqrt(refractorVel * refractorVel - averageV0 * averageV0);
            double theta = Math.asin(averageV0 / refractorVel);
            double r = predictedThickness * Math.tan(theta);
            double refractorX = surfaceX + r * cos;
            double refractorY = surfaceY + r * sin;
            double refractorZ = surfaceZ - predictedThickness;
            this.RefractorElevationGrid.interp_Add(refractorX, refractorY, (float)refractorZ, weight);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (messageServer == null) {
                return false;
            }
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            this.m_data = project.hybridGliData();
            this.m_data.reset();
            this.m_preferredV0 = this.m_data.parameters().double_get("V0", 3000.0);
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            project.getDelayTimeData().branchAssignment().save(this.m_data.branchAssignmentFileName());
            this.m_data.branchAssignment().read(this.m_data.branchAssignmentFileName());
            this.SurfaceElevationGrid = this.m_data.getGrid("SurfaceElevation");
            this.RefractorElevationGrid = this.m_data.getGrid("FirstRefractorElevation");
            this.WeatheringVelocityGrid = this.m_data.getGrid("WeatheringVelocity");
            this.RefractorVelocityGrid = this.m_data.getGrid("FirstRefractorVelocity");
            this.WeatheringThicknessGrid = this.m_data.getGrid("WeatheringThickness");
            this.SurfaceElevationGrid.interp_Prep();
            this.RefractorElevationGrid.interp_Prep();
            this.RefractorVelocityGrid.interp_Prep();
            DelayTimeMath dtm = new DelayTimeMath();
            this.computeElevation();
            float weightScalar = 75.0f;
            float pi = (float)Math.PI;
            messageServer.setMessage_Level1("Create initial model");
            UpholeCorrection.Method method = project.getUpholeCorrectionMethod();
            this.DelayTimeData.Shot.computeUpholeCorrections(method);
            for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                if (killed == 0 && branch == 1 && pick >= 4.1f && pick <= 6000.1f) {
                    int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                    int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                    double sx = this.DelayTimeData.Shot.X[shotRow];
                    double sy = this.DelayTimeData.Shot.Y[shotRow];
                    double sz = this.DelayTimeData.Shot.Z[shotRow];
                    double rx = this.DelayTimeData.Receiver.X[recRow];
                    double ry = this.DelayTimeData.Receiver.Y[recRow];
                    double rz = this.DelayTimeData.Receiver.Z[recRow];
                    float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                    float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                    float averageVel = 0.5f * (shotVel + recVel);
                    float travelTime = 1000.0f * offset / averageVel;
                    float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow);
                    shotDT = Math.max(shotDT, 0.0f);
                    float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow);
                    recDT = Math.max(recDT, 0.0f);
                    float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                    float error = Math.abs((pick += upholeCorrection) - recDT - shotDT - travelTime);
                    float weight = weightScalar / (weightScalar + error);
                    weight = 1.0f + 100.0f * weight * weight;
                    dtm.setSingleLayerDT(recDT, this.m_averageV0, recVel);
                    double rrx = rx - dtm.OneLayerHorizontal * Math.cos(azimuth);
                    double rry = ry - dtm.OneLayerHorizontal * Math.sin(azimuth);
                    double rz1 = rz - dtm.OneLayerThickness;
                    this.RefractorElevationGrid.interp_Add(rrx, rry, (float)rz1, weight);
                    dtm.setSingleLayerDT(shotDT, this.m_averageV0, shotVel);
                    double srx = sx + dtm.OneLayerHorizontal * Math.cos(azimuth);
                    double sry = sy + dtm.OneLayerHorizontal * Math.sin(azimuth);
                    double sz1 = sz - dtm.OneLayerThickness;
                    this.RefractorElevationGrid.interp_Add(srx, sry, (float)sz1, weight);
                }
                if (row % 50000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)row / (double)sharedTraceTable.rowCount());
            }
            this.RefractorElevationGrid.interp_Finish(5);
            float[][] thick = this.WeatheringThicknessGrid.data();
            float[][] z1 = this.RefractorElevationGrid.data();
            float[][] z0 = this.SurfaceElevationGrid.data();
            messageServer.setMessage_Level1("Update the refractor elevation");
            int niter = 3;
            double totalScan = (double)niter * (double)sharedTraceTable.rowCount();
            double numScan = 0.0;
            Grid3D tempElevGrid = new Grid3D(this.RefractorElevationGrid);
            for (int iter = 0; iter < niter; ++iter) {
                int y;
                int x;
                double totalError = 0.0;
                double errorTraceCount = 1.0E-4;
                this.RefractorElevationGrid.interp_Prep(0);
                for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                    float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                    float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                    float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                    int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                    int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                    if (killed == 0 && branch == 1 && pick >= 0.1f && pick <= 6000.1f) {
                        int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                        int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                        double sx = this.DelayTimeData.Shot.X[shotRow];
                        double sy = this.DelayTimeData.Shot.Y[shotRow];
                        double sz = this.DelayTimeData.Shot.Z[shotRow];
                        double rx = this.DelayTimeData.Receiver.X[recRow];
                        double ry = this.DelayTimeData.Receiver.Y[recRow];
                        double rz = this.DelayTimeData.Receiver.Z[recRow];
                        float shotVel0 = this.WeatheringVelocityGrid.getNearestValue(sx, sy);
                        float recVel0 = this.WeatheringVelocityGrid.getNearestValue(rx, ry);
                        float shotVel = this.RefractorVelocityGrid.getNearestValue(sx, sy);
                        float recVel = this.RefractorVelocityGrid.getNearestValue(rx, ry);
                        float averageVel = 0.5f * (shotVel + recVel);
                        float currentShotDT = (float)this.m_data.computeDelayTime(sx, sy, sz, azimuth);
                        float currentRecDT = (float)this.m_data.computeDelayTime(rx, ry, rz, azimuth + pi);
                        float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                        float travelTime = 1000.0f * offset / averageVel;
                        float currentError = Math.abs((pick += upholeCorrection) - currentShotDT - currentRecDT - travelTime);
                        totalError += (double)currentError;
                        errorTraceCount += 1.0;
                        float weight = weightScalar / (weightScalar + currentError);
                        float desiredDelayTimeAtShot = pick - currentRecDT - travelTime;
                        desiredDelayTimeAtShot = Math.max(desiredDelayTimeAtShot, 2.0f);
                        this.updateRefractorElevation(weight, desiredDelayTimeAtShot, sx, sy, sz, azimuth);
                        float desiredDelayTimeAtRec = pick - currentShotDT - travelTime;
                        desiredDelayTimeAtRec = Math.max(desiredDelayTimeAtRec, 2.0f);
                        this.updateRefractorElevation(weight, desiredDelayTimeAtRec, rx, ry, rz, azimuth + pi);
                    }
                    if (row % 50000L == 0L) {
                        double avgError = totalError / errorTraceCount;
                        String msg = String.format("Iteration %d of %d,   Average error = %f", iter + 1, niter, Float.valueOf((float)avgError));
                        messageServer.setMessage_Level2(msg);
                        messageServer.setPercentDone(100.0 * numScan / totalScan);
                    }
                    numScan += 1.0;
                }
                this.RefractorElevationGrid.interp_Finish(5, false);
                float[][] g1 = this.RefractorElevationGrid.data();
                float[][] g2 = tempElevGrid.data();
                float[][] surface = this.SurfaceElevationGrid.data();
                float fracChange = 0.6f;
                for (x = 0; x < g1.length; ++x) {
                    for (y = 0; y < g1[x].length; ++y) {
                        float change = g1[x][y] - g2[x][y];
                        g1[x][y] = g2[x][y] + fracChange * change;
                        g1[x][y] = Math.min(g1[x][y], surface[x][y]);
                    }
                }
                this.RefractorElevationGrid.smooth(5);
                for (x = 0; x < g1.length; ++x) {
                    for (y = 0; y < g1[x].length; ++y) {
                        g2[x][y] = g1[x][y];
                    }
                }
            }
            for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                if (killed == 0 && branch == 1 && pick >= 0.1f && pick <= 6000.1f) {
                    int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                    int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                    int shotID = this.DelayTimeData.Shot.ID[shotRow];
                    int recID = this.DelayTimeData.Receiver.ID[recRow];
                    Element recElem = this.getRecElement(recRow, recID);
                    Element shotElem = this.getShotElement(shotRow, shotID);
                    double sx = this.DelayTimeData.Shot.X[shotRow];
                    double sy = this.DelayTimeData.Shot.Y[shotRow];
                    double sz = this.DelayTimeData.Shot.Z[shotRow];
                    double rx = this.DelayTimeData.Receiver.X[recRow];
                    double ry = this.DelayTimeData.Receiver.Y[recRow];
                    double rz = this.DelayTimeData.Receiver.Z[recRow];
                    float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                    float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                    float averageVel = 0.5f * (shotVel + recVel);
                    float currentShotDT = (float)this.m_data.computeDelayTime(sx, sy, sz, azimuth);
                    float currentRecDT = (float)this.m_data.computeDelayTime(rx, ry, rz, azimuth + pi);
                    float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                    float travelTime = 1000.0f * offset / averageVel;
                    float currentError = (pick += upholeCorrection) - currentShotDT - currentRecDT - travelTime;
                    recElem.addError(currentError);
                    shotElem.addError(currentError);
                }
                if (row % 50000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)row / (double)sharedTraceTable.rowCount());
            }
            for (Element e : this.m_recHash.getValues()) {
                e.AverageError = e.SumError / e.Count;
            }
            for (Element e : this.m_shotHash.getValues()) {
                e.AverageError = e.SumError / e.Count;
            }
            this.createTable("Shot", this.m_shotHash);
            this.createTable("Receiver", this.m_recHash);
            this.m_data.reloadTable();
            for (int x = 0; x < thick.length; ++x) {
                for (int y = 0; y < thick[x].length; ++y) {
                    thick[x][y] = z0[x][y] - z1[x][y];
                }
            }
            this.m_data.computeElevationChange();
            this.m_data.saveGrids();
            this.SurfaceElevationGrid.interp_Free();
            this.RefractorElevationGrid.interp_Free();
            this.WeatheringVelocityGrid.interp_Free();
            this.RefractorVelocityGrid.interp_Free();
            this.WeatheringThicknessGrid.interp_Free();
            this.m_data.reloadModelRangeTable();
            System.gc();
            System.gc();
            System.gc();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected class Element {
        public int ID;
        public int Row;
        public double SumError = 0.0;
        public double Count = 1.0E-20;
        public double AverageError = 0.0;

        public Element(int row, int id) {
            this.Row = row;
            this.ID = id;
        }

        public void addError(float error) {
            this.SumError += (double)error;
            this.Count += 1.0;
        }
    }
}

