/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Refraction.DelayTime;

import com.PecosCore.Data.History;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Math.Grid3D;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeData;
import com.PecosLibrary.Refraction.DelayTime.UpholeCorrection;
import com.PecosLibrary.Refraction.DelayTime.WaterBottomCorrection;
import com.PecosLibrary.Refraction.RefractionStaticsProject;

public class Action_DelayTime_DelayTimeUpdate
extends Action_Base {
    protected Grid3D m_smoothGrid;
    public boolean UseErrorCornerFromUser = false;
    public double UserErrorCorner = 200.0;
    public boolean UpdateShot = true;
    public boolean UpdateRec = true;
    public boolean ForceNearbyToBeTheSame = false;
    public double NearbyDistance = 30.0;
    protected HashMap_Integers<NearbyEntry> m_nearHash = new HashMap_Integers();
    public boolean InterpolateUsingInverseSquare = false;

    public Action_DelayTime_DelayTimeUpdate() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Delay time update";
        this.RequiresDelayTimeData = true;
        this.MemoryRequired = 512;
        this.RequiresCompleteTraceTable = false;
        this.DelayTimeDataModified = true;
    }

    protected void smooth(int branch) {
        try {
            float dt;
            int n;
            this.m_smoothGrid.interp_ZeroArrays();
            double[] x = this.DelayTimeData.Receiver.X;
            double[] y = this.DelayTimeData.Receiver.Y;
            float[][] w = this.DelayTimeData.Receiver.Count;
            for (n = 0; n < x.length; ++n) {
                dt = this.DelayTimeData.Receiver.getDelayTime(branch, n);
                this.m_smoothGrid.interp_Add(x[n], y[n], dt, w[n][branch]);
            }
            x = this.DelayTimeData.Shot.X;
            y = this.DelayTimeData.Shot.Y;
            w = this.DelayTimeData.Shot.Count;
            for (n = 0; n < x.length; ++n) {
                dt = this.DelayTimeData.Shot.getDelayTime(branch, n);
                this.m_smoothGrid.interp_Add(x[n], y[n], dt, w[n][branch]);
            }
            this.m_smoothGrid.interp_Finish(3);
            if (this.UpdateRec) {
                x = this.DelayTimeData.Receiver.X;
                y = this.DelayTimeData.Receiver.Y;
                for (n = 0; n < x.length; ++n) {
                    dt = this.m_smoothGrid.getNearestValue(x[n], y[n]);
                    this.DelayTimeData.Receiver.setDelayTime(branch, n, dt);
                }
            }
            if (this.UpdateShot) {
                x = this.DelayTimeData.Shot.X;
                y = this.DelayTimeData.Shot.Y;
                for (n = 0; n < x.length; ++n) {
                    dt = this.m_smoothGrid.getNearestValue(x[n], y[n]);
                    this.DelayTimeData.Shot.setDelayTime(branch, n, dt);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void smooth() {
        try {
            for (int branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                this.smooth(branch);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            UpholeCorrection.Method upholeMethod = project.getUpholeCorrectionMethod();
            WaterBottomCorrection.Method waterBottomMethod = project.getWaterDepthCorrectionMethod();
            System.out.println("DT work: upholeMethod = " + upholeMethod.Description);
            TraceTable_Huge sharedTraceTable = this.DelayTimeData.SharedTraceTable;
            DelayTimeData dtd = project.getDelayTimeData();
            this.m_smoothGrid = project.units_feet() ? project.getEmptyGrid3D(300.0, 600.0, 600.0) : project.getEmptyGrid3D(100.0, 200.0, 200.0);
            this.m_smoothGrid.interp_Prep();
            boolean resetDelayTimes = this.Hasher.bool_get("ResetDelayTimes", true);
            boolean useAnisotropy = this.Hasher.bool_get("UseAnisotropy", false);
            boolean EnsureNoDCBias = this.Hasher.bool_get("EnsureNoDCBias", true);
            EnsureNoDCBias = EnsureNoDCBias && this.UpdateShot && this.UpdateRec;
            int iterCount = this.Hasher.int_get("IterationCount", 12);
            iterCount = Math.max(iterCount, 6);
            iterCount = Math.min(iterCount, 25);
            double totalRows = 1.0 * (double)iterCount * (double)sharedTraceTable.rowCount();
            double totalRowsViewed = 0.0;
            float weightScalar = 200.0f;
            this.DelayTimeData.Receiver.clearSummationArrays(resetDelayTimes);
            this.DelayTimeData.Shot.clearSummationArrays(resetDelayTimes);
            float avgError = 0.0f;
            if (this.ComputingShearWaveDelayTimes) {
                iterCount = 1;
            }
            for (int iteration = 1; iteration <= iterCount; ++iteration) {
                this.DelayTimeData.Shot.clearWaterBottomCorrections();
                this.DelayTimeData.Receiver.clearWaterBottomCorrections();
                if (waterBottomMethod == WaterBottomCorrection.Method.VerticalTime) {
                    this.DelayTimeData.Shot.computeWaterBottomCorrections(WaterBottomCorrection.Method.VerticalTime);
                    this.DelayTimeData.Receiver.computeWaterBottomCorrections(WaterBottomCorrection.Method.VerticalTime);
                }
                if (waterBottomMethod == WaterBottomCorrection.Method.RaypathCorrection) {
                    if (iteration < 4) {
                        this.DelayTimeData.Shot.computeWaterBottomCorrections(WaterBottomCorrection.Method.VerticalTime);
                        this.DelayTimeData.Receiver.computeWaterBottomCorrections(WaterBottomCorrection.Method.VerticalTime);
                    } else {
                        this.DelayTimeData.Shot.computeWaterBottomCorrections(WaterBottomCorrection.Method.RaypathCorrection);
                        this.DelayTimeData.Receiver.computeWaterBottomCorrections(WaterBottomCorrection.Method.RaypathCorrection);
                    }
                }
                this.DelayTimeData.Shot.clearUpholeCorrections();
                if (upholeMethod == UpholeCorrection.Method.JustUseUpholeTime) {
                    this.DelayTimeData.Shot.computeUpholeCorrections(UpholeCorrection.Method.JustUseUpholeTime);
                }
                if (upholeMethod == UpholeCorrection.Method.SoftwareDeterminesBest) {
                    if (iteration < 4) {
                        this.DelayTimeData.Shot.computeUpholeCorrections(UpholeCorrection.Method.JustUseUpholeTime);
                    } else {
                        this.DelayTimeData.Shot.computeUpholeCorrections(UpholeCorrection.Method.SoftwareDeterminesBest);
                    }
                }
                messageServer.setMessage_Level1(String.format("Iteration %d of %d", iteration, iterCount));
                double numValid = 1.0E-10;
                double sumError = 0.0;
                this.DelayTimeData.Receiver.clearSummationArrays(false);
                this.DelayTimeData.Shot.clearSummationArrays(false);
                if (this.UseErrorCornerFromUser) {
                    weightScalar = (float)this.UserErrorCorner;
                }
                Table_Abstract shotTable = RefractionStaticsProject.singleton().getShotTable();
                Table_Abstract recTable = RefractionStaticsProject.singleton().getRecTable();
                int indexShotKilled = shotTable.column_indexOfColumn("Killed");
                int indexRecKilled = recTable.column_indexOfColumn("Killed");
                for (long row = 0L; row < sharedTraceTable.rowCount(); ++row) {
                    totalRowsViewed += 1.0;
                    float offset = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexOffset);
                    float azimuth = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexAzimuth);
                    float pick = sharedTraceTable.getFloat(row, this.DelayTimeData.IndexUserPick);
                    int branch = sharedTraceTable.getInt(row, this.DelayTimeData.IndexBranchUser);
                    int killed = sharedTraceTable.getInt(row, this.DelayTimeData.IndexKilled);
                    int shotRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexShotRow);
                    int recRow = sharedTraceTable.getInt(row, this.DelayTimeData.IndexRecRow);
                    if (shotTable.getBool(shotRow, indexShotKilled)) {
                        killed = 1;
                    }
                    if (recTable.getBool(recRow, indexRecKilled)) {
                        killed = 1;
                    }
                    if (killed == 0 && branch >= 1 && branch <= this.DelayTimeData.MaxBranch && pick < 6000.0f && pick >= 1.0f) {
                        float shotVel = this.DelayTimeData.Shot.getVelocity(branch, shotRow);
                        float recVel = this.DelayTimeData.Receiver.getVelocity(branch, recRow);
                        float averageVel = 0.5f * (shotVel + recVel);
                        float travelTime = 1000.0f * offset / averageVel;
                        if (this.UseGriddedVelocity) {
                            double sx = this.DelayTimeData.Shot.X[shotRow];
                            double sy = this.DelayTimeData.Shot.Y[shotRow];
                            double rx = this.DelayTimeData.Receiver.X[recRow];
                            double ry = this.DelayTimeData.Receiver.Y[recRow];
                            travelTime = dtd.grid_time_noanisotropy(branch, sx, sy, rx, ry);
                        }
                        float shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow);
                        if (useAnisotropy) {
                            shotDT = this.DelayTimeData.Shot.getDelayTime(branch, shotRow, azimuth, true, false);
                        }
                        shotDT = Math.max(shotDT, 0.0f);
                        float recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow);
                        if (useAnisotropy) {
                            recDT = this.DelayTimeData.Receiver.getDelayTime(branch, recRow, azimuth, true, false);
                        }
                        recDT = Math.max(recDT, 0.0f);
                        float upholeCorrection = this.DelayTimeData.Shot.UpholeCorrectionTime[shotRow][branch];
                        float shotWbCorrection = this.DelayTimeData.Shot.WaterBottomCorrectionTime[shotRow][branch];
                        float recWbCorrection = this.DelayTimeData.Receiver.WaterBottomCorrectionTime[recRow][branch];
                        pick = pick + upholeCorrection + shotWbCorrection + recWbCorrection;
                        float error = Math.abs(pick - recDT - shotDT - travelTime);
                        float weight = weightScalar / (weightScalar + error);
                        weight *= weight;
                        float predictedShotDT = pick - travelTime - recDT;
                        predictedShotDT = Math.max(predictedShotDT, 0.0f);
                        float[] fArray = this.DelayTimeData.Shot.UpdateSum[shotRow];
                        int n = branch;
                        fArray[n] = fArray[n] + weight * predictedShotDT;
                        float[] fArray2 = this.DelayTimeData.Shot.ErrorSum[shotRow];
                        int n2 = branch;
                        fArray2[n2] = fArray2[n2] + error;
                        float[] fArray3 = this.DelayTimeData.Shot.WeightSum[shotRow];
                        int n3 = branch;
                        fArray3[n3] = fArray3[n3] + weight;
                        float[] fArray4 = this.DelayTimeData.Shot.Count[shotRow];
                        int n4 = branch;
                        fArray4[n4] = fArray4[n4] + 1.0f;
                        float predictedRecDT = pick - travelTime - shotDT;
                        predictedRecDT = Math.max(predictedRecDT, 0.0f);
                        float[] fArray5 = this.DelayTimeData.Receiver.UpdateSum[recRow];
                        int n5 = branch;
                        fArray5[n5] = fArray5[n5] + weight * predictedRecDT;
                        float[] fArray6 = this.DelayTimeData.Receiver.ErrorSum[recRow];
                        int n6 = branch;
                        fArray6[n6] = fArray6[n6] + error;
                        float[] fArray7 = this.DelayTimeData.Receiver.WeightSum[recRow];
                        int n7 = branch;
                        fArray7[n7] = fArray7[n7] + weight;
                        float[] fArray8 = this.DelayTimeData.Receiver.Count[recRow];
                        int n8 = branch;
                        fArray8[n8] = fArray8[n8] + 1.0f;
                        numValid += 1.0;
                        sumError += (double)error;
                    }
                    if (row % 50000L != 0L) continue;
                    String s = String.format("Trace %d of %d, average error = %f", row, sharedTraceTable.rowCount(), Float.valueOf((float)(sumError / numValid)));
                    messageServer.setMessage_Level2(s);
                    messageServer.setPercentDone(100.0 * totalRowsViewed / totalRows);
                }
                avgError = (float)(sumError / (1.0 + numValid));
                if (this.UpdateShot) {
                    this.DelayTimeData.Shot.computeDelayTimeUsingArrays(iteration);
                }
                if (this.UpdateRec) {
                    this.DelayTimeData.Receiver.computeDelayTimeUsingArrays(iteration);
                }
                weightScalar = avgError;
                weightScalar = Math.max(weightScalar, 20.0f);
                weightScalar = Math.min(weightScalar, 100.0f);
                if (iteration <= 5) {
                    weightScalar = Math.max(weightScalar, 40.0f);
                }
                messageServer.setMessage_Level2("Interpolate... ");
                if (iteration <= 3 && !this.ComputingShearWaveDelayTimes) {
                    this.smooth();
                }
                for (int branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                    this.interpolate(branch);
                }
                if (this.ForceNearbyToBeTheSame && !this.ComputingShearWaveDelayTimes) {
                    this.forceNearbyToBeTheSame();
                }
                if (EnsureNoDCBias && this.UpdateShot && this.UpdateRec) {
                    this.DelayTimeData.ensureNoBias(EnsureNoDCBias);
                }
                if (this.UpdateShot) {
                    this.DelayTimeData.Shot.ensureDelayTimesIncrease();
                }
                if (!this.UpdateRec) continue;
                this.DelayTimeData.Receiver.ensureDelayTimesIncrease();
            }
            this.DelayTimeData.Shot.Modified_DelayTime = this.UpdateShot;
            this.DelayTimeData.Receiver.Modified_DelayTime = this.UpdateRec;
            this.DelayTimeData.Shot.Modified_Count = this.UpdateShot;
            this.DelayTimeData.Receiver.Modified_Count = this.UpdateRec;
            this.DelayTimeData.Shot.Modified_Error = this.UpdateShot;
            this.DelayTimeData.Receiver.Modified_Error = this.UpdateRec;
            History hist = project.getDelayTimeData().getHistory();
            hist.addWithTime("Delay time analysis completed");
            if (useAnisotropy) {
                hist.add("Anisotropy used");
            } else {
                hist.add("Anisotropy not used");
            }
            if (!this.UpdateShot) {
                hist.add("Shot delay times were NOT updated!");
            }
            if (!this.UpdateRec) {
                hist.add("Receiver delay times were NOT updated!");
            }
            if (this.ForceNearbyToBeTheSame) {
                hist.add("Nearby shots/receivers forced to have same result, distance: " + Double.toString(this.NearbyDistance));
            }
            hist.add("Average error (milliseconds) = " + Float.toString(avgError));
            hist.save();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void forceNearbyToBeTheSame() {
        try {
            int branch;
            NearbyEntry ne;
            int iy;
            int ix;
            int n;
            for (NearbyEntry ne2 : this.m_nearHash.getValues()) {
                for (int n2 = 0; n2 < ne2.Sum1.length; ++n2) {
                    ne2.Sum1[n2] = 0.0;
                    ne2.DT[n2] = 0.0;
                    ne2.Sum2[n2] = 1.0E-20;
                }
            }
            double[] x = this.DelayTimeData.Receiver.X;
            double[] y = this.DelayTimeData.Receiver.Y;
            boolean[] alive = this.DelayTimeData.Receiver.Alive;
            float[][] count = this.DelayTimeData.Receiver.Count;
            for (n = 0; n < x.length; ++n) {
                if (!alive[n]) continue;
                ix = (int)(0.5 + x[n] / this.NearbyDistance);
                iy = (int)(0.5 + y[n] / this.NearbyDistance);
                if (!this.m_nearHash.containsKey(ix, iy)) {
                    this.m_nearHash.put(new NearbyEntry(), ix, iy);
                }
                ne = this.m_nearHash.get(ix, iy);
                for (branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                    if (!(count[n][branch] > 0.5f)) continue;
                    int n3 = branch;
                    ne.Sum1[n3] = ne.Sum1[n3] + (double)this.DelayTimeData.Receiver.getDelayTime(branch, n);
                    int n4 = branch;
                    ne.Sum2[n4] = ne.Sum2[n4] + 1.0;
                }
            }
            x = this.DelayTimeData.Shot.X;
            y = this.DelayTimeData.Shot.Y;
            alive = this.DelayTimeData.Shot.Alive;
            count = this.DelayTimeData.Shot.Count;
            for (n = 0; n < x.length; ++n) {
                if (!alive[n]) continue;
                ix = (int)(0.5 + x[n] / this.NearbyDistance);
                iy = (int)(0.5 + y[n] / this.NearbyDistance);
                if (!this.m_nearHash.containsKey(ix, iy)) {
                    this.m_nearHash.put(new NearbyEntry(), ix, iy);
                }
                ne = this.m_nearHash.get(ix, iy);
                for (branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                    if (!(count[n][branch] > 0.5f)) continue;
                    int n5 = branch;
                    ne.Sum1[n5] = ne.Sum1[n5] + (double)this.DelayTimeData.Shot.getDelayTime(branch, n);
                    int n6 = branch;
                    ne.Sum2[n6] = ne.Sum2[n6] + 1.0;
                }
            }
            for (NearbyEntry ne3 : this.m_nearHash.getValues()) {
                for (int n7 = 0; n7 < ne3.Sum1.length; ++n7) {
                    ne3.DT[n7] = ne3.Sum1[n7] / ne3.Sum2[n7];
                }
            }
            if (this.UpdateRec) {
                x = this.DelayTimeData.Receiver.X;
                y = this.DelayTimeData.Receiver.Y;
                alive = this.DelayTimeData.Receiver.Alive;
                for (int n8 = 0; n8 < x.length; ++n8) {
                    if (!alive[n8]) continue;
                    int ix2 = (int)(0.5 + x[n8] / this.NearbyDistance);
                    iy = (int)(0.5 + y[n8] / this.NearbyDistance);
                    ne = this.m_nearHash.get(ix2, iy);
                    for (branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                        if (Double.isInfinite(ne.DT[branch]) || Double.isNaN(ne.DT[branch])) {
                            this.DelayTimeData.Receiver.setDelayTime(branch, n8, 0.0f);
                            continue;
                        }
                        this.DelayTimeData.Receiver.setDelayTime(branch, n8, (float)ne.DT[branch]);
                    }
                }
            }
            if (this.UpdateShot) {
                x = this.DelayTimeData.Shot.X;
                y = this.DelayTimeData.Shot.Y;
                alive = this.DelayTimeData.Shot.Alive;
                for (int n9 = 0; n9 < x.length; ++n9) {
                    if (!alive[n9]) continue;
                    int ix3 = (int)(0.5 + x[n9] / this.NearbyDistance);
                    iy = (int)(0.5 + y[n9] / this.NearbyDistance);
                    ne = this.m_nearHash.get(ix3, iy);
                    for (branch = 1; branch <= this.DelayTimeData.MaxBranch; ++branch) {
                        if (Double.isInfinite(ne.DT[branch]) || Double.isNaN(ne.DT[branch])) {
                            this.DelayTimeData.Shot.setDelayTime(branch, n9, 0.0f);
                            continue;
                        }
                        this.DelayTimeData.Shot.setDelayTime(branch, n9, (float)ne.DT[branch]);
                    }
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void interpolate(int branch) throws Exception {
        try {
            if (this.InterpolateUsingInverseSquare) {
                this.interpolate_inversesquare(branch);
                return;
            }
            this.interpolate_grid(branch);
            return;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void interpolate_grid(int branch) throws Exception {
        try {
            float dt;
            int n;
            int numShot = this.DelayTimeData.Shot.Table.row_count();
            int numRec = this.DelayTimeData.Receiver.Table.row_count();
            float minAllowedCount = RefractionStaticsProject.singleton().getMinimumValidBranchPickFold();
            this.DelayTimeData.Shot.findCountRange(branch);
            this.DelayTimeData.Receiver.findCountRange(branch);
            float maxCount = Math.max(this.DelayTimeData.Shot.MaximumCount, this.DelayTimeData.Receiver.MaximumCount);
            float minCount = Math.min(this.DelayTimeData.Shot.MinimumCount, this.DelayTimeData.Receiver.MinimumCount);
            if (minCount >= 5.0f) {
                return;
            }
            if (maxCount <= minAllowedCount) {
                return;
            }
            float minDT = 5.0f;
            this.m_smoothGrid.interp_ZeroArrays();
            double[] x = this.DelayTimeData.Receiver.X;
            double[] y = this.DelayTimeData.Receiver.Y;
            boolean[] alive = this.DelayTimeData.Receiver.Alive;
            float[][] w = this.DelayTimeData.Receiver.Count;
            for (n = 0; n < x.length; ++n) {
                if (!alive[n] || !(w[n][branch] > minAllowedCount)) continue;
                dt = this.DelayTimeData.Receiver.getDelayTime(branch, n);
                this.m_smoothGrid.interp_Add(x[n], y[n], dt, w[n][branch]);
                if (!(dt < minDT)) continue;
                minDT = dt;
            }
            if (!this.ComputingShearWaveDelayTimes) {
                x = this.DelayTimeData.Shot.X;
                y = this.DelayTimeData.Shot.Y;
                alive = this.DelayTimeData.Shot.Alive;
                w = this.DelayTimeData.Shot.Count;
                for (n = 0; n < x.length; ++n) {
                    if (!alive[n] || !(w[n][branch] > minAllowedCount)) continue;
                    dt = this.DelayTimeData.Shot.getDelayTime(branch, n);
                    this.m_smoothGrid.interp_Add(x[n], y[n], dt, w[n][branch]);
                    if (!(dt < minDT)) continue;
                    minDT = dt;
                }
            }
            this.m_smoothGrid.interp_Finish(3);
            minDT = 5.0f;
            if (this.UpdateRec) {
                x = this.DelayTimeData.Receiver.X;
                y = this.DelayTimeData.Receiver.Y;
                alive = this.DelayTimeData.Receiver.Alive;
                w = this.DelayTimeData.Receiver.Count;
                for (n = 0; n < x.length; ++n) {
                    if (alive[n] && !(w[n][branch] < minAllowedCount)) continue;
                    dt = this.m_smoothGrid.getNearestValue(x[n], y[n]);
                    this.DelayTimeData.Receiver.setDelayTime(branch, n, dt);
                    if (!(dt < minDT)) continue;
                    minDT = dt;
                }
            }
            if (this.UpdateShot) {
                x = this.DelayTimeData.Shot.X;
                y = this.DelayTimeData.Shot.Y;
                alive = this.DelayTimeData.Shot.Alive;
                w = this.DelayTimeData.Shot.Count;
                for (n = 0; n < x.length; ++n) {
                    if (alive[n] && !(w[n][branch] < minAllowedCount)) continue;
                    dt = this.m_smoothGrid.getNearestValue(x[n], y[n]);
                    this.DelayTimeData.Shot.setDelayTime(branch, n, dt);
                    if (!(dt < minDT)) continue;
                    minDT = dt;
                }
            }
            System.err.println("minDt = " + minDT);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void interpolate_inversesquare(int branch) throws Exception {
        try {
            float dt;
            double sum2;
            double sum1;
            double y;
            double x;
            float count;
            int row;
            int numShot = this.DelayTimeData.Shot.Table.row_count();
            int numRec = this.DelayTimeData.Receiver.Table.row_count();
            float minAllowedCount = 4.0f;
            this.DelayTimeData.Shot.findCountRange(branch);
            this.DelayTimeData.Receiver.findCountRange(branch);
            float maxCount = Math.max(this.DelayTimeData.Shot.MaximumCount, this.DelayTimeData.Receiver.MaximumCount);
            float minCount = Math.min(this.DelayTimeData.Shot.MinimumCount, this.DelayTimeData.Receiver.MinimumCount);
            if (minCount >= 5.0f) {
                return;
            }
            if (maxCount <= minAllowedCount) {
                return;
            }
            if (this.UpdateRec) {
                for (row = 0; row < numRec; ++row) {
                    count = this.DelayTimeData.Receiver.Count[row][branch];
                    if (!(count < minAllowedCount) && this.DelayTimeData.Receiver.Alive[row]) continue;
                    x = this.DelayTimeData.Receiver.X[row];
                    y = this.DelayTimeData.Receiver.Y[row];
                    sum1 = 0.0;
                    sum2 = 1.0E-60;
                    if (!this.ComputingShearWaveDelayTimes) {
                        this.DelayTimeData.Shot.computeInterpolatedDelayTime(x, y, minAllowedCount, branch);
                        sum1 += this.DelayTimeData.Shot.SumTop;
                        sum2 += this.DelayTimeData.Shot.SumBottom;
                    }
                    this.DelayTimeData.Receiver.computeInterpolatedDelayTime(x, y, minAllowedCount, branch);
                    dt = (float)((sum1 += this.DelayTimeData.Receiver.SumTop) / (sum2 += this.DelayTimeData.Receiver.SumBottom));
                    this.DelayTimeData.Receiver.setDelayTime(branch, row, dt);
                }
            }
            if (this.UpdateShot) {
                for (row = 0; row < numShot; ++row) {
                    count = this.DelayTimeData.Shot.Count[row][branch];
                    if (!(count < minAllowedCount) && this.DelayTimeData.Shot.Alive[row]) continue;
                    x = this.DelayTimeData.Shot.X[row];
                    y = this.DelayTimeData.Shot.Y[row];
                    sum1 = 0.0;
                    sum2 = 1.0E-60;
                    this.DelayTimeData.Shot.computeInterpolatedDelayTime(x, y, minAllowedCount, branch);
                    sum1 += this.DelayTimeData.Shot.SumTop;
                    sum2 += this.DelayTimeData.Shot.SumBottom;
                    this.DelayTimeData.Receiver.computeInterpolatedDelayTime(x, y, minAllowedCount, branch);
                    dt = (float)((sum1 += this.DelayTimeData.Receiver.SumTop) / (sum2 += this.DelayTimeData.Receiver.SumBottom));
                    this.DelayTimeData.Shot.setDelayTime(branch, row, dt);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected class NearbyEntry {
        public double[] DT = new double[6];
        public double[] Sum1 = new double[6];
        public double[] Sum2 = new double[6];

        protected NearbyEntry() {
        }
    }
}

