/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.JDBC;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;

public class Action_TraceTableSQL
extends Action_Base {
    public Action_TraceTableSQL() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Update trace table using SQL";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            Object sql = this.Hasher.string_get("SQL", "");
            ArrayList<String> tokens = Tools_Strings.tokenizer_improved((String)sql, '=');
            if (tokens.size() < 2) {
                return false;
            }
            String columnName = Tools_Strings.removeSpace(tokens.get(0));
            System.out.println("columnName =  " + columnName);
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            if (!traceTable.column_exists(columnName)) {
                System.out.println("DOES NOT EXIST columnName =  " + columnName);
                return false;
            }
            messageServer.setMessage_Level1("Scan trace table");
            Table_Memory table = new Table_Memory();
            ((Table_Abstract)table).setName("Trace");
            int chunk = 5000;
            sql = "UPDATE TRACE SET " + (String)sql;
            String extractSQL = "SELECT " + columnName + " FROM Trace";
            for (long start = 0L; start < traceTable.rowCount() && !this.Halt; start += (long)chunk) {
                messageServer.setPercentDone(100.0 * (double)start / (double)traceTable.rowCount());
                ((Table_Abstract)table).row_clear(false);
                traceTable.populateTable(table, start, chunk);
                IDatabaseConnection conn = Tools_JDBC.getConnection(true, "TraceDatabase");
                conn.createDatabaseTable(table);
                conn.appendTable(table, 0);
                conn.executeUpdateStatement((String)sql);
                Table_Abstract output = conn.extractTableDataUsingQuery("Trace", extractSQL, chunk + 1000);
                int indexTraceTable = traceTable.column_indexOfColumn(columnName);
                DataType type = traceTable.column_type(indexTraceTable);
                int indexMemTable = output.column_indexOfColumn(columnName);
                int numOutputRows = output.row_count();
                for (int n = 0; n < numOutputRows; ++n) {
                    if (type == DataType.Float || type == DataType.Float) {
                        float v = output.getFloat(n, indexMemTable);
                        traceTable.putFloat((long)n + start, indexTraceTable, v);
                        continue;
                    }
                    int v = output.getInt(n, indexMemTable);
                    traceTable.putInt((long)n + start, indexTraceTable, v);
                }
                conn.dropTable("Trace");
                conn.closeConnection();
                conn = null;
                System.gc();
                System.gc();
                System.gc();
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

