/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Import;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Geometry.CdpParser;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Date;

public class Action_ImportSegyAvo
extends Action_Base {
    protected String m_parentPath = "";
    protected String m_projectName = "";
    protected String m_projectPath = "";
    protected String m_traceTablePath = "";
    protected ArrayList<String> m_segyFileList = null;
    protected ArrayList<Segy> m_segyList = new ArrayList();
    protected long m_totalTraces = 0L;
    protected long m_numRead = 0L;
    protected Segy_Dictionary m_dict = new Segy_Dictionary();
    protected boolean m_useCDP = true;
    protected Table_Abstract m_cdpTable = new Table_Memory();
    protected CdpParser m_cdpParser;
    protected Table_Abstract m_fileTable = new Table_Memory();
    protected int m_fileIndex_FileID;
    protected int m_fileIndex_Name;
    protected int m_fileIndex_Path;
    protected TraceTable_Huge m_diskTable;
    protected long m_traceCount = 0L;
    protected int m_fileID = 999;
    protected long m_traceID = 999L;
    protected double m_offsetIncrement = 25.0;
    protected ArrayList<OffsetBin> m_muteEndBins = new ArrayList();
    protected ArrayList<OffsetBin> m_muteStartBins = new ArrayList();

    public Action_ImportSegyAvo() {
        this.Description = "Create AVO project using seg-y files";
        this.MemoryRequired = 1024;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected boolean prepareTables() {
        try {
            this.m_fileTable.setName("FileList");
            this.m_fileIndex_FileID = this.m_fileTable.column_append("FileID", DataType.Int);
            this.m_fileIndex_Name = this.m_fileTable.column_append("Name", DataType.Text);
            this.m_fileIndex_Path = this.m_fileTable.column_append("Directory", DataType.Text);
            this.m_traceTablePath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "TraceTable");
            this.m_cdpTable.setName("CDP");
            this.m_cdpParser = new CdpParser(this.m_cdpTable, this.m_useCDP);
            this.m_cdpParser.IgnoreTraceCode = true;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkFiles() {
        try {
            if (!this.Hasher.stringList_exists("FileList")) {
                this.FailureReason = "SEG-Y file list not specified";
                this.Failed = true;
                return false;
            }
            this.m_segyFileList = this.Hasher.stringList_get("FileList");
            for (String fileName : this.m_segyFileList) {
                Segy segy = new Segy();
                segy.setFileName(fileName);
                if (!segy.isFileOK()) continue;
                segy.setSegyDictionary(this.m_dict);
                this.m_segyList.add(segy);
                this.m_totalTraces += segy.traceCount();
            }
            if (this.m_totalTraces < 1L) {
                this.FailureReason = "No valid SEG-Y files specified";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkParentPath() {
        try {
            if (!this.Hasher.string_exists("ParentPath")) {
                this.FailureReason = "Parent path not specified";
                this.Failed = true;
                return false;
            }
            this.m_parentPath = this.Hasher.string_get("ParentPath");
            if (!Tools_FileSystem.exists_path(this.m_parentPath)) {
                this.FailureReason = "Parent path not valid";
                this.Failed = true;
                return false;
            }
            this.m_projectPath = this.m_parentPath + "/" + this.m_projectName;
            if (Tools_FileSystem.exists_path(this.m_projectPath)) {
                this.FailureReason = "Project path already exists";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkDict() {
        try {
            this.m_useCDP = this.Hasher.bool_get("UseCDP", true);
            if (!this.Hasher.string_exists("DictionaryFile")) {
                this.FailureReason = "Dictionary file name not specified";
                this.Failed = true;
                return false;
            }
            String dictName = this.Hasher.string_get("DictionaryFile");
            this.m_dict.setOpenFileName(dictName);
            if (!this.m_dict.isFileNameValid()) {
                this.FailureReason = "Dictionary name not valid";
                this.Failed = true;
                return false;
            }
            if (!this.m_dict.hasEntry("Trace", "Offset")) {
                this.FailureReason = "Dictionary not valid, (Trace,Offset) not defined";
                this.Failed = true;
                return false;
            }
            if (this.m_useCDP) {
                if (!this.m_dict.hasEntry("CDP", "CDP")) {
                    this.FailureReason = "Dictionary not valid, (CDP,CDP) not defined";
                    this.Failed = true;
                    return false;
                }
            } else {
                if (!this.m_dict.hasEntry("CDP", "Inline")) {
                    this.FailureReason = "Dictionary not valid, (CDP,Inline) not defined";
                    this.Failed = true;
                    return false;
                }
                if (!this.m_dict.hasEntry("CDP", "Crossline")) {
                    this.FailureReason = "Dictionary not valid, (CDP,Inline) not defined";
                    this.Failed = true;
                    return false;
                }
            }
            if (!this.m_dict.hasEntry("CDP", "CdpX")) {
                this.FailureReason = "Dictionary not valid, (CDP,CdpX) not defined";
                this.Failed = true;
                return false;
            }
            if (!this.m_dict.hasEntry("CDP", "CdpY")) {
                this.FailureReason = "Dictionary not valid, (CDP,CdpY) not defined";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected boolean checkName() {
        try {
            if (!this.Hasher.string_exists("ProjectName")) {
                this.FailureReason = "ProjectName not specified";
                this.Failed = true;
                return false;
            }
            this.m_projectName = this.Hasher.string_get("ProjectName");
            if (this.m_projectName.length() <= 1) {
                this.FailureReason = "m_projectName name not valid";
                this.Failed = true;
                return false;
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            if (!this.checkDict()) {
                return false;
            }
            if (!this.checkFiles()) {
                return false;
            }
            if (!this.checkName()) {
                return false;
            }
            if (!this.checkParentPath()) {
                return false;
            }
            this.m_projectPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_parentPath, this.m_projectName);
            if (!this.prepareTables()) {
                return false;
            }
            for (Segy segy : this.m_segyList) {
                if (this.Halt) continue;
                this.importFile(segy, messageServer);
            }
            this.m_diskTable.finishedAppending(null);
            if (this.Halt) {
                Tools_FileSystem.deletePathIfExists(this.m_projectPath);
                this.FailureReason = "Import halted";
                this.Failed = true;
                return false;
            }
            this.m_diskTable = null;
            messageServer.setMessage_Level1("Creating trace table indices");
            TraceTable_Huge_Wrapper wrapper = new TraceTable_Huge_Wrapper(this.m_traceTablePath);
            messageServer.setMessage_Level1("Save tables");
            this.m_cdpTable.saveToPath(this.m_projectPath);
            this.m_fileTable.saveToPath(this.m_projectPath);
            String fileNameDB = this.m_projectPath + "/geometry.db";
            IDatabaseConnection db = Tools_JDBC.getConnection(false, fileNameDB);
            long start = System.currentTimeMillis();
            db.createDatabaseTable(this.m_cdpTable);
            db.appendTable(this.m_cdpTable, 0);
            db.createDatabaseTable(this.m_fileTable);
            db.appendTable(this.m_fileTable, 0);
            long end = System.currentTimeMillis();
            System.out.println("stuff into disk database = " + Long.toString(end - start));
            String dictFileName = this.m_projectPath + "/ImportMap." + Segy_Dictionary.FileSuffix;
            this.m_dict.setFileName(dictFileName);
            ParameterTree p = new ParameterTree();
            Date date = new Date();
            String dateCreated = date.toString();
            p.bool_put("UseCDP", this.m_useCDP);
            p.int_put("CdpCount", this.m_cdpTable.row_count());
            p.long_put("TraceCount", this.m_traceCount);
            p.string_put("Origin", "SEGY");
            p.string_put("DictionaryFile", dictFileName);
            p.string_put("DateCreated", dateCreated);
            String paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            p.save(paramFileName);
            String muteEndFileName = this.m_projectPath + "/MuteEnd.txt";
            this.saveBins(this.m_muteEndBins, "MuteEnd.txt");
            this.saveBins(this.m_muteStartBins, "MuteStart.txt");
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }

    protected void saveBins(ArrayList<OffsetBin> bins, String file) {
        try {
            String fileName = this.m_projectPath + "/" + file;
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            writer.write(Integer.toString(bins.size()));
            writer.write("  ");
            writer.write(Double.toString(this.m_offsetIncrement));
            writer.newLine();
            for (OffsetBin b : bins) {
                double val = b.Sum / b.Count;
                writer.write(Double.toString(val));
                writer.write("  ");
                writer.write(Double.toString(b.Count));
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void fillBins(Ensemble ensemble) {
        try {
            Tools_Ensemble.findFirstValidSample(ensemble);
            int indexFirstValidSample = ensemble.dictionary().getEntryIndex("Trace", "FirstValidSample");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexCode = ensemble.dictionary().getEntryIndex("Trace", "TraceCode");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                FloatArrayWrapper data = trace.data();
                int firstIndex = trace.header().getInt(indexFirstValidSample);
                double v = data.getFirstSampleCoord_WithShifts() + data.getSampleInterval() * (float)firstIndex;
                double x = trace.header().getDouble(indexOffset);
                int code = trace.header().getInt(indexCode);
                if (code != 1 || firstIndex <= 0 || !(x >= 0.0) || !(v >= 0.0)) continue;
                int bin = (int)(x / this.m_offsetIncrement);
                while (bin >= this.m_muteEndBins.size()) {
                    this.m_muteEndBins.add(new OffsetBin());
                }
                while (bin >= this.m_muteStartBins.size()) {
                    this.m_muteStartBins.add(new OffsetBin());
                }
                OffsetBin offsetBinStart = this.m_muteStartBins.get(bin);
                OffsetBin offsetBinEnd = this.m_muteEndBins.get(bin);
                offsetBinStart.Count += 1.0;
                offsetBinStart.Sum += v;
                offsetBinEnd.Count += 1.0;
                offsetBinEnd.Sum = offsetBinEnd.Sum + v + 20.0;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void mergeEnsemble(long startIndexInFile, Ensemble ensemble) {
        try {
            Tools_Ensemble.setHeaderValue(ensemble, "Trace", "FileID", 0, this.m_fileID, 0);
            Tools_Ensemble.setHeaderLong(ensemble, "Trace", "IndexInFile", 0, startIndexInFile, 1L);
            this.m_cdpParser.handleEnsemble(ensemble);
            this.fillBins(ensemble);
            if (this.m_diskTable == null) {
                this.m_diskTable = new TraceTable_Huge(this.m_traceTablePath, "Trace", ensemble, 8);
            }
            int numAdded = this.m_diskTable.appendEnsemble(ensemble);
            this.m_traceCount += (long)numAdded;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void importFile(Segy segy, IProgressMonitor messageServer) {
        try {
            if (this.Halt) {
                return;
            }
            String tempFileName = Tools_FileSystem.convertToUnixFileName(segy.fileName());
            File file = new File(tempFileName);
            ++this.m_fileID;
            int fileRow = this.m_fileTable.row_increment();
            this.m_fileTable.putInt(fileRow, this.m_fileIndex_FileID, this.m_fileID);
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Name, file.getName());
            this.m_fileTable.putString(fileRow, this.m_fileIndex_Path, file.getParent());
            Ensemble ensemble = new Ensemble();
            int tracesPerChunk = 2000;
            long[] indices = new long[tracesPerChunk];
            segy.setSegyDictionary(this.m_dict);
            for (long startIndex = 0L; startIndex < segy.traceCount() && !this.Halt; startIndex += (long)tracesPerChunk) {
                for (int n = 0; n < tracesPerChunk; ++n) {
                    indices[n] = startIndex + (long)n;
                }
                ensemble.clearTraces(false);
                segy.populateEnsemble(ensemble, indices, tracesPerChunk, true, true);
                if (ensemble.traceCount() > 1) {
                    this.mergeEnsemble(startIndex, ensemble);
                }
                this.m_numRead += (long)ensemble.traceCount();
                String s = String.format("%d traces, %d cdps", this.m_numRead, this.m_cdpTable.row_count());
                messageServer.setMessage_Level1(s);
                messageServer.setPercentDone(100.0 * (double)this.m_numRead / (double)this.m_totalTraces);
            }
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class OffsetBin {
        public double Count = 1.0E-40;
        public double Value = 0.0;
        public double Sum = 0.0;
        public double Average = 0.0;

        protected OffsetBin() {
        }
    }
}

