/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class Action_ExportTraceTableToCSV
extends Action_Base {
    public Action_ExportTraceTableToCSV() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create CSV trace table file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String name = this.Hasher.string_get("Name", "Trace");
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            ITraceTable traceTable = project.traceTableWrapper().traceTable();
            String path = Tools_FileSystem.confirmSubDirectoryExists(project.projectPath(), "TraceTable_CSV");
            String csv = path + "/" + name + ".csv";
            messageServer.setMessage_Level1("Export CSV file");
            BufferedWriter writer = new BufferedWriter(new FileWriter(csv));
            for (int n = 0; n < traceTable.column_count(); ++n) {
                if (n >= 1) {
                    writer.write(",");
                }
                Object colName = traceTable.column_name(n);
                if (traceTable.column_type(n) == DataType.Int) {
                    colName = (String)colName + "_I";
                }
                if (traceTable.column_type(n) == DataType.Float) {
                    colName = (String)colName + "_F";
                }
                if (traceTable.column_type(n) == DataType.Double) {
                    colName = (String)colName + "_D";
                }
                if (traceTable.column_type(n) == DataType.Long) {
                    colName = (String)colName + "_L";
                }
                writer.write((String)colName);
            }
            writer.newLine();
            for (long row = 0L; row < traceTable.rowCount(); ++row) {
                for (int n = 0; n < traceTable.column_count(); ++n) {
                    if (n >= 1) {
                        writer.write(",");
                    }
                    writer.write(traceTable.getString(row, n));
                }
                writer.newLine();
                if (row % 1000L != 0L) continue;
                double precent = 100.0 * (double)row / (double)(traceTable.rowCount() + 1L);
                messageServer.setPercentDone(precent);
            }
            writer.close();
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

