/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.NumPy.NumPyExporter;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;

public class Action_ExportNumPy
extends Action_Base {
    public String OutputPath;
    protected Table_Abstract m_shotTable = RefractionStaticsProject.singleton().getShotTable();
    protected Ensemble m_shotEnsemble = new Ensemble();
    protected NumPyExporter m_numPyExporter;

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            messageServer.setMessage_Level1("Export project traces to NumPy arrays");
            this.m_numPyExporter = new NumPyExporter(this.OutputPath);
            int indexShotKilled = this.m_shotTable.column_indexOfColumn("Killed");
            for (int s = 0; s < this.m_shotTable.row_count(); ++s) {
                boolean shotKilled = this.m_shotTable.getBool(s, indexShotKilled);
                if (shotKilled) continue;
                this.writeShot(s);
                messageServer.setPercentDone(100.0 * (double)(s + 1) / (double)this.m_shotTable.row_count());
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return false;
        }
    }

    protected void writeShot(int shotRow) {
        try {
            int indexShotID = this.m_shotTable.column_indexOfColumn("ShotID");
            int shotID = this.m_shotTable.getInt(shotRow, indexShotID);
            RefractionStaticsProject.singleton().ensemble_Shot(this.m_shotEnsemble, shotID, true);
            this.m_shotEnsemble.sortInt(0, "Receiver", "LineNumber", "Receiver", "PointNumber");
            Tools_Ensemble.computeAzimuthAndOffset(this.m_shotEnsemble);
            int shotTraceCount = 0;
            for (int n = 0; n < this.m_shotEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_shotEnsemble.trace(n);
                if (!trace.hasData() || !trace.traceOkay()) continue;
                ++shotTraceCount;
            }
            if (shotTraceCount == 0) {
                System.out.println("ShotID " + shotID + " has no valid traces!  Skipping ShotID " + shotID);
                return;
            }
            int indexHeaderFBP = this.m_shotEnsemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexHeaderIndex = this.m_shotEnsemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            int indexHeaderReceiverLine = this.m_shotEnsemble.dictionary().getEntryIndex("Receiver", "LineNumber");
            int indexHeaderOffset = this.m_shotEnsemble.dictionary().getEntryIndex("Trace", "Offset");
            int currentReceiverLine = 0;
            boolean endOfLine = false;
            boolean startOfLine = true;
            float sampleInterval = this.m_shotEnsemble.trace(0).data().getSampleInterval();
            for (int n = 0; n < this.m_shotEnsemble.traceCount(); ++n) {
                EnsembleTrace trace = this.m_shotEnsemble.trace(n);
                if (!trace.hasData() || !trace.traceOkay()) continue;
                int receiverLine = trace.header().getInt(indexHeaderReceiverLine);
                if (startOfLine) {
                    this.m_numPyExporter.prep(shotID, receiverLine, trace.data().length());
                    currentReceiverLine = receiverLine;
                    endOfLine = false;
                    startOfLine = false;
                }
                if (receiverLine == currentReceiverLine) {
                    int indexInFile = trace.header().getInt(indexHeaderIndex);
                    float offset = trace.header().getFloat(indexHeaderOffset);
                    float pick = trace.header().getFloat(indexHeaderFBP);
                    this.m_numPyExporter.add(indexInFile, pick / sampleInterval, offset, trace.normalize());
                }
                if (n == this.m_shotEnsemble.traceCount() - 1) {
                    endOfLine = true;
                } else if (this.m_shotEnsemble.trace(n + 1).header().getInt(indexHeaderReceiverLine) != receiverLine) {
                    endOfLine = true;
                }
                if (!endOfLine) continue;
                this.m_numPyExporter.finish();
                startOfLine = true;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Deprecated
    protected void writeShotFile(int shotRow, String filePath) {
        try {
            boolean bOk;
            Table_Abstract shotTable = RefractionStaticsProject.singleton().getShotTable();
            int indexShotID = shotTable.column_indexOfColumn("ShotID");
            int shotID = shotTable.getInt(shotRow, indexShotID);
            Ensemble ensemble = new Ensemble();
            RefractionStaticsProject.singleton().ensemble_Shot(ensemble, shotID, true);
            ensemble.sortInt(0, "Receiver", "LineNumber", "Receiver", "PointNumber");
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            int traceLength = 4 + ensemble.trace(0).data().length();
            int traceCount = 0;
            int indexHeaderFBP = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexHeaderIndex = ensemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            int indexHeaderReceiverLine = ensemble.dictionary().getEntryIndex("Receiver", "LineNumber");
            int indexHeaderOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData() || !trace.traceOkay()) continue;
                ++traceCount;
            }
            if (traceCount == 0) {
                System.out.println("No valid traces!  Aborting");
                return;
            }
            File file = new File(filePath);
            if (file.exists() && !(bOk = file.delete())) {
                throw new Exception("unable to delete : " + filePath);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel wChannel = fileOutputStream.getChannel();
            String magicString = "NUMPY";
            byte magicFirstByte = -109;
            byte[] magic = magicString.getBytes(StandardCharsets.UTF_8);
            byte major = 1;
            byte minor = 0;
            String descrString = "{'descr': 'Float32', ";
            byte[] descr = descrString.getBytes(StandardCharsets.UTF_8);
            String fortranString = "'fortran_order': False, ";
            byte[] fortran = fortranString.getBytes(StandardCharsets.UTF_8);
            String shapeString = "'shape': (" + traceCount + "," + traceLength + "), }";
            byte[] shape = shapeString.getBytes(StandardCharsets.UTF_8);
            String endLine = "\n";
            byte[] endl = endLine.getBytes(StandardCharsets.UTF_8);
            int lengthPadding = 0;
            int bytesUsed = 1 + magic.length + 4 + descr.length + fortran.length + shape.length + endl.length;
            if (bytesUsed % 16 != 0) {
                lengthPadding = 16 - bytesUsed % 16;
            }
            byte[] headerLenByte = new byte[2];
            short headerLength = (short)(bytesUsed + lengthPadding - 10);
            headerLenByte[0] = (byte)headerLength;
            headerLenByte[1] = (byte)(headerLength >> 8);
            int fileSize = bytesUsed + lengthPadding + 4 * traceCount * traceLength;
            ByteBuffer bb = ByteBuffer.allocate(fileSize);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.put(magicFirstByte);
            bb.put(magic);
            bb.put(major);
            bb.put(minor);
            bb.put(headerLenByte);
            bb.put(descr);
            bb.put(fortran);
            bb.put(shape);
            if (lengthPadding > 0) {
                byte[] padding = new byte[lengthPadding];
                for (int i = 0; i < lengthPadding; ++i) {
                    padding[i] = 32;
                }
                bb.put(padding);
            }
            bb.put(endl);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                if (!trace.hasData() || !trace.traceOkay()) continue;
                float receiverLine = trace.header().getInt(indexHeaderReceiverLine);
                float indexInFile = trace.header().getInt(indexHeaderIndex);
                float offset = trace.header().getFloat(indexHeaderOffset);
                float pick = trace.header().getFloat(indexHeaderFBP);
                bb.putFloat(receiverLine);
                bb.putFloat(indexInFile);
                bb.putFloat(pick);
                bb.putFloat(offset);
                float[] sample = trace.normalize();
                for (int s = 0; s < trace.data().length(); ++s) {
                    bb.putFloat(sample[s]);
                }
            }
            bb.flip();
            wChannel.write(bb);
            wChannel.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void readTestFile(String filePath) {
        try {
            RandomAccessFile reader = new RandomAccessFile(filePath, "r");
            long numBytes = reader.length();
            ByteBuffer buffer = ByteBuffer.allocate((int)numBytes);
            reader.read(buffer.array());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            byte magicFirstByte = buffer.get();
            int magicFirstByteNumber = magicFirstByte & 0xFF;
            byte[] magic = new byte[5];
            for (int i = 0; i < 5; ++i) {
                magic[i] = buffer.get();
            }
            String magicString = new String(magic);
            byte major = buffer.get();
            byte minor = buffer.get();
            short headerLength = buffer.getShort();
            System.out.println("First byte value: " + magicFirstByteNumber);
            System.out.println("Magic string: " + magicString);
            System.out.println("Major: " + (major & 0xFF));
            System.out.println("Minor: " + (minor & 0xFF));
            System.out.println("Header length: " + headerLength);
            byte[] header = new byte[headerLength];
            buffer.get(header);
            String headerString = new String(header);
            char[] headerChars = headerString.toCharArray();
            System.out.println("Header literal: " + headerString);
            reader.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

