/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Refraction.DelayTime.DelayTimeMath;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class Action_ExportGLI_LPI
extends Action_Base {
    public boolean ApplyPolygon = false;
    public Java2D_Polygon Polygon = null;
    public String FileName;
    public boolean CreateSyntheticPicks = false;
    public double V0 = 3000.0;
    public double V1 = 6000.0;
    public double V2 = 8000.0;
    public double Z1 = 0.0;
    public double Z2 = -600.0;
    protected DelayTimeMath m_shotMath = new DelayTimeMath();
    protected DelayTimeMath m_recMath = new DelayTimeMath();
    HashMap_Integer m_mapShot = new HashMap_Integer();
    HashMap_Integer m_mapRec = new HashMap_Integer();

    public Action_ExportGLI_LPI() {
        this.RequiresRefractionStaticsProject = true;
        this.Description = "Create GLI file";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    protected void justReadFromNode() {
    }

    protected void createSyntheticPicks(Ensemble ensemble) {
        try {
            this.m_shotMath.MaxBranch = 2;
            this.m_shotMath.Velocity[0] = this.V0;
            this.m_shotMath.Velocity[1] = this.V1;
            this.m_shotMath.Velocity[2] = this.V2;
            this.m_recMath.MaxBranch = 2;
            this.m_recMath.Velocity[0] = this.V0;
            this.m_recMath.Velocity[1] = this.V1;
            this.m_recMath.Velocity[2] = this.V2;
            int indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            int indexRecZ = ensemble.dictionary().getEntryIndex("Receiver", "Elevation");
            int indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            int indexShotZ = ensemble.dictionary().getEntryIndex("Shot", "Elevation");
            int indexPick = ensemble.dictionary().getEntryIndex("Trace", "FBP_User");
            int indexOff = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract h = ensemble.trace(n).header();
                float offset = (float)h.getDouble(indexOff);
                this.m_shotMath.Thickness[0] = h.getDouble(indexShotZ) - this.Z1;
                this.m_shotMath.Thickness[1] = this.Z1 - this.Z2;
                float sdt1 = (float)this.m_shotMath.computeDelayTime(1);
                float sdt2 = (float)this.m_shotMath.computeDelayTime(2);
                this.m_recMath.Thickness[0] = h.getDouble(indexRecZ) - this.Z1;
                this.m_recMath.Thickness[1] = this.Z1 - this.Z2;
                float rdt1 = (float)this.m_recMath.computeDelayTime(1);
                float rdt2 = (float)this.m_recMath.computeDelayTime(2);
                float min = 1000.0f * offset / (float)this.V0;
                float t1 = 1000.0f * offset / (float)this.V1 + sdt1 + rdt1;
                min = Math.min(min, t1);
                float t2 = 1000.0f * offset / (float)this.V2 + sdt2 + rdt2;
                min = Math.min(min, t2);
                h.putFloat(indexPick, min);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected void writeTable(BufferedWriter writer, Table_Abstract table, String prefix, String colnameid, HashMap_Integer map) {
        try {
            int columnID = table.column_indexOfColumn(colnameid);
            int columnKilled = table.column_indexOfColumn("Killed");
            int columnX = table.column_indexOfColumn("Easting");
            int columnY = table.column_indexOfColumn("Northing");
            int columnZ = table.column_indexOfColumn("Elevation");
            int colLine = table.column_indexOfColumn("LineNumber");
            int colPoint = table.column_indexOfColumn("PointNumber");
            int colIndex = table.column_indexOfColumn("PointIndex");
            int columnUphole = -9999;
            int columnDepth = -9999;
            if (table.column_exists("UpholeTime")) {
                columnUphole = table.column_indexOfColumn("UpholeTime");
            }
            if (table.column_exists("PointDepth")) {
                columnDepth = table.column_indexOfColumn("PointDepth");
            }
            double uphole = 0.0;
            double depth = 0.0;
            for (int n = 0; n < table.row_count(); ++n) {
                int shotID = table.getInt(n, columnID);
                int shotLine = table.getInt(n, colLine);
                int shotPoint = table.getInt(n, colPoint);
                int shotIndex = table.getInt(n, colIndex);
                double x = table.getDouble(n, columnX);
                double y = table.getDouble(n, columnY);
                boolean poly = true;
                if (this.Polygon != null && this.ApplyPolygon) {
                    poly = this.Polygon.contains(x, y);
                }
                if (!poly) continue;
                map.put(shotID, n);
                writer.write(prefix);
                writer.write(Integer.toString(shotID) + " ");
                writer.write(Integer.toString(shotLine) + " ");
                writer.write(Integer.toString(shotPoint) + " ");
                writer.write(Integer.toString(shotIndex) + " ");
                writer.write(table.getString(n, columnX) + " ");
                writer.write(table.getString(n, columnY) + " ");
                writer.write(table.getString(n, columnZ) + " ");
                if (columnUphole >= 0) {
                    writer.write(table.getString(n, columnUphole) + " ");
                } else {
                    writer.write("0 ");
                }
                if (columnDepth >= 0) {
                    writer.write(table.getString(n, columnDepth) + " ");
                } else {
                    writer.write("0 ");
                }
                writer.newLine();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            RefractionStaticsProject project = RefractionStaticsProject.singleton();
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.FileName));
            this.writeTable(writer, project.shotTable(), "shot ", "ShotID", this.m_mapShot);
            this.writeTable(writer, project.receiverTable(), "rec ", "ReceiverID", this.m_mapRec);
            ITraceTable trace = project.traceTableWrapper().traceTable();
            int cols = trace.column_indexOfColumn("ShotID");
            int colr = trace.column_indexOfColumn("ReceiverID");
            int colp = trace.column_indexOfColumn("FBP_User");
            for (long r = 0L; r < trace.rowCount(); ++r) {
                int sid = trace.getInt(r, cols);
                int rid = trace.getInt(r, colr);
                float pick = trace.getFloat(r, colp);
                if (pick > 0.0f && this.m_mapShot.containsKey(sid) && this.m_mapRec.containsKey(rid)) {
                    writer.write("trace ");
                    writer.write(Integer.toString(sid) + " ");
                    writer.write(Integer.toString(rid) + " ");
                    writer.write(Float.toString(pick));
                    writer.newLine();
                }
                if (r % 20000L != 0L) continue;
                messageServer.setPercentDone(100.0 * (double)r / (double)trace.rowCount());
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.FailureReason = error.getMessage();
            this.Failed = true;
            return false;
        }
    }
}

