/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.Action.Export;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Export.Action_ExportBinaryGLI;
import com.PecosLibrary.Refraction.RefractionStaticsProject;
import java.util.ArrayList;

public class Action_ExportBinaryGLI_All
extends Action_Base {
    public String OutputPath;
    public ArrayList<String> ProjectList;

    public Action_ExportBinaryGLI_All() {
        this.RequiresRefractionStaticsProject = false;
        this.Description = "Export binary GLI projects";
        this.RequiresDelayTimeData = false;
        this.MemoryRequired = 512;
    }

    @Override
    public boolean work(IProgressMonitor messageServer) {
        try {
            String parentPath = SharedApplicationData.staticsProjectPath();
            ArrayList<String> subdirs = Tools_FileSystem.subdirectories(parentPath, false);
            if (this.ProjectList != null && this.ProjectList.size() > 0) {
                subdirs.clear();
                for (String name : this.ProjectList) {
                    if (name.endsWith(".xtref")) {
                        subdirs.add(name);
                        continue;
                    }
                    subdirs.add(name + ".xtref");
                }
            }
            for (String subdir : subdirs) {
                String subdirName;
                System.out.println("Action_ExportBinaryGLI_All project " + subdir);
                String fullProjectPath = parentPath + "/" + subdir;
                if (!Tools_FileSystem.exists_path(fullProjectPath)) continue;
                if (subdir.endsWith(".xtref")) {
                    int endChar = subdir.length() - ".xtref".length();
                    subdirName = subdir.substring(0, endChar);
                } else {
                    subdirName = subdir;
                }
                RefractionStaticsProject p = new RefractionStaticsProject(subdirName, true);
                Action_ExportBinaryGLI action = new Action_ExportBinaryGLI();
                action.Project = p;
                action.ApplyPolygon = false;
                action.OutputPath = Tools_FileSystem.confirmSubDirectoryExists(this.OutputPath, subdirName);
                action.work(messageServer);
            }
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }
}

