/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.AVO;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosLibrary.Velocity.RmsVelocityFunction;

public class AvoSlopeIntercept {
    public float[] AverageMax;
    public float[] SampleMax;
    public float[] SampleMin;
    public float[] R;
    public float[] G;
    public double[] Count;
    public double[] SumS;
    public double[] SumV;
    public double[] SumSS;
    public double[] SumSV;
    public float[] Temp;
    public double AverageR = 0.0;
    public double AverageG = 0.0;
    public double Ratio = 0.0;
    public double MaxOffset;
    public double NumTraces;
    public int AB_RowCount = 5;
    public float[] A;
    public float[] B;

    public void prepArrays(int numSamples) {
        try {
            boolean needArrays = true;
            if (this.Count != null) {
                boolean bl = needArrays = this.Count.length != numSamples;
            }
            if (needArrays) {
                this.SampleMin = new float[numSamples];
                this.SampleMax = new float[numSamples];
                this.AverageMax = new float[numSamples];
                this.R = new float[numSamples];
                this.G = new float[numSamples];
                this.Count = new double[numSamples];
                this.SumS = new double[numSamples];
                this.SumV = new double[numSamples];
                this.SumSS = new double[numSamples];
                this.SumSV = new double[numSamples];
                this.Temp = new float[numSamples];
                this.A = new float[numSamples];
                this.B = new float[numSamples];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void clearArrays() {
        try {
            this.NumTraces = 0.0;
            this.MaxOffset = 0.0;
            this.AverageR = 0.0;
            this.AverageG = 0.0;
            this.Ratio = 0.0;
            for (int n = 0; n < this.Count.length; ++n) {
                this.SampleMin[n] = 0.0f;
                this.SampleMax[n] = 0.0f;
                this.AverageMax[n] = 0.0f;
                this.Count[n] = 1.0E-40f;
                this.SumS[n] = 0.0;
                this.SumV[n] = 0.0;
                this.SumSS[n] = 0.0;
                this.SumSV[n] = 0.0;
                this.A[n] = 0.0f;
                this.B[n] = 0.0f;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void append(FloatArrayWrapper wrapper, int startSample, RmsVelocityFunction velFun, double offset) throws Exception {
        try {
            velFun.computeSinAngle(offset);
            if (velFun.SinAngle.length != this.Count.length) {
                throw new Exception("velFun.SinAngle.length != Count.length");
            }
            if (velFun.SinAngle.length != wrapper.length()) {
                throw new Exception("velFun.SinAngle.length != wrapper.length()");
            }
            wrapper.copyToArray(this.Temp);
            startSample = Math.max(startSample, 0);
            for (int n = startSample = Math.min(startSample, this.Temp.length - 1); n < this.Temp.length; ++n) {
                this.SampleMax[n] = Math.max(this.SampleMax[n], this.Temp[n]);
                this.SampleMin[n] = Math.min(this.SampleMin[n], this.Temp[n]);
                this.Count[n] = this.Count[n] + 1.0;
                double ssq = (double)velFun.SinAngle[n] * (double)velFun.SinAngle[n];
                this.SumV[n] = this.SumV[n] + (double)this.Temp[n];
                this.SumS[n] = this.SumS[n] + ssq;
                this.SumSV[n] = this.SumSV[n] + ssq * (double)this.Temp[n];
                this.SumSS[n] = this.SumSS[n] + ssq * ssq;
            }
            this.NumTraces += 1.0;
            this.MaxOffset = Math.max(this.MaxOffset, offset);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeA(int n, float b) throws Exception {
        try {
            if (this.Count[n] < 1.5) {
                this.A[n] = (float)(this.SumV[n] / this.Count[n]);
            } else {
                float temp = (float)((double)b * this.SumS[n]);
                double left = this.Count[n] + 2.0 * (double)temp + (double)(temp * temp);
                double right = this.SumV[n] + (double)b * this.SumSV[n];
                this.A[n] = (float)(right / left);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeB(int n) throws Exception {
        try {
            if (this.Count[n] < 1.5) {
                this.B[n] = 0.0f;
                return;
            }
            int half = this.AB_RowCount / 2;
            half = 1;
            int low = n - half;
            low = Math.max(0, low);
            int high = n + half;
            high = Math.min(high, this.Count.length - 1);
            float b = 0.0f;
            for (int iter = 0; iter < 4; ++iter) {
                for (int r = low; r <= high; ++r) {
                    this.computeA(r, b);
                }
                double sumT1 = 0.0;
                double sumT2 = 1.0E-20;
                double sumT3 = 0.0;
                for (int r = low; r <= high; ++r) {
                    if (!(this.Count[r] > 1.5)) continue;
                    sumT1 += (double)(this.A[r] * this.A[r]) * this.SumS[r];
                    sumT2 += (double)(this.A[r] * this.A[r]) * this.SumSS[r];
                    sumT3 += (double)this.A[r] * this.SumSV[r];
                }
                try {
                    double newB = (sumT3 - sumT1) / sumT2;
                    double change = newB - (double)b;
                    b += (float)(0.5 * change);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                b = Math.max(b, -6.0f);
                b = Math.min(b, 6.0f);
            }
            this.B[n] = b;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void computeAB() throws Exception {
        try {
            int n;
            for (n = 0; n < this.Count.length; ++n) {
                this.computeB(n);
            }
            for (n = 0; n < this.Count.length; ++n) {
                this.computeA(n, this.B[n]);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finish() throws Exception {
        try {
            int n;
            int range = 6;
            for (n = 0; n < this.Count.length; ++n) {
                float max = 0.0f;
                for (int s = n - range; s <= n + range; ++s) {
                    if (s < 0 || s >= this.Count.length) continue;
                    max = Math.max(this.SampleMax[s], max);
                    max = Math.max(-this.SampleMin[s], max);
                }
                this.Temp[n] = max;
            }
            for (n = 0; n < this.Count.length; ++n) {
                float sum = 0.0f;
                float count = 1.0E-20f;
                for (int s = n - range; s <= n + range; ++s) {
                    if (s < 0 || s >= this.Count.length) continue;
                    float w = 1.0f / (2.0f + (float)Math.abs(n - s));
                    sum += w * this.Temp[n];
                    count += w;
                }
                this.AverageMax[n] = sum / count;
            }
            this.AverageR = 0.0;
            this.AverageG = 0.0;
            this.Ratio = 0.0;
            boolean crap = false;
            for (int n2 = 0; n2 < this.Count.length; ++n2) {
                this.R[n2] = 0.0f;
                this.G[n2] = 0.0f;
                if (this.Count[n2] > 1.5) {
                    double top = this.Count[n2] * this.SumSV[n2] - this.SumS[n2] * this.SumV[n2];
                    double bottom = this.Count[n2] * this.SumSS[n2] - this.SumS[n2] * this.SumS[n2];
                    if (n2 > 1300) {
                        crap = true;
                    }
                    if (Math.abs(bottom) > 1.0E-13) {
                        this.G[n2] = (float)(top / bottom);
                        this.R[n2] = (float)((this.SumV[n2] - (double)this.G[n2] * this.SumS[n2]) / this.Count[n2]);
                    } else {
                        this.G[n2] = 0.0f;
                        this.R[n2] = 0.0f;
                    }
                }
                this.AverageR += (double)Math.abs(this.R[n2]);
                this.AverageG += (double)Math.abs(this.G[n2]);
            }
            this.AverageR /= 1.0E-20 + (double)this.Count.length;
            this.AverageG /= 1.0E-20 + (double)this.Count.length;
            this.Ratio = this.AverageG / (1.0E-20 + this.AverageR);
            this.computeAB();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

