/*
 * Decompiled with CFR 0.152.
 */
package com.PecosLibrary.AVO;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Data.TraceTable.Huge.TraceTable_Huge_Wrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Seismic.Segy.Segy_FileHeader;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.Messenger;
import com.PecosCore.Shared.SharedApplicationData;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import com.PecosCore.Windows.Shared.IComponentManager;
import com.PecosLibrary.Action.Action_Base;
import com.PecosLibrary.Action.Action_Sequence;
import com.PecosLibrary.Action.Export.Action_ExportTraceTableToCSV;
import com.PecosLibrary.Action.Import.Action_ImportTraceTableFromCSV;
import com.PecosLibrary.Geometry.PromaxGrid;
import com.PecosLibrary.JDBC.IDatabaseConnection;
import com.PecosLibrary.JDBC.Tools_JDBC;
import com.PecosLibrary.Windows.Action.ActionSequence_InternalWidget;
import com.PecosLibrary.Windows.Java2D.Paintables.Java2D_Polygon;
import com.PecosLibrary.Windows.Refraction.Database.SeismicFileManagerDialog;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class AvoProject {
    protected int m_runCount = 0;
    protected ParameterTree m_information;
    protected String m_paramFileName;
    protected int TotalTraces = 0;
    protected int[] m_headerIndex = new int[50];
    protected DataType[] m_headerType = new DataType[50];
    protected boolean[] m_doubleType = new boolean[50];
    protected Table_Abstract m_fileTable;
    protected ArrayList<FileInfo> m_fileList = new ArrayList();
    protected static AvoProject m_singleton = null;
    protected PromaxGrid m_promaxGrid = new PromaxGrid();
    protected String m_promaxGridFileName;
    protected Java2D_Polygon m_polygon = new Java2D_Polygon();
    protected String m_polygonFileName = "";
    protected Action_Sequence m_actionSequence = new Action_Sequence();
    protected String m_name = null;
    protected String m_projectPath;
    protected String m_guiOptionsPath;
    protected IDatabaseConnection m_geometryConn;
    protected TraceTable_Huge_Wrapper m_traceTableWrapper;
    protected Table_Abstract m_cdpTable;
    protected HashMap_Integer m_cdpMap;
    public String RecentSegyFileName;
    public Segy_FileHeader RecentSegyFileHeader;
    public byte[] RecentEbcdic;
    protected double m_muteEndIncrement;
    protected double[] m_muteEndCount;
    protected double[] m_muteEndValue;
    protected double m_muteStartIncrement;
    protected double[] m_muteStartCount;
    protected double[] m_muteStartValue;
    protected boolean m_statisticsValid = false;
    protected double m_averageRatio = 1.0;

    public ParameterTree information() {
        return this.m_information;
    }

    public ArrayList<FileInfo> getFileInfoList() {
        return this.m_fileList;
    }

    public String getSeismicFileName(int fileID) throws Exception {
        try {
            for (FileInfo info : this.m_fileList) {
                if (info.FileID != fileID) continue;
                return info.FullPath;
            }
            throw new Exception("File id not found: " + fileID);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public int maxSamplesPerTrace() {
        try {
            int max = 0;
            for (FileInfo file : this.m_fileList) {
                if (file.SeismicFile == null) continue;
                max = Math.max(max, file.SeismicFile.samplesPerTrace());
            }
            return max;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return 0;
        }
    }

    protected AvoProject() {
    }

    public static AvoProject singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new AvoProject();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public PromaxGrid getPromaxGrid() {
        return this.m_promaxGrid;
    }

    public String getPromaxGridFileName() {
        return this.m_promaxGridFileName;
    }

    public Java2D_Polygon polygon() {
        return this.m_polygon;
    }

    public void savePolygon() {
        try {
            this.m_polygon.save(this.m_polygonFileName);
            Messenger.broadcast(Messenger.Message.ProjectPolygonModified, this, this.m_polygon);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Action_Sequence actionSequence() {
        return this.m_actionSequence;
    }

    public void executeActionSequence() {
        try {
            IComponentManager cm = SharedApplicationData.singleton().getComponentManager();
            String className = ActionSequence_InternalWidget.class.getName();
            ActionSequence_InternalWidget w = (ActionSequence_InternalWidget)cm.showAndLockComponent(className, "Job", "Job");
            w.WhichProject = ActionSequence_InternalWidget.UseWhichProject.Refraction;
            w.startJob(null);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void executeSingleAction(Action_Base action) {
        try {
            this.m_actionSequence.clear();
            this.m_actionSequence.addAction(action);
            this.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public String projectPath() {
        return this.m_projectPath;
    }

    public String guiOptionsPath() {
        return this.m_guiOptionsPath;
    }

    public IDatabaseConnection geomDatabase() {
        return this.m_geometryConn;
    }

    public TraceTable_Huge_Wrapper traceTableWrapper() {
        return this.m_traceTableWrapper;
    }

    public void traceTableWrapper_Clear() {
        this.m_traceTableWrapper = null;
    }

    public void traceTableWrapper_Refresh() {
        try {
            String tracePath = this.m_projectPath + "/TraceTable";
            this.m_traceTableWrapper = new TraceTable_Huge_Wrapper(tracePath);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void traceTable_SaveandRead() {
        try {
            Action_ExportTraceTableToCSV actionSave = new Action_ExportTraceTableToCSV();
            actionSave.Hasher.string_put("Name", "Backup");
            Action_ImportTraceTableFromCSV actionRead = new Action_ImportTraceTableFromCSV();
            actionRead.Hasher.string_put("Name", "Backup");
            this.m_actionSequence.clear();
            this.m_actionSequence.addAction(actionSave);
            this.m_actionSequence.addAction(actionRead);
            this.executeActionSequence();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public Table_Abstract cdpTable() {
        return this.m_cdpTable;
    }

    public HashMap_Integer cdpMap() {
        return this.m_cdpMap;
    }

    protected void prepIndexConnectors(Ensemble ensemble, Table_Abstract table) {
        try {
            if (this.m_headerIndex.length <= table.column_count()) {
                this.m_headerIndex = new int[20 + table.column_count()];
            }
            if (this.m_headerType.length <= table.column_count()) {
                this.m_headerType = new DataType[20 + table.column_count()];
            }
            if (this.m_doubleType.length <= table.column_count()) {
                this.m_doubleType = new boolean[20 + table.column_count()];
            }
            String tableName = table.name();
            for (int col = 0; col < table.column_count(); ++col) {
                String name = table.column_name(col);
                this.m_headerType[col] = table.column_type(col);
                this.m_headerIndex[col] = ensemble.dictionary().addEntry(tableName, name, this.m_headerType[col]);
                this.m_doubleType[col] = this.m_headerType[col] == DataType.Double || this.m_headerType[col] == DataType.Float;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateCdpHeader(Ensemble ensemble) {
        try {
            if (!ensemble.dictionary().containsEntry("Trace", "CDPID")) {
                return;
            }
            int indexID = ensemble.dictionary().getEntryIndex("Trace", "CDPID");
            int indexRow = ensemble.dictionary().addEntry("CDP", "CdpRow", DataType.Int);
            this.prepIndexConnectors(ensemble, this.m_cdpTable);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                Column_Abstract header = ensemble.trace(t).header();
                int id = header.getInt(indexID);
                int row = this.m_cdpMap.get(id);
                header.putInt(indexRow, row);
                for (int col = 0; col < this.m_cdpTable.column_count(); ++col) {
                    int headerIndex = this.m_headerIndex[col];
                    if (this.m_doubleType[col]) {
                        header.putDouble(headerIndex, this.m_cdpTable.getDouble(row, col));
                        continue;
                    }
                    header.putInt(headerIndex, this.m_cdpTable.getInt(row, col));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void prepGeometryHeaders(Ensemble ensemble, boolean assignBranches, boolean computeTravelTimes) {
        try {
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                ensemble.trace((int)n).TooNoisy = false;
                ensemble.trace((int)n).TraceKilled = false;
            }
            this.populateCdpHeader(ensemble);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    protected void prepareMuteTimes(Ensemble ensemble) {
        try {
            int indexCode = ensemble.dictionary().getEntryIndex("Trace", "TraceCode");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexMuteStart = ensemble.dictionary().addEntry("Trace", "MuteStart", DataType.Double);
            int indexMuteEnd = ensemble.dictionary().addEntry("Trace", "MuteEnd", DataType.Double);
            int indexFirst = ensemble.dictionary().getEntryIndex("Trace", "FirstValidSample");
            double muteStart = 0.0;
            double muteEnd = 0.0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int firstValidSample = trace.header().getInt(indexFirst);
                if (firstValidSample > 0) {
                    muteStart = trace.data().getFirstSampleCoord_WithShifts() + (float)firstValidSample * trace.data().getSampleInterval();
                    muteEnd = muteStart + 20.0;
                } else {
                    double off = trace.header().getDouble(indexOffset);
                    int k = (int)(off / this.m_muteStartIncrement);
                    k = Math.max(0, k);
                    k = Math.min(k, this.m_muteStartValue.length - 1);
                    muteStart = this.m_muteStartValue[k];
                    k = (int)(off / this.m_muteEndIncrement);
                    k = Math.max(0, k);
                    k = Math.min(k, this.m_muteEndValue.length - 1);
                    muteEnd = this.m_muteEndValue[k];
                }
                trace.header().putDouble(indexMuteStart, muteStart);
                trace.header().putDouble(indexMuteEnd, muteEnd);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void ensemble_CDP(Ensemble ensemble, int cdpID, boolean getData) {
        try {
            long start = System.currentTimeMillis();
            ensemble.clearTraces(false);
            this.m_traceTableWrapper.populateEnsemble(ensemble, "CDPID", cdpID, cdpID);
            this.prepGeometryHeaders(ensemble, true, true);
            if (getData) {
                this.populateData(ensemble, false, true);
            }
            this.prepareMuteTimes(ensemble);
            long end = System.currentTimeMillis();
            System.out.println("cdp Ensemble " + Long.toString(end - start));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void populateData(Ensemble ensemble, boolean rec, boolean shot) {
        try {
            ensemble.sortLong(0, "Trace", "FileID", "Trace", "IndexInFile");
            for (FileInfo info : this.m_fileList) {
                if (info.SeismicFile == null) continue;
                if (info.SeismicFile instanceof Segy) {
                    Segy segy = (Segy)info.SeismicFile;
                    segy.CaptureRawHeaderBytes = true;
                    segy.populateEnsembleWithData(ensemble, info.FileID);
                    this.RecentSegyFileHeader = segy.binaryHeader();
                    this.RecentSegyFileName = segy.fileName();
                    this.RecentEbcdic = segy.ebcdicBytes();
                    continue;
                }
                info.SeismicFile.populateEnsembleWithData(ensemble, info.FileID);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setName(String name) throws Exception {
        try {
            if (this.m_name != null) {
                throw new Exception("(m_name != null)");
            }
            this.m_name = name;
            String parentPath = SharedApplicationData.avoProjectPath();
            this.m_projectPath = parentPath + "/" + this.m_name;
            if (!Tools_FileSystem.exists_path(this.m_projectPath)) {
                throw new Exception("Path does not exist");
            }
            this.m_paramFileName = this.m_projectPath + "/ProjectDescription.xml";
            this.m_information = new ParameterTree();
            this.m_information.read(this.m_paramFileName);
            this.m_runCount = this.m_information.int_get("RunCount", 1);
            this.m_information.int_put("RunCount", this.m_runCount + 1);
            String driverName = this.m_information.string_get("DriverName", "HSQLDB");
            SharedApplicationData.singleton().setDatabaseDriver(driverName);
            this.m_guiOptionsPath = Tools_FileSystem.confirmSubDirectoryExists(this.m_projectPath, "GuiOptions");
            this.reloadFileInfo(true);
            this.m_polygonFileName = this.m_projectPath + "/polygon.pt";
            this.m_polygon.read(this.m_polygonFileName);
            String fileNameDB = this.m_projectPath + "/geometry.db";
            this.m_geometryConn = Tools_JDBC.getConnection(false, fileNameDB);
            this.loadCdpTableFromMemoryDatabase();
            String tracePath = this.m_projectPath + "/TraceTable";
            this.m_traceTableWrapper = new TraceTable_Huge_Wrapper(tracePath);
            this.readMuteArrays("MuteEnd.txt", false);
            this.readMuteArrays("MuteStart.txt", true);
            this.computeStatistics();
            this.m_promaxGridFileName = this.m_projectPath + "/promaxgrid.txt";
            this.m_promaxGrid.readFourCorner(this.m_promaxGridFileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void readMuteArrays(String file, boolean isStart) {
        try {
            String fileName = this.m_projectPath + "/" + file;
            BufferedReader br = new BufferedReader(new FileReader(fileName));
            String line = br.readLine();
            ArrayList<String> tokens = Tools_Strings.tokenizer_space(line, false);
            int count = Integer.parseInt(tokens.get(0));
            double increment = Double.parseDouble(tokens.get(1));
            double[] muteCount = new double[count];
            double[] muteValue = new double[count];
            int n = 0;
            int firstValid = -9999;
            int lastValid = 0;
            line = br.readLine();
            while (line != null) {
                tokens = Tools_Strings.tokenizer_space(line, false);
                muteValue[n] = Double.parseDouble(tokens.get(0));
                muteCount[n] = Double.parseDouble(tokens.get(1));
                if (muteCount[n] > 0.5) {
                    if (firstValid < 0) {
                        firstValid = n;
                    }
                    lastValid = n;
                }
                line = br.readLine();
                ++n;
            }
            br.close();
            for (n = lastValid; n < count; ++n) {
                muteValue[n] = muteValue[lastValid];
            }
            for (n = 0; n < firstValid; ++n) {
                muteValue[n] = muteValue[firstValid];
            }
            for (n = firstValid + 1; n < lastValid; ++n) {
                if (muteCount[n] < 0.5) {
                    int np1 = n + 1;
                    while (muteCount[np1] < 0.5) {
                        ++np1;
                    }
                    int nm1 = n - 1;
                    while (muteCount[nm1] < 0.5) {
                        --nm1;
                    }
                    double a = (muteValue[np1] - muteValue[nm1]) / (double)(np1 - nm1);
                    double b = muteValue[np1] - a * (double)np1;
                    muteValue[n] = a * (double)n + b;
                }
                System.out.println(String.format("%d  %d  %f", n, (int)muteCount[n], Float.valueOf((float)muteValue[n])));
            }
            if (isStart) {
                this.m_muteStartIncrement = increment;
                this.m_muteStartCount = muteCount;
                this.m_muteStartValue = muteValue;
            } else {
                this.m_muteEndIncrement = increment;
                this.m_muteEndCount = muteCount;
                this.m_muteEndValue = muteValue;
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void reloadFileInfo(boolean openDialog) throws Exception {
        try {
            this.m_fileList.clear();
            String origin = this.m_information.string_get("Origin");
            boolean isSegy = origin.equalsIgnoreCase("SEGY");
            boolean isGLI = origin.equalsIgnoreCase("GLI");
            this.m_fileTable = Table_Memory.readTable(this.m_projectPath, "FileList");
            if (this.m_fileTable != null) {
                int indexID = this.m_fileTable.column_indexOfColumn("FileID");
                int indexName = this.m_fileTable.column_indexOfColumn("Name");
                int indexPath = this.m_fileTable.column_indexOfColumn("Directory");
                boolean fileNotFound = false;
                for (int n = 0; n < this.m_fileTable.row_count(); ++n) {
                    FileInfo info = new FileInfo();
                    info.FileID = this.m_fileTable.getInt(n, indexID);
                    info.Name = this.m_fileTable.getString(n, indexName);
                    info.Path = this.m_fileTable.getString(n, indexPath);
                    info.FullPath = info.Path + "/" + info.Name;
                    if (Tools_FileSystem.exists_file(info.FullPath)) {
                        Segy segy = new Segy();
                        segy.setFileName(info.FullPath);
                        if (segy.isFileOK()) {
                            info.SeismicFile = segy;
                        }
                    }
                    this.m_fileList.add(info);
                }
                if (fileNotFound) {
                    JOptionPane.showMessageDialog(null, "Seismic files not found", "", 0);
                    if (openDialog) {
                        SeismicFileManagerDialog dlg = new SeismicFileManagerDialog();
                        this.reloadFileInfo(false);
                    }
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void loadCdpTableFromMemoryDatabase() {
        try {
            this.m_cdpTable = this.m_geometryConn.extractTableDataUsingQuery("CDP", "SELECT * FROM CDP", 0);
            this.m_cdpMap = this.m_cdpTable.createMapID();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public boolean statisticsValid() {
        return this.m_statisticsValid;
    }

    public double averageRatio() {
        return this.m_averageRatio;
    }

    public void computeStatistics() {
        try {
            this.m_statisticsValid = false;
            if (!this.m_cdpTable.column_exists("G_div_R")) {
                return;
            }
            int indexAvgG = this.m_cdpTable.column_indexOfColumn("AverageG");
            int indexAvgR = this.m_cdpTable.column_indexOfColumn("AverageR");
            int indexRat = this.m_cdpTable.column_indexOfColumn("G_div_R");
            int indexMaxOff = this.m_cdpTable.column_indexOfColumn("MaxOffset");
            int indexNumValid = this.m_cdpTable.column_indexOfColumn("NumValid");
            double sum1 = 0.0;
            double sum2 = 1.0E-20;
            for (int row = 0; row < this.m_cdpTable.row_count(); ++row) {
                double maxOff = this.m_cdpTable.getDouble(row, indexMaxOff);
                double num = this.m_cdpTable.getDouble(row, indexNumValid);
                double rat = this.m_cdpTable.getDouble(row, indexRat);
                if (!(rat > 0.0) || !(num > 0.0) || !(maxOff > 0.0)) continue;
                double weight = num * maxOff;
                sum1 += weight * rat;
                sum2 += weight;
            }
            this.m_averageRatio = sum1 / sum2;
            this.m_statisticsValid = true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class FileInfo {
        public String Name;
        public String Path;
        public String FullPath;
        public int FileID;
        public ISeismicFile SeismicFile;
    }
}

