/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_Widget;
import com.PecosCore.Windows.Parameter.ParameterBase;
import com.PecosCore.Windows.Shared.GridLayoutWidget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class Parameter_Grid
extends ParameterBase
implements ActionListener {
    protected ArrayList<Row> m_rows = new ArrayList();
    protected ArrayList<JTextField> m_txtList = new ArrayList();
    protected GridWidget m_editor = null;

    public Parameter_Grid(ParameterTree pt, String parameterName, String tabPageName, int editorVerticalStretch, int editorHorizontalStretch) throws Exception {
        super(pt, parameterName, tabPageName, editorVerticalStretch, editorHorizontalStretch);
    }

    public void addRow(String key, String label, String defaultValue) throws Exception {
        try {
            if (this.m_editor != null) {
                throw new Exception("m_editor != null");
            }
            if (key.isEmpty()) {
                throw new Exception("key.isEmpty()");
            }
            for (Row row : this.m_rows) {
                if (!key.equalsIgnoreCase(row.Key)) continue;
                throw new Exception("Key already exists");
            }
            Row r = new Row();
            r.Key = key;
            r.Label = label;
            r.Default = defaultValue;
            if (this.m_parameterTree.string_exists(key)) {
                r.Default = this.m_parameterTree.string_get(key);
            } else {
                this.m_parameterTree.string_put(key, r.Default);
            }
            this.m_rows.add(r);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.updateParametersFromEditor();
            this.broadcast(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String getGridString(String gridKey) throws Exception {
        try {
            if (gridKey.isEmpty()) {
                throw new Exception("gridKey.isEmpty()");
            }
            if (this.m_editor != null) {
                for (int r = 0; r < this.m_rows.size(); ++r) {
                    Row row = this.m_rows.get(r);
                    if (!gridKey.equalsIgnoreCase(row.Key)) continue;
                    String v = this.m_txtList.get(r).getText();
                    this.m_parameterTree.string_put(gridKey, v);
                    row.Default = v;
                    return v;
                }
                throw new Exception("key not found: " + gridKey);
            }
            for (Row row : this.m_rows) {
                if (!gridKey.equalsIgnoreCase(row.Key)) continue;
                return row.Default;
            }
            throw new Exception("key not found: " + gridKey);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public double getGridDouble(String gridKey, double defValue, double min, double max) throws Exception {
        try {
            if (gridKey.isEmpty()) {
                throw new Exception("gridKey.isEmpty()");
            }
            if (this.m_editor != null) {
                for (int r = 0; r < this.m_rows.size(); ++r) {
                    Row row = this.m_rows.get(r);
                    if (!gridKey.equalsIgnoreCase(row.Key)) continue;
                    JTextField txt = this.m_txtList.get(r);
                    double v = Tools_Widget.extractDouble(txt, defValue, min, max);
                    this.m_parameterTree.double_put(gridKey, v);
                    row.Default = Double.toString(v);
                    return v;
                }
                throw new Exception("key not found: " + gridKey);
            }
            for (Row row : this.m_rows) {
                if (!gridKey.equalsIgnoreCase(row.Key)) continue;
                double v = Tools_Widget.extractDouble(row.Default, defValue, min, max);
                this.m_parameterTree.double_put(gridKey, v);
                row.Default = Double.toString(v);
                return v;
            }
            throw new Exception("key not found: " + gridKey);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public int getGridInt(String gridKey, int defvalue, int min, int max) throws Exception {
        try {
            if (gridKey.isEmpty()) {
                throw new Exception("gridKey.isEmpty()");
            }
            if (this.m_editor != null) {
                for (int r = 0; r < this.m_rows.size(); ++r) {
                    Row row = this.m_rows.get(r);
                    if (!gridKey.equalsIgnoreCase(row.Key)) continue;
                    JTextField txt = this.m_txtList.get(r);
                    int v = Tools_Widget.extractInteger(txt, defvalue, min, max);
                    this.m_parameterTree.int_put(gridKey, v);
                    row.Default = Integer.toString(v);
                    return v;
                }
                throw new Exception("key not found: " + gridKey);
            }
            for (Row row : this.m_rows) {
                if (!gridKey.equalsIgnoreCase(row.Key)) continue;
                int v = Tools_Widget.extractInteger(row.Default, defvalue, min, max);
                this.m_parameterTree.int_put(gridKey, v);
                row.Default = Integer.toString(v);
                return v;
            }
            throw new Exception("key not found: " + gridKey);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public JComponent editor() {
        try {
            if (this.m_editor != null) {
                return this.m_editor;
            }
            this.m_editor = new GridWidget();
            for (int r = 0; r < this.m_rows.size(); ++r) {
                Row row = this.m_rows.get(r);
                JTextField txt = new JTextField(row.Default);
                this.m_txtList.add(txt);
                this.m_editor.addSimple(r, new JLabel(row.Label), txt);
            }
            return this.m_editor;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    @Override
    public void updateParametersFromEditor() {
        try {
            if (this.m_editor == null) {
                return;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class GridWidget
    extends GridLayoutWidget {
        public GridWidget() {
            super(0, null);
        }
    }

    protected class Row {
        public String Key;
        public String Label;
        public String Default;

        protected Row() {
        }
    }
}

