/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.ParameterPanel;
import com.PecosCore.Windows.Parameter.ParameterTreeModelNode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class ParameterTreeWidget
extends JPanel {
    ParameterTreeModelNode _root;
    GridBagLayout _layout;
    Random seed;

    public ParameterTreeWidget(ParameterTreeModelNode root) {
        try {
            this._root = root;
            final JLabel colorLabel = new JLabel();
            colorLabel.setHorizontalAlignment(0);
            Dimension d = colorLabel.getPreferredSize();
            d.height = 25;
            colorLabel.setPreferredSize(d);
            JTree tree = this.createTree(this._root);
            tree.setCellRenderer(new PanelRenderer());
            tree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent e) {
                    TreePath path = e.getNewLeadSelectionPath();
                    Object obj = path.getLastPathComponent();
                    if (obj != null) {
                        DefaultMutableTreeNode node = (DefaultMutableTreeNode)obj;
                        ParameterTreeModelNode parameterNode = (ParameterTreeModelNode)node;
                        String s = parameterNode.getHelpMessage();
                        colorLabel.setText(s);
                    }
                }
            });
            this._layout = new GridBagLayout();
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.setLayout(this._layout);
            this.add(new JScrollPane(tree));
            this.add(colorLabel);
            this.setSize(400, 400);
            this.setLocation(200, 200);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    private JTree createTree(ParameterTreeModelNode root) throws Exception {
        try {
            int nChildren = root.getChildCount();
            for (int iChild = 0; iChild < nChildren; ++iChild) {
                ParameterTreeModelNode child = (ParameterTreeModelNode)root.getChildAt(iChild);
                int nGrandChildren = child.getChildCount();
                for (int iGC = 0; iGC < nGrandChildren; ++iGC) {
                    ParameterTreeModelNode gc = (ParameterTreeModelNode)child.getChildAt(iGC);
                    for (int iGGC = 0; iGGC < gc.getChildCount(); ++iGGC) {
                        ParameterTreeModelNode parameterTreeModelNode = (ParameterTreeModelNode)child.getChildAt(iGGC);
                    }
                }
            }
            DefaultTreeModel model = new DefaultTreeModel(root);
            return new JTree(model);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    class PanelRenderer
    implements TreeCellRenderer {
        HashMap<ParameterTreeModelNode, ParameterPanel> _panelHash = new HashMap();
        JLabel _lblDescription;
        JTextField _txtValue;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ParameterTreeModelNode treeNode = (ParameterTreeModelNode)value;
            ParameterPanel panel = null;
            if (this._panelHash.containsKey(treeNode)) {
                panel = this._panelHash.get(treeNode);
            }
            return null;
        }
    }
}

