/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Windows.Parameter;

import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Windows.Parameter.ParameterTreeModelNode;
import com.PecosCore.Windows.Parameter.ParameterTreeModelNodeType;
import com.PecosCore.Windows.Parameter.PropertyChangeEventFromTextField;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ParameterPanel
implements ActionListener,
DocumentListener {
    JToggleButton _btnSetNotUsed;
    JLabel _lblDescription;
    JTextField _txtValue;
    JComboBox _cmbBox;
    JRadioButton _radioButton;
    ParameterTreeModelNode _node;
    String _sPreviousValue = "";
    int _maxHeight = 20;
    private final PropertyChangeSupport _pcs = new PropertyChangeSupport(this);
    List<ParameterPanel> _childPanels = new ArrayList<ParameterPanel>();

    public ParameterPanel(ParameterTreeModelNode node, JComponent panel, int iRow) {
        try {
            GridBagConstraints gbc = new GridBagConstraints();
            this._node = node;
            this._sPreviousValue = this._node.getStringValue();
            this._btnSetNotUsed = new JToggleButton("x");
            this._lblDescription = new JLabel(this._node.ParameterDescription);
            this._txtValue = new JTextField(this._node.getStringValue());
            this._cmbBox = new JComboBox();
            this._cmbBox.setEditable(true);
            boolean bActivated = this._node.getActivated();
            this._btnSetNotUsed.setSelected(bActivated);
            if (node.NodeType == ParameterTreeModelNodeType.Parameter) {
                if (node.Options != null) {
                    String sSelected = null;
                    for (String sVal : node.Options) {
                        this._cmbBox.addItem(sVal);
                        if (!sVal.equals(node)) continue;
                        sSelected = sVal;
                    }
                    if (sSelected != null) {
                        this._cmbBox.setSelectedItem(sSelected);
                    } else if (this._cmbBox.getItemCount() > 0) {
                        this._cmbBox.setSelectedIndex(0);
                    }
                }
                gbc.fill = 2;
                gbc.gridx = 0;
                gbc.gridy = iRow;
                gbc.anchor = 21;
                gbc.ipadx = 10;
                gbc.ipady = 3;
                panel.add((Component)this._lblDescription, gbc);
                gbc.weightx = 10.0;
                ++gbc.gridx;
                if (this._node.Options == null) {
                    if (this._node.Datatype == DataType.Bool) {
                        this._radioButton = new JRadioButton();
                        boolean bValue = Boolean.parseBoolean(node.getStringValue());
                        this._radioButton.setSelected(bValue);
                        panel.add((Component)this._radioButton, gbc);
                        this._radioButton.addActionListener(this);
                    } else {
                        panel.add((Component)this._txtValue, gbc);
                    }
                } else {
                    panel.add((Component)this._cmbBox, gbc);
                }
                gbc.weightx = 1.0;
                ++gbc.gridx;
                if (!node.Required && this._node.Datatype != DataType.Bool) {
                    panel.add((Component)this._btnSetNotUsed, gbc);
                }
                if (!node.getActivated()) {
                    this._txtValue.setEnabled(false);
                    this._lblDescription.setEnabled(false);
                    this._txtValue.setText(this._node.getDeactivatedText());
                }
            } else if (node.NodeType == ParameterTreeModelNodeType.Group) {
                gbc.fill = 2;
                gbc.gridx = 0;
                gbc.gridy = iRow;
                gbc.anchor = 21;
                gbc.ipadx = 10;
                gbc.ipady = 3;
                String sFontName = this._lblDescription.getFont().getFontName();
                int iFontSize = this._lblDescription.getFont().getSize();
                this._lblDescription.setFont(new Font(sFontName, 1, ++iFontSize));
                panel.add((Component)this._lblDescription, gbc);
                gbc.weightx = 1.0;
                gbc.gridx = 2;
                if (!node.Required) {
                    this._radioButton = new JRadioButton();
                    boolean bValue = Boolean.parseBoolean(node.getStringValue());
                    this._radioButton.setSelected(bValue);
                    panel.add((Component)this._radioButton, gbc);
                    this._radioButton.addActionListener(this);
                }
            }
            this.setStringValue(this._node.getStringValue());
            this._btnSetNotUsed.addActionListener(this);
            this._txtValue.getDocument().addDocumentListener(this);
            this._txtValue.addActionListener(this);
            this._cmbBox.addActionListener(this);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setVisible(boolean bVisible) {
        try {
            if (this._btnSetNotUsed != null) {
                this._btnSetNotUsed.setVisible(bVisible);
            }
            if (this._lblDescription != null) {
                this._lblDescription.setVisible(bVisible);
            }
            if (this._txtValue != null) {
                this._txtValue.setVisible(bVisible);
            }
            if (this._cmbBox != null) {
                this._cmbBox.setVisible(bVisible);
            }
            if (this._radioButton != null) {
                this._radioButton.setVisible(bVisible);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ParameterTreeModelNode getNode() {
        return this._node;
    }

    public void setDescription(String sDescription) {
        this._lblDescription.setText(sDescription);
    }

    public String getDescription() {
        String sVal = this._lblDescription.getText();
        return sVal;
    }

    public void setStringValue(String sVal) {
        if (this._node.Options != null) {
            String sSelectedOption = null;
            int nItems = this._cmbBox.getItemCount();
            for (int i = 0; i < nItems; ++i) {
                String s = (String)this._cmbBox.getItemAt(i);
                if (!s.equals(sVal)) continue;
                sSelectedOption = s;
            }
            if (sSelectedOption != null) {
                this._cmbBox.setSelectedItem(sSelectedOption);
            }
        } else if (this._node.getActivated()) {
            this._txtValue.setText(sVal);
        } else {
            this._txtValue.setText(this._node.getDeactivatedText());
        }
    }

    public String getStringValue() {
        if (this._node.Options != null) {
            String sVal = (String)this._cmbBox.getSelectedItem();
            return sVal;
        }
        String sVal = this._txtValue.getText();
        return sVal;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            PropertyChangeEvent evt;
            if (e.getSource() == this._btnSetNotUsed) {
                if (this._btnSetNotUsed.isSelected()) {
                    this._txtValue.setEnabled(true);
                    this._lblDescription.setEnabled(true);
                    String oldValue = this._txtValue.getText();
                    this._txtValue.setText(this._sPreviousValue);
                    this._node.setActivated(true);
                    evt = new PropertyChangeEventFromTextField(this._node, this._node.ParameterName, "na", this._node.getStringValue(), true, !this._node.Required, this._btnSetNotUsed.isSelected());
                    this._pcs.firePropertyChange(evt);
                } else {
                    this._txtValue.setEnabled(false);
                    this._lblDescription.setEnabled(false);
                    this._sPreviousValue = this._txtValue.getText();
                    this._txtValue.setText(this._node.getDeactivatedText());
                    this._node.setActivated(false);
                    PropertyChangeEventFromTextField evt2 = new PropertyChangeEventFromTextField(this._node, this._node.ParameterName, "na", this._node.getStringValue(), true, !this._node.Required, this._btnSetNotUsed.isSelected());
                    this._pcs.firePropertyChange(evt2);
                }
            }
            if (e.getSource() == this._cmbBox) {
                String sVal = (String)this._cmbBox.getSelectedItem();
                this._node.setStringValue(sVal);
                evt = new PropertyChangeEvent(this._node, this._node.ParameterName, "", this._node.getStringValue());
                this._pcs.firePropertyChange(evt);
            }
            if (e.getSource() == this._radioButton) {
                boolean bSelected = this._radioButton.isSelected();
                this._node.setStringValue(Boolean.toString(bSelected));
                evt = new PropertyChangeEvent(this._node, this._node.ParameterName, "", this._node.getStringValue());
                this._pcs.firePropertyChange(evt);
            }
            if (e.getSource() == this._txtValue) {
                PropertyChangeEventFromTextField evt3 = new PropertyChangeEventFromTextField(this._node, this._node.ParameterName, "", this._node.getStringValue(), true, !this._node.Required, this._btnSetNotUsed.isSelected());
                this._pcs.firePropertyChange(evt3);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this._txtValue.getDocument()) {
                this.updateTextValue();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this._txtValue.getDocument()) {
                this.updateTextValue();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        try {
            if (e.getDocument() == this._txtValue.getDocument()) {
                this.updateTextValue();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    void updateTextValue() {
        try {
            String sVal = this._txtValue.getText();
            if (!sVal.equals(this._node.getDeactivatedText())) {
                this._node.setStringValue(sVal);
            }
            PropertyChangeEventFromTextField evt = new PropertyChangeEventFromTextField(this._node, this._node.ParameterName, "", this._node.getStringValue(), false, !this._node.Required, this._btnSetNotUsed.isSelected());
            this._pcs.firePropertyChange(evt);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void addChildPanel(ParameterPanel panel) {
        try {
            this._childPanels.add(panel);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public List<ParameterPanel> getChildPanels() {
        return this._childPanels;
    }

    public AbstractButton getRadioButton() {
        return this._radioButton;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(listener);
    }
}

