/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Tools;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.SharedApplicationData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class Tools_Widget {
    public static void setCursor(int cursor) {
        try {
            JFrame frame = SharedApplicationData.singleton().appFrame();
            if (frame == null) {
                return;
            }
            frame.setCursor(Cursor.getPredefinedCursor(cursor));
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void setEnabled(Component component, boolean enabled, boolean recursive) {
        try {
            if (component == null) {
                return;
            }
            component.setEnabled(enabled);
            if (recursive && component instanceof Container) {
                Component[] childArray = ((Container)component).getComponents();
                if (childArray == null) {
                    return;
                }
                for (Component child : childArray) {
                    Tools_Widget.setEnabled(child, enabled, true);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static void changeBackground(Component component, Color c, boolean recursive) {
        try {
            if (component == null) {
                return;
            }
            component.setBackground(c);
            if (recursive && component instanceof Container) {
                Component[] childArray = ((Container)component).getComponents();
                if (childArray == null) {
                    return;
                }
                for (Component child : childArray) {
                    Tools_Widget.changeBackground(child, c, true);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public static int extractInteger(String text, int failureValue, int minimum, int maximum) {
        try {
            int v = Integer.parseInt(text);
            if (v > maximum) {
                return maximum;
            }
            if (v < minimum) {
                return minimum;
            }
            return v;
        }
        catch (Exception exception) {
            return failureValue;
        }
    }

    public static int extractInteger(JTextField textField, int failureValue, int minimum, int maximum) {
        try {
            String s = textField.getText();
            int v = Integer.parseInt(s);
            if (v > maximum) {
                textField.setText(Integer.toString(maximum));
                return maximum;
            }
            if (v < minimum) {
                textField.setText(Integer.toString(minimum));
                return minimum;
            }
            return v;
        }
        catch (Exception error) {
            error.printStackTrace();
            try {
                textField.setText(Integer.toString(failureValue));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return failureValue;
        }
    }

    public static double extractDouble(JTextField textField, double failureValue, double minimum, double maximum) {
        try {
            double v = Double.parseDouble(textField.getText());
            if (v > maximum) {
                textField.setText(Double.toString(maximum));
                return maximum;
            }
            if (v < minimum) {
                textField.setText(Double.toString(minimum));
                return minimum;
            }
            return v;
        }
        catch (Exception exception) {
            try {
                textField.setText(Double.toString(failureValue));
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return failureValue;
        }
    }

    public static double extractDouble(String text, double failureValue, double minimum, double maximum) {
        try {
            double v = Double.parseDouble(text);
            if (v > maximum) {
                return maximum;
            }
            if (v < minimum) {
                return minimum;
            }
            return v;
        }
        catch (Exception exception) {
            return failureValue;
        }
    }
}

