/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Tools;

import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class Tools_Chooser {
    public static String prepareCurrentPath(JFileChooser fileChooser) {
        try {
            Preferences prefs = Preferences.userRoot();
            String path = prefs.get("FileChooserPath", "");
            if (fileChooser != null && Tools_FileSystem.exists_path(path)) {
                fileChooser.setCurrentDirectory(new File(path));
            }
            return path;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return "";
        }
    }

    public static void saveCurrentPath(JFileChooser fileChooser) {
        try {
            if (fileChooser == null) {
                return;
            }
            String path = fileChooser.getCurrentDirectory().getAbsolutePath();
            if (!Tools_FileSystem.exists_path(path)) {
                return;
            }
            Preferences prefs = Preferences.userRoot();
            prefs.put("FileChooserPath", path);
            prefs.sync();
            prefs.flush();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static String getSaveFileName_StartPath(String path, String suffix) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(new File(path));
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showSaveDialog(null) != 0) {
                return null;
            }
            if (fileChooser.getSelectedFile().isDirectory()) {
                return null;
            }
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String getSaveFileName(String suffix) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            String currPath = Tools_Chooser.prepareCurrentPath(fileChooser);
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showSaveDialog(null) != 0) {
                return null;
            }
            if (fileChooser.getSelectedFile().isDirectory()) {
                return null;
            }
            if (fileChooser.getSelectedFile() == null) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            String fileName = fileChooser.getSelectedFile().getAbsolutePath();
            return Tools_Strings.confirmSuffix(fileName, suffix);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static ArrayList<String> getFileNames(ArrayList<String> extensions) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            String currPath = Tools_Chooser.prepareCurrentPath(fileChooser);
            fileChooser.setFileSelectionMode(0);
            fileChooser.setMultiSelectionEnabled(true);
            if (fileChooser.showOpenDialog(null) != 0) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            File[] selFiles = fileChooser.getSelectedFiles();
            if (selFiles == null) {
                return null;
            }
            if (selFiles.length < 1) {
                return null;
            }
            ArrayList<String> fileNames = new ArrayList<String>();
            for (File file : selFiles) {
                if (!file.isFile()) continue;
                fileNames.add(file.getAbsolutePath());
            }
            return fileNames;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String getFileName(String title, FileNameExtensionFilter filter) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            if (title != null) {
                fileChooser.setDialogTitle(title);
            }
            if (filter != null) {
                fileChooser.setFileFilter(filter);
            }
            String currPath = Tools_Chooser.prepareCurrentPath(fileChooser);
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(null) != 0) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String getFileName() {
        try {
            JFileChooser fileChooser = new JFileChooser();
            String currPath = Tools_Chooser.prepareCurrentPath(fileChooser);
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(null) != 0) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String getFileName_StartPath(String startPath, FileNameExtensionFilter filter) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(new File(startPath));
            fileChooser.setFileSelectionMode(0);
            if (filter != null) {
                fileChooser.setFileFilter(filter);
            }
            if (fileChooser.showOpenDialog(null) != 0 || fileChooser.getSelectedFile().isDirectory() || fileChooser.getSelectedFile() == null) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String getFileName_StartPath(String startPath) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(new File(startPath));
            fileChooser.setFileSelectionMode(0);
            if (fileChooser.showOpenDialog(null) != 0 || fileChooser.getSelectedFile().isDirectory() || fileChooser.getSelectedFile() == null) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String getDirectory(String dialogTitle) {
        try {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setDialogTitle(dialogTitle);
            String currPath = Tools_Chooser.prepareCurrentPath(fileChooser);
            fileChooser.setFileSelectionMode(1);
            if (fileChooser.showOpenDialog(null) != 0) {
                return null;
            }
            Tools_Chooser.saveCurrentPath(fileChooser);
            return fileChooser.getSelectedFile().getAbsolutePath();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }
}

