/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.IAppDataOverride;
import com.PecosCore.Tools.Tools_Chooser;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Windows.Shared.IComponentManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

public class SharedApplicationData {
    protected String m_os = "";
    protected IAppDataOverride m_appDataOverride = null;
    public String TypeOfDisplay;
    public int NextValidIndex;
    public static int SolutionStackStartCode = 1000;
    public static int ProcessorCount = 1;
    public static boolean JobRunning = false;
    public static boolean ShowAdvancedOptions = false;
    public static boolean ProcessWizardMode = false;
    public static boolean ExpertMode = false;
    public static boolean KillLaunchText = true;
    public static boolean SEI = false;
    public static boolean SEI2D = false;
    public Object LaunchData = null;
    protected static SharedApplicationData m_singleton = null;
    public int FontSize = -2;
    protected int m_toolBarHeight = 15;
    protected String m_homeDirectory = "";
    protected String m_defaultGuiDirectory = "";
    protected JFrame m_appFrame = null;
    protected IComponentManager m_componentManager;
    public String SharedString = null;
    public HashMap<String, String> LaunchCodes = null;
    public static int Tabs = 0;
    public static int MDI = 1;
    public static int SplitTabs = 2;
    protected int m_windowLayout = Tabs;
    protected boolean m_gravityOkay = true;
    protected ParameterTree m_parameterTree = new ParameterTree();
    protected String m_parameterTreeFileName = "";
    protected ParameterTree m_sqlTree = new ParameterTree();
    protected String m_fileNameSql;
    protected String m_fileNameMathSql;
    protected String m_fileNameSelectSql;
    protected ArrayList<String> m_sqlListMath = new ArrayList();
    protected ArrayList<String> m_sqlListSelect = new ArrayList();
    protected String m_databaseDriver = "HSQLDB";
    protected boolean m_isTricon = false;
    protected int m_lineNumberLength = 3;

    public int toolBarHeight() {
        return this.m_toolBarHeight;
    }

    public void setToolBarHeight(int toolBarHeight) {
        this.m_toolBarHeight = Math.max(toolBarHeight, 15);
    }

    public int windowLayout() {
        return this.m_windowLayout;
    }

    public boolean gravityOkay() {
        return this.m_gravityOkay;
    }

    public void appendSQL(String type, String sql) {
        try {
            ArrayList<String> list = null;
            String fileName = null;
            sql = sql.toUpperCase();
            if (type.equalsIgnoreCase("Math")) {
                fileName = this.m_fileNameMathSql;
                list = this.m_sqlListMath;
            }
            if (type.equalsIgnoreCase("Select")) {
                sql = sql.replaceAll("SHOT", "TABLENAME");
                sql = sql.replaceAll("RECEIVER", "TABLENAME");
                fileName = this.m_fileNameSelectSql;
                list = this.m_sqlListSelect;
            }
            if (list == null) {
                return;
            }
            list.add(sql);
            BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
            for (String s : list) {
                writer.write(s);
                writer.newLine();
            }
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ArrayList<String> getListSQL(String type) {
        try {
            if (type.equalsIgnoreCase("Math")) {
                return this.m_sqlListMath;
            }
            if (type.equalsIgnoreCase("Select")) {
                return this.m_sqlListSelect;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String databaseDriver() {
        return this.m_databaseDriver;
    }

    public void setDatabaseDriver(String databaseDriver) {
        try {
            boolean okay;
            if (databaseDriver == null) {
                return;
            }
            this.m_databaseDriver = databaseDriver;
            boolean bl = okay = this.m_databaseDriver.equalsIgnoreCase("SQLITE") || this.m_databaseDriver.equalsIgnoreCase("HSQLDB") || this.m_databaseDriver.equalsIgnoreCase("Derby") || this.m_databaseDriver.equalsIgnoreCase("HSQLDB");
            if (!okay) {
                this.m_databaseDriver = "HSQLDB";
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.m_databaseDriver = "HSQLDB";
            return;
        }
    }

    public String getOS() {
        return this.m_os;
    }

    public boolean isWindows() {
        try {
            return this.m_os.toLowerCase().startsWith("window");
        }
        catch (Exception error) {
            error.printStackTrace();
            return false;
        }
    }

    public boolean isTricon() {
        return this.m_isTricon;
    }

    protected SharedApplicationData(IAppDataOverride appDataOverride) {
        try {
            this.m_appDataOverride = appDataOverride;
            this.m_os = System.getProperty("os.name", "error");
            Preferences prefs = Preferences.userRoot();
            this.FontSize = prefs.getInt("FontSize", -2);
            this.m_windowLayout = prefs.getInt("WindowLayout", Tabs);
            Map<String, String> env = System.getenv();
            String homePath = null;
            homePath = prefs.get("HomeDirectory", "");
            if (!this.checkHomePath(homePath)) {
                try {
                    Properties systemProps = System.getProperties();
                    if (systemProps.containsKey("user.home")) {
                        String userHome = systemProps.getProperty("user.home");
                        homePath = Tools_FileSystem.confirmSubDirectoryExists(userHome, "CanonHome");
                    }
                }
                catch (Exception exProps) {
                    exProps.printStackTrace();
                    homePath = "";
                }
            }
            if (!this.checkHomePath(homePath) && env.containsKey("CANONHOME")) {
                homePath = env.get("CANONHOME");
            }
            while (!this.checkHomePath(homePath)) {
                homePath = Tools_Chooser.getDirectory("Select a top-level path for XtremeGeo projects");
            }
            this.setHomePath(homePath);
            try {
                Class.forName("org.hsqldb.jdbc.JDBCDriver");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected boolean checkHomePath(String homePath) {
        try {
            if (homePath == null) {
                return false;
            }
            if (!Tools_FileSystem.exists_path(homePath)) {
                return false;
            }
            File f = new File(homePath);
            if (!f.canWrite()) {
                return false;
            }
            if (!f.canRead()) {
                return false;
            }
            Tools_FileSystem.confirmSubDirectoryExists(homePath, "RefractionProjects");
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean allowTestCode() {
        try {
            String homePath = SharedApplicationData.singleton().homeDirectory();
            String testFilePath = homePath + "/test.txt";
            return Tools_FileSystem.exists_file(testFilePath);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public String getEchosUser() {
        String sUser = "";
        try {
            Preferences prefs = Preferences.userRoot();
            sUser = prefs.get("EchosUser", "");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
        return sUser;
    }

    public void setEchosUser(String sEchosUser) {
        try {
            Preferences prefs = Preferences.userRoot();
            prefs.put("EchosUser", sEchosUser);
            prefs.flush();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setHomePath(String homePath) {
        try {
            String sql;
            BufferedReader br;
            if (!this.checkHomePath(homePath)) {
                return;
            }
            this.m_homeDirectory = homePath;
            Preferences prefs = Preferences.userRoot();
            prefs.put("HomeDirectory", this.m_homeDirectory);
            prefs.flush();
            this.m_defaultGuiDirectory = this.homeSubDirectory("GuiOptions");
            this.m_parameterTreeFileName = this.m_homeDirectory + "/Options.xml";
            if (Tools_FileSystem.exists_file(this.m_parameterTreeFileName)) {
                this.m_parameterTree.read(this.m_parameterTreeFileName);
            } else {
                this.m_parameterTree.save(this.m_parameterTreeFileName);
            }
            String triconSubDir = this.m_homeDirectory + "/Tricon";
            this.m_isTricon = Tools_FileSystem.exists_path(triconSubDir);
            this.m_fileNameSql = this.m_homeDirectory + "/SQL.xml";
            if (Tools_FileSystem.exists_file(this.m_fileNameSql)) {
                this.m_sqlTree.read(this.m_fileNameSql);
            }
            this.m_fileNameMathSql = this.m_homeDirectory + "/MathSQL.txt";
            this.m_fileNameSelectSql = this.m_homeDirectory + "/SelectSQL.txt";
            if (Tools_FileSystem.exists_file(this.m_fileNameMathSql)) {
                br = new BufferedReader(new FileReader(this.m_fileNameMathSql));
                sql = br.readLine();
                while (sql != null) {
                    this.m_sqlListMath.add(sql);
                    sql = br.readLine();
                }
                br.close();
            }
            if (Tools_FileSystem.exists_file(this.m_fileNameSelectSql)) {
                br = new BufferedReader(new FileReader(this.m_fileNameSelectSql));
                sql = br.readLine();
                while (sql != null) {
                    this.m_sqlListSelect.add(sql);
                    sql = br.readLine();
                }
                br.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public ParameterTree getParameterTree() {
        return this.m_parameterTree;
    }

    public void saveParameterTree() {
        try {
            this.m_parameterTree.save(this.m_parameterTreeFileName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String defaultGuiDirectory() {
        return this.m_defaultGuiDirectory;
    }

    public void setComponentManager(IComponentManager cm) {
        this.m_componentManager = cm;
    }

    public IComponentManager getComponentManager() {
        return this.m_componentManager;
    }

    public JFrame appFrame() {
        return this.m_appFrame;
    }

    public void setAppFrame(JFrame frame) {
        this.m_appFrame = frame;
    }

    public void launchBatch(int megaBytes) {
        try {
            megaBytes = Math.max(megaBytes, 64);
            megaBytes = Math.min(megaBytes, 4096);
            String execCommand = String.format("java -Xmx%dm -Xms%dm -jar FlatironsVelocity.jar  -batch", megaBytes, megaBytes);
            System.out.println("execCommand:   " + execCommand);
            Process process = Runtime.getRuntime().exec(execCommand);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void startAnotherApplication(String frameClassName, int megabytes) {
    }

    public void saveUserPreference(String key, String val) {
        try {
            Preferences prefs = Preferences.userRoot();
            prefs.put(key, val);
            prefs.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getEnvironmentVariable(String name) {
        try {
            Map<String, String> env = System.getenv();
            for (String envName : env.keySet()) {
                if (!envName.equalsIgnoreCase(name)) continue;
                return env.get(envName);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String homeSubDirectory(String subDirectory) {
        try {
            return Tools_FileSystem.confirmSubDirectoryExists(this.m_homeDirectory, subDirectory);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public static String coordinateInterpolationProjectsPath() {
        return SharedApplicationData.singleton().homeSubDirectory("CoordinateInterpolationProjects");
    }

    public static String avoProjectPath() {
        return SharedApplicationData.singleton().homeSubDirectory("AvoProjects");
    }

    public static String staticsProjectPath() {
        if (SharedApplicationData.singleton().m_appDataOverride == null) {
            return SharedApplicationData.singleton().homeSubDirectory("RefractionProjects");
        }
        return SharedApplicationData.singleton().m_appDataOverride.overrideProjectsPath();
    }

    public static String volumeProjectPath() {
        return SharedApplicationData.singleton().homeSubDirectory("VolumeProjects");
    }

    public static String velocityProjectPath() {
        return SharedApplicationData.singleton().homeSubDirectory("VelocityProjects");
    }

    public static String geometryProjectPath() {
        return SharedApplicationData.singleton().homeSubDirectory("GeometryProjects");
    }

    public static String residualProjectPath() {
        if (SharedApplicationData.singleton().m_appDataOverride == null) {
            return SharedApplicationData.singleton().homeSubDirectory("ResidualProjects");
        }
        return SharedApplicationData.singleton().m_appDataOverride.overrideProjectsPath();
    }

    public static String residualDataPath() {
        return SharedApplicationData.singleton().homeSubDirectory("ResidualData");
    }

    public static String residualScratch() {
        return SharedApplicationData.singleton().homeSubDirectory("ResidualScratch");
    }

    public String homeDirectory() {
        return this.m_homeDirectory;
    }

    public static SharedApplicationData singleton(IAppDataOverride appDataOverride) {
        try {
            if (m_singleton == null) {
                m_singleton = new SharedApplicationData(appDataOverride);
            } else if (appDataOverride != null && m_singleton.appDataOverride() == null) {
                SharedApplicationData.m_singleton.m_appDataOverride = appDataOverride;
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static SharedApplicationData singleton() {
        try {
            return SharedApplicationData.singleton(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public IAppDataOverride appDataOverride() {
        return this.m_appDataOverride;
    }

    public void setLineNumberLength(int length) {
        this.m_lineNumberLength = length;
    }

    public int lineNumberLength() {
        return this.m_lineNumberLength;
    }
}

