/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class MemoryMonitor {
    Runtime m_runtime;
    MemoryMXBean m_memoryMXBean;
    protected static MemoryMonitor m_singleton = null;

    protected MemoryMonitor() {
        try {
            this.m_runtime = Runtime.getRuntime();
            this.m_memoryMXBean = ManagementFactory.getMemoryMXBean();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static MemoryMonitor singleton() {
        try {
            if (m_singleton == null) {
                m_singleton = new MemoryMonitor();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public long used_bean() {
        try {
            return this.m_memoryMXBean.getHeapMemoryUsage().getUsed();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public long used_runtime() {
        try {
            long totalMemory = this.m_runtime.totalMemory();
            long freeMemory = this.m_runtime.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            return usedMemory;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public void print_bean(String caller) {
        try {
            MemoryUsage heapUsage = this.m_memoryMXBean.getHeapMemoryUsage();
            System.out.println(caller + ", Heap Memory:");
            System.out.println(caller + ",   Init: " + heapUsage.getInit() / 0x100000L + " MB");
            System.out.println(caller + ",   Used: " + heapUsage.getUsed() / 0x100000L + " MB");
            System.out.println(caller + ",   Committed: " + heapUsage.getCommitted() / 0x100000L + " MB");
            System.out.println(caller + ",   Max: " + heapUsage.getMax() / 0x100000L + " MB");
            MemoryUsage nonHeapUsage = this.m_memoryMXBean.getNonHeapMemoryUsage();
            System.out.println(caller + ", \nNon-Heap Memory:");
            System.out.println(caller + ",   Init: " + nonHeapUsage.getInit() / 0x100000L + " MB");
            System.out.println(caller + ",   Used: " + nonHeapUsage.getUsed() / 0x100000L + " MB");
            System.out.println(caller + ",   Committed: " + nonHeapUsage.getCommitted() / 0x100000L + " MB");
            System.out.println(caller + ",   Max: " + (String)(nonHeapUsage.getMax() == -1L ? "Unlimited" : nonHeapUsage.getMax() / 0x100000L + " MB"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void print_runtime(String caller) {
        try {
            long maxMemory = this.m_runtime.maxMemory();
            long totalMemory = this.m_runtime.totalMemory();
            long freeMemory = this.m_runtime.freeMemory();
            long usedMemory = totalMemory - freeMemory;
            System.out.println(caller + ", MemoryMonitor, runtime version ");
            System.out.println(caller + ", Max Memory: " + maxMemory / 0x100000L + " MB");
            System.out.println(caller + ", Total Memory: " + totalMemory / 0x100000L + " MB");
            System.out.println(caller + ", Free Memory: " + freeMemory / 0x100000L + " MB");
            System.out.println(caller + ", Used Memory: " + usedMemory / 0x100000L + " MB");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

