/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Shared;

import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class BinaryFileChunkScanner {
    protected String m_fileName = "";
    protected long m_fileLength;
    protected int m_bytesPerRow = 1;
    protected int m_rowCount;
    protected int m_rowsPerChunk = 50000;
    protected int m_bytesPerChunk;
    protected ByteBuffer m_buffer;
    protected RandomAccessFile m_reader;
    public int m_firstRowNextChunk = 0;
    public int m_numRowsInChunk = 0;

    public BinaryFileChunkScanner(String fileName, int bytesPerRow) throws Exception {
        try {
            this.m_fileName = fileName;
            this.m_reader = new RandomAccessFile(fileName, "r");
            this.m_fileLength = this.m_reader.length();
            this.m_bytesPerRow = bytesPerRow;
            this.m_rowCount = (int)(this.m_fileLength / (long)this.m_bytesPerRow);
            this.m_bytesPerChunk = this.m_bytesPerRow * this.m_rowsPerChunk;
            this.m_buffer = ByteBuffer.allocate(this.m_bytesPerChunk);
            this.reset();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public ByteBuffer buffer() {
        return this.m_buffer;
    }

    public int numberOfRowsInChunk() {
        return this.m_numRowsInChunk;
    }

    public boolean hasMoreData() throws Exception {
        try {
            if (this.m_firstRowNextChunk >= this.m_rowCount) {
                return false;
            }
            int maxRowsInChunk = this.m_rowCount - this.m_firstRowNextChunk;
            this.m_numRowsInChunk = this.m_rowsPerChunk;
            this.m_numRowsInChunk = Math.min(this.m_numRowsInChunk, maxRowsInChunk);
            int numBytesToRead = this.m_numRowsInChunk * this.m_bytesPerRow;
            this.m_reader.read(this.m_buffer.array(), 0, numBytesToRead);
            this.m_firstRowNextChunk += this.m_numRowsInChunk;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void reset() throws Exception {
        try {
            this.m_reader.seek(0L);
            this.m_firstRowNextChunk = 0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void close() throws Exception {
        try {
            this.m_reader.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

