/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic.Segy;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Seismic.CubicTraceInterpolator;
import com.PecosCore.Data.Seismic.ITraceInterpolator;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.Segy.Segy_Dictionary;
import com.PecosCore.Seismic.Segy.Segy_FileHeader;
import com.PecosCore.Tools.Tools_ByteArray;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;

public class Segy_Exporter {
    protected boolean m_valid = false;
    protected ITraceInterpolator m_interpolator = new CubicTraceInterpolator();
    public String FileName;
    public int OutputSampleCount;
    public float OutputDigi;
    public float OutputDigiScalar = 1000.0f;
    public boolean ExcludeKilledShots = false;
    public boolean ExcludeKilledReceivers = false;
    public boolean ExcludeKilledTraces = false;
    public boolean ExportPolarity = false;
    public int PolarityOffset = 35;
    public boolean TwoByteInt = false;
    public Segy_Dictionary Dictionary;
    protected ByteOrder m_byteOrder = ByteOrder.BIG_ENDIAN;
    protected boolean m_isFeet = true;
    protected boolean m_createStack = false;
    protected ByteBuffer m_traceHeaderBuffer = ByteBuffer.allocate(240);
    protected float[] m_inputTraceData = new float[100];
    protected float[] m_outputTraceData;
    protected byte[] m_outputTraceBytes;
    protected int m_counter = 1;
    protected int m_numTracesKilled = 0;
    protected int m_numShotsKilled = 0;
    protected int m_numRecKilled = 0;
    public ArrayList<String> ExtraList = new ArrayList();

    public void appendEnsemble(Ensemble ensemble) {
        try {
            this.appendEnsemble(ensemble, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void appendEnsemble(Ensemble ensemble, boolean interpolateOutputData) {
        try {
            if (!this.m_valid) {
                return;
            }
            RandomAccessFile raf = new RandomAccessFile(this.FileName, "rw");
            raf.seek(raf.length());
            this.m_traceHeaderBuffer.order(this.m_byteOrder);
            if (this.OutputSampleCount > 0 && this.m_outputTraceData == null) {
                this.m_outputTraceData = new float[this.OutputSampleCount];
                this.m_outputTraceBytes = this.TwoByteInt ? new byte[2 * this.OutputSampleCount] : new byte[4 * this.OutputSampleCount];
            }
            this.Dictionary.prepareEnsembleHeaderDictionary(ensemble.dictionary());
            int indexTracePolarity = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Polarity")) {
                indexTracePolarity = ensemble.dictionary().getEntryIndex("Trace", "Polarity");
            }
            int indexRecPolarity = -9999;
            if (ensemble.dictionary().containsEntry("Receiver", "Polarity")) {
                indexRecPolarity = ensemble.dictionary().getEntryIndex("Receiver", "Polarity");
            }
            int indexShotPolarity = -9999;
            if (ensemble.dictionary().containsEntry("Shot", "Polarity")) {
                indexShotPolarity = ensemble.dictionary().getEntryIndex("Shot", "Polarity");
            }
            int indexTraceKilled = -9999;
            if (ensemble.dictionary().containsEntry("Trace", "Killed")) {
                indexTraceKilled = ensemble.dictionary().getEntryIndex("Trace", "Killed");
            }
            int indexRecKilled = -9999;
            if (ensemble.dictionary().containsEntry("Receiver", "Killed")) {
                indexRecKilled = ensemble.dictionary().getEntryIndex("Receiver", "Killed");
            }
            int indexShotKilled = -9999;
            if (ensemble.dictionary().containsEntry("Shot", "Killed")) {
                indexShotKilled = ensemble.dictionary().getEntryIndex("Shot", "Killed");
            }
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, this.m_outputTraceBytes.length);
            buffer.order(this.m_byteOrder);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                short v;
                int s;
                int s2;
                boolean killed;
                boolean exclude;
                EnsembleTrace trace = ensemble.trace(n);
                boolean traceKilled = false;
                boolean recKilled = false;
                boolean shotKilled = false;
                if (indexTraceKilled >= 0) {
                    traceKilled = trace.header().getBool(indexTraceKilled);
                }
                if (indexRecKilled >= 0) {
                    recKilled = trace.header().getBool(indexRecKilled);
                }
                if (indexShotKilled >= 0) {
                    shotKilled = trace.header().getBool(indexShotKilled);
                }
                boolean excludeBecauseShotKilled = shotKilled && this.ExcludeKilledShots;
                boolean excludeBecauseRecKilled = recKilled && this.ExcludeKilledReceivers;
                boolean excludeBecauseTraceKilled = traceKilled && this.ExcludeKilledTraces;
                boolean bl = exclude = trace.Removed || excludeBecauseShotKilled || excludeBecauseRecKilled || excludeBecauseTraceKilled;
                if (traceKilled) {
                    ++this.m_numTracesKilled;
                }
                if (shotKilled) {
                    ++this.m_numShotsKilled;
                }
                if (recKilled) {
                    ++this.m_numRecKilled;
                }
                boolean bl2 = killed = traceKilled || recKilled || shotKilled;
                if (exclude) continue;
                this.Dictionary.copyHeaderToBuffer(trace.header(), this.m_traceHeaderBuffer);
                if (killed) {
                    this.m_traceHeaderBuffer.putShort(28, (short)2);
                } else {
                    this.m_traceHeaderBuffer.putShort(28, (short)1);
                }
                this.m_traceHeaderBuffer.putInt(24, n + 1);
                this.m_traceHeaderBuffer.putInt(0, this.m_counter);
                this.m_traceHeaderBuffer.putInt(4, this.m_counter);
                this.m_traceHeaderBuffer.putShort(68, (short)1);
                this.m_traceHeaderBuffer.putShort(70, (short)1);
                if (this.ExportPolarity) {
                    int polarity;
                    boolean polarityFlipped = false;
                    if (indexTracePolarity >= 0) {
                        polarity = trace.header().getInt(indexTracePolarity);
                        boolean bl3 = polarityFlipped = polarityFlipped || polarity < 0;
                    }
                    if (indexShotPolarity >= 0) {
                        polarity = trace.header().getInt(indexShotPolarity);
                        boolean bl4 = polarityFlipped = polarityFlipped || polarity < 0;
                    }
                    if (indexRecPolarity >= 0) {
                        polarity = trace.header().getInt(indexRecPolarity);
                        boolean bl5 = polarityFlipped = polarityFlipped || polarity < 0;
                    }
                    if (polarityFlipped) {
                        this.m_traceHeaderBuffer.putShort(this.PolarityOffset - 1, (short)-1);
                    } else {
                        this.m_traceHeaderBuffer.putShort(this.PolarityOffset - 1, (short)1);
                    }
                }
                ++this.m_counter;
                raf.write(this.m_traceHeaderBuffer.array(), 0, 240);
                if (this.OutputSampleCount <= 0) continue;
                for (int b = 0; b < this.m_outputTraceBytes.length; ++b) {
                    this.m_outputTraceBytes[b] = 0;
                }
                if (this.m_inputTraceData.length < trace.data().length()) {
                    this.m_inputTraceData = new float[trace.data().length()];
                }
                trace.data().copyToArray(this.m_inputTraceData);
                if (interpolateOutputData) {
                    this.m_interpolator.prepareInput(this.m_inputTraceData, trace.data().getFirstSampleCoord_WithShifts(), trace.data().getSampleInterval());
                    this.m_interpolator.interpolate(this.m_outputTraceData, 0.0f, this.OutputDigi);
                    if (this.TwoByteInt) {
                        float max = 1.0E-10f;
                        for (s2 = 0; s2 < this.OutputSampleCount; ++s2) {
                            max = Math.max(max, Math.abs(this.m_outputTraceData[s2]));
                        }
                        float scalar = 30000.0f / max;
                        for (s = 0; s < this.OutputSampleCount; ++s) {
                            v = (short)(scalar * this.m_outputTraceData[s]);
                            buffer.putShort(2 * s, v);
                        }
                        raf.write(buffer.array(), 0, 2 * this.OutputSampleCount);
                        continue;
                    }
                    Tools_ByteArray.convertFloatToIBM(this.m_outputTraceBytes, this.m_outputTraceData, this.OutputSampleCount);
                    raf.write(this.m_outputTraceBytes);
                    continue;
                }
                if (this.TwoByteInt) {
                    float max = 1.0E-10f;
                    for (s2 = 0; s2 < this.OutputSampleCount; ++s2) {
                        max = Math.max(max, Math.abs(this.m_inputTraceData[s2]));
                    }
                    float scalar = 30000.0f / max;
                    for (s = 0; s < this.OutputSampleCount; ++s) {
                        v = (short)(scalar * this.m_inputTraceData[s]);
                        buffer.putShort(2 * s, v);
                    }
                    raf.write(buffer.array(), 0, 2 * this.OutputSampleCount);
                    continue;
                }
                Tools_ByteArray.convertFloatToIBM(this.m_outputTraceBytes, this.m_inputTraceData, this.OutputSampleCount);
                raf.write(this.m_outputTraceBytes);
            }
            raf.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean valid() {
        return this.m_valid;
    }

    public void prepareFile() {
        try {
            int n;
            this.m_valid = false;
            Tools_FileSystem.deleteFile(this.FileName);
            RandomAccessFile raf = new RandomAccessFile(this.FileName, "rw");
            byte[] asciiByteArray = new byte[3200];
            for (int n2 = 0; n2 < asciiByteArray.length; ++n2) {
                asciiByteArray[n2] = 32;
            }
            int rows = 0;
            String label = "Created by Flatirons Refraction Statics Software - XtremeGeo LLC";
            for (int b = 0; b < label.getBytes().length; ++b) {
                asciiByteArray[rows * 80 + b] = label.getBytes()[b];
            }
            ++rows;
            for (n = 0; n < this.ExtraList.size(); ++n) {
                String s = this.ExtraList.get(n);
                for (int b = 0; b < s.getBytes().length; ++b) {
                    asciiByteArray[rows * 80 + b] = s.getBytes()[b];
                }
                ++rows;
            }
            for (n = 0; n < this.Dictionary.entryCount(); ++n) {
                Segy_Dictionary.Entry entry = this.Dictionary.getEntry(n);
                int row = rows + n / 2;
                int offset = row * 80;
                if (n % 2 == 1) {
                    offset += 40;
                }
                entry.populateByteArray(asciiByteArray, offset);
            }
            String ebcdic = new String(asciiByteArray);
            byte[] ebcdicByteArray = ebcdic.getBytes("Cp1047");
            raf.write(ebcdicByteArray, 0, ebcdicByteArray.length);
            this.OutputSampleCount = Math.max(this.OutputSampleCount, 1);
            this.OutputSampleCount = Math.min(this.OutputSampleCount, 5000);
            this.OutputDigi = Math.max(this.OutputDigi, 0.25f);
            this.OutputDigi = Math.min(this.OutputDigi, 50.0f);
            ByteBuffer buffer = ByteBuffer.allocate(400);
            buffer.order(this.m_byteOrder);
            buffer.putInt(Segy_FileHeader.Entry.JobID.ByteOffset, 1000);
            buffer.putInt(Segy_FileHeader.Entry.LineNumber.ByteOffset, 1000);
            buffer.putInt(Segy_FileHeader.Entry.ReelNumber.ByteOffset, 1000);
            buffer.putShort(Segy_FileHeader.Entry.EnsembleTraceCount.ByteOffset, (short)0);
            buffer.putShort(Segy_FileHeader.Entry.TracesPerEnsembleExpected.ByteOffset, (short)0);
            buffer.putShort(Segy_FileHeader.Entry.EnsembleTraceCountAuxiliary.ByteOffset, (short)0);
            buffer.putShort(Segy_FileHeader.Entry.SampleIntervalMicro.ByteOffset, (short)(0.5f + this.OutputDigiScalar * this.OutputDigi));
            buffer.putShort(Segy_FileHeader.Entry.SampleIntervalMicroOriginal.ByteOffset, (short)(0.5f + this.OutputDigiScalar * this.OutputDigi));
            buffer.putShort(Segy_FileHeader.Entry.SamplesPerTrace.ByteOffset, (short)this.OutputSampleCount);
            buffer.putShort(Segy_FileHeader.Entry.SamplesPerTraceOriginal.ByteOffset, (short)this.OutputSampleCount);
            if (this.TwoByteInt) {
                buffer.putShort(Segy_FileHeader.Entry.FormatCode.ByteOffset, (short)3);
            } else {
                buffer.putShort(Segy_FileHeader.Entry.FormatCode.ByteOffset, (short)1);
            }
            short unitsShort = this.m_isFeet ? (short)2 : 1;
            buffer.putShort(Segy_FileHeader.Entry.Units.ByteOffset, unitsShort);
            raf.write(buffer.array(), 0, 400);
            raf.close();
            this.m_valid = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setUnits(boolean feet) {
        this.m_isFeet = feet;
    }
}

