/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic.Segy;

import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Seismic.Segy.Segy;
import com.PecosCore.Shared.ExceptionMonitor;

public class SegyReadSegment {
    protected boolean m_reset = true;
    protected Segy m_segy = null;
    protected int m_currentStartIndex = -9999;
    protected int m_currentFinalIndex = -9999;
    protected int m_headerOffset1 = -9999;
    protected int m_headerOffset2 = -9999;
    protected DataType m_headerType1 = DataType.Int;
    protected DataType m_headerType2 = DataType.Int;

    public Ensemble nextEnsemble() throws Exception {
        try {
            if (!this.hasMoreEnsembles()) {
                throw new Exception("hasMoreEnsembles() == false");
            }
            return null;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean hasMoreEnsembles() {
        try {
            if (this.m_segy == null) {
                return false;
            }
            if (!this.m_segy.isFileOK()) {
                return false;
            }
            if (this.m_segy.traceCount() < 1L) {
                return false;
            }
            if (this.m_headerOffset1 < 0) {
                return false;
            }
            if (this.m_reset) {
                return true;
            }
            return (long)this.m_currentFinalIndex < this.m_segy.traceCount() - 1L;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public void reset() {
        this.m_reset = true;
        this.m_currentStartIndex = -9999;
        this.m_currentFinalIndex = -9999;
    }

    public void setHeader(int headerOffset1, DataType headerType1) {
        try {
            this.m_headerOffset1 = headerOffset1;
            this.m_headerType1 = headerType1;
            this.m_headerOffset2 = -9999;
            this.reset();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void setSegy(Segy segy) {
        try {
            this.m_segy = segy;
            this.reset();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public Segy segy() {
        return this.m_segy;
    }
}

