/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic;

import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Seismic.ISeismicFile;
import com.PecosCore.Seismic.ImportLimit;
import com.PecosCore.Seismic.SeismicFileType;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class CompressedSeismicFile
implements ISeismicFile {
    public static final String Suffix = "_wcf";
    protected String m_fileName;
    protected String m_reasonObjectNotValid = "";
    protected boolean m_fileOK = false;
    protected long m_traceCount = 0L;
    protected int m_samplesPerTrace = 0;
    protected float m_sampleInterval = 4.0f;
    protected long m_fileByteCount = 0L;
    protected int m_samplesPerWindow;
    protected int m_windowsPerTrace;
    protected int m_bytesPerTrace;
    protected int m_bytesPerWindow;
    protected ByteBuffer m_headerBuffer = ByteBuffer.allocate(100);
    protected ByteBuffer m_dataBuffer;
    protected float[] m_dataArray;
    protected RandomAccessFile m_pecosRAF = null;
    protected GenericObjectListener m_listenerManager = new GenericObjectListener();
    public ArrayList<ImportLimit> ImportLimitList = new ArrayList();

    @Override
    public boolean isFileOK() {
        return this.m_fileOK;
    }

    @Override
    public SeismicFileType getFileType() {
        return SeismicFileType.Compressed;
    }

    @Override
    public void openPecosRAF() {
        try {
            if (this.m_pecosRAF != null) {
                try {
                    this.m_pecosRAF.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.m_pecosRAF = null;
            }
            this.m_pecosRAF = new RandomAccessFile(this.m_fileName, "r");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void closePecosRAF() {
        block4: {
            try {
                if (this.m_pecosRAF == null) break block4;
                try {
                    this.m_pecosRAF.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.m_pecosRAF = null;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }

    @Override
    public GenericObjectListener getListenerController() {
        return this.m_listenerManager;
    }

    public void setFileName(String fileName) {
        try {
            this.m_fileOK = false;
            this.m_fileName = null;
            this.m_traceCount = 0L;
            this.m_samplesPerTrace = 0;
            this.m_reasonObjectNotValid = "";
            if (!Tools_FileSystem.exists_file(fileName)) {
                this.m_fileName = null;
                this.m_reasonObjectNotValid = "File name not valid";
                return;
            }
            this.m_fileName = fileName;
            RandomAccessFile reader = new RandomAccessFile(this.m_fileName, "r");
            if (reader.length() < 100L) {
                this.m_reasonObjectNotValid = "Not a valid compressed file";
                this.m_fileName = null;
                reader.close();
                return;
            }
            this.m_fileByteCount = reader.length();
            if (reader.read(this.m_headerBuffer.array(), 0, 100) != 100) {
                this.m_reasonObjectNotValid = "header read fail";
                this.m_fileName = null;
                reader.close();
                return;
            }
            reader.close();
            int magic = this.m_headerBuffer.getInt(0);
            if (magic != 420024) {
                this.m_reasonObjectNotValid = "magic not valid";
                this.m_fileName = null;
                return;
            }
            int version = this.m_headerBuffer.getInt(4);
            if (version != 1000) {
                this.m_reasonObjectNotValid = "unrecognized version";
                this.m_fileName = null;
                return;
            }
            this.m_sampleInterval = this.m_headerBuffer.getFloat(8);
            this.m_samplesPerWindow = this.m_headerBuffer.getInt(12);
            this.m_windowsPerTrace = this.m_headerBuffer.getInt(16);
            this.m_samplesPerTrace = this.m_samplesPerWindow * this.m_windowsPerTrace;
            this.m_bytesPerWindow = 4 + this.m_samplesPerWindow;
            this.m_bytesPerTrace = 4 + this.m_bytesPerWindow * this.m_windowsPerTrace;
            this.m_dataBuffer = ByteBuffer.allocate(this.m_bytesPerTrace);
            this.m_dataArray = new float[this.m_samplesPerTrace];
            this.m_traceCount = (this.m_fileByteCount - 100L) / (long)this.m_bytesPerTrace;
            System.out.println("CSF setFileName m_traceCount = " + this.m_traceCount);
            this.m_fileOK = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.m_fileOK = false;
        }
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, long[] indices, int indexCount, boolean bGetHeaders, boolean bGetData) throws Exception {
        throw new Exception("not implemented");
    }

    @Override
    public void populateEnsembleWithData(Ensemble ensemble, int fileID) throws Exception {
        this.populateEnsembleWithData(ensemble, fileID, true, true);
    }

    @Override
    public void populateEnsembleWithData(Ensemble ensemble, int fileID, boolean bReadHeaders, boolean bReadSamples) throws Exception {
        try {
            if (!this.isFileOK()) {
                throw new Exception("!this.isFileOK()");
            }
            if (!ensemble.dictionary().containsEntry("Trace", "FileID")) {
                throw new Exception("(Trace,FileID) not valid");
            }
            if (!ensemble.dictionary().containsEntry("Trace", "IndexInFile")) {
                throw new Exception("(Trace,IndexInFile) not valid");
            }
            int headerIndexFileID = ensemble.dictionary().getEntryIndex("Trace", "FileID");
            int headerIndexIndex = ensemble.dictionary().getEntryIndex("Trace", "IndexInFile");
            int headerIndexShotTimeShift = -9999;
            if (ensemble.dictionary().containsEntry("Shot", "TimeShift")) {
                headerIndexShotTimeShift = ensemble.dictionary().getEntryIndex("Shot", "TimeShift");
            }
            int headerIndexRecTimeShift = -9999;
            if (ensemble.dictionary().containsEntry("Receiver", "TimeShift")) {
                headerIndexRecTimeShift = ensemble.dictionary().getEntryIndex("Receiver", "TimeShift");
            }
            int count = 0;
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int fid = ensemble.trace(n).header().getInt(headerIndexFileID);
                if (fid != fileID) continue;
                ++count;
            }
            if (count < 1) {
                return;
            }
            RandomAccessFile reader = null;
            boolean closeStream = true;
            if (this.m_pecosRAF != null) {
                reader = this.m_pecosRAF;
                closeStream = false;
            }
            if (reader == null) {
                reader = new RandomAccessFile(this.m_fileName, "r");
                closeStream = true;
            }
            int crap = 0;
            float maxBad = 1.0E33f;
            for (int k = 0; k < ensemble.traceCount(); ++k) {
                EnsembleTrace trace;
                int fid;
                if (k == 85) {
                    ++crap;
                }
                if ((fid = (trace = ensemble.trace(k)).header().getInt(headerIndexFileID)) != fileID) continue;
                long traceNumber = trace.header().getLong(headerIndexIndex);
                long offset = 100L + traceNumber * (long)this.m_bytesPerTrace;
                reader.seek(offset);
                if (reader.getFilePointer() != offset) {
                    reader.close();
                    throw new Exception("Filed to seek to offset");
                }
                if (reader.read(this.m_dataBuffer.array(), 0, this.m_bytesPerTrace) != this.m_bytesPerTrace) {
                    reader.close();
                    throw new Exception("reader.read(this.m_bytesPerTrace) != length");
                }
                float time0 = this.m_dataBuffer.getFloat(0);
                int index = 4;
                int sampleIndex = 0;
                byte[] buffer = this.m_dataBuffer.array();
                for (int w = 0; w < this.m_windowsPerTrace; ++w) {
                    float scalar = this.m_dataBuffer.getFloat(index);
                    scalar = Math.max(125.0f / scalar, 1.0E-20f);
                    index += 4;
                    for (int s = 0; s < this.m_samplesPerWindow; ++s) {
                        float f;
                        boolean bad = Float.isInfinite(f = scalar * (float)buffer[index++]) || Float.isNaN(f);
                        bad = bad || Math.abs(f) > maxBad;
                        this.m_dataArray[sampleIndex++] = !bad ? f : 0.0f;
                    }
                }
                float traceTime0 = time0;
                if (headerIndexShotTimeShift >= 0) {
                    traceTime0 += trace.header().getFloat(headerIndexShotTimeShift);
                }
                if (headerIndexRecTimeShift >= 0) {
                    traceTime0 += trace.header().getFloat(headerIndexRecTimeShift);
                }
                trace.data().insertArray(this.m_dataArray, this.m_dataArray.length);
                trace.data().setFirstSampleCoord(traceTime0);
                trace.data().setSampleInterval(this.m_sampleInterval);
            }
            if (closeStream) {
                reader.close();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public long traceCount() {
        return this.m_traceCount;
    }

    @Override
    public int samplesPerTrace() {
        return this.m_samplesPerTrace;
    }

    @Override
    public float sampleInterval() {
        return this.m_sampleInterval;
    }

    @Override
    public String getName() {
        File file = new File(this.m_fileName);
        return file.getName();
    }

    @Override
    public String getDirectory() {
        File file = new File(this.m_fileName);
        return file.getParent();
    }

    @Override
    public void setDictionary(Object dictionary) {
    }

    @Override
    public void addImportLimit(ImportLimit il) {
        this.ImportLimitList.add(il);
    }

    @Override
    public void clearImportLimitList() {
        this.ImportLimitList.clear();
    }
}

