/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Seismic.Compressed;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class SeismicDataFile {
    public static final int CompressionType_None = 1000;
    public static final int CompressionType_Short = 2000;
    protected int m_compressionType = 2000;
    public static final int HeaderType_Int = 1000;
    public static final int HeaderType_Short = 1001;
    public static final int HeaderType_Float = 1002;
    public static final int HeaderType_Double = 1003;
    public static final int HeaderType_Long = 1004;
    protected ArrayList<TraceHeader> m_headerList = new ArrayList();
    protected String m_fileName = "";
    protected int m_fileHeaderByteCount = 15000;
    protected int m_bytesPerTrace;
    protected int m_traceHeaderBytes;
    protected int m_traceDataHeaderBytes = 20;
    protected int m_bytesPerSample;
    protected int m_samplesPerTrace;
    protected ByteBuffer m_traceBuffer;
    protected long m_traceCount = 0L;
    protected int m_offsetHeaderIndex = -999;
    protected ByteBuffer m_tempBuffer = null;
    protected Column_Abstract m_tempTraceHeader = null;
    protected int m_tempOffset = 0;
    protected FloatArrayWrapper m_tempFloatArrayWrapper;
    protected float[] m_dataArray = new float[100];

    protected void saveTraceHeaderEntryList(RandomAccessFile raf) throws Exception {
        try {
            long offset = 1000L;
            raf.seek(offset);
            int num = this.m_headerList.size();
            raf.writeInt(num);
            int version = 1000;
            raf.writeInt(version);
            long maxOffset = this.m_fileHeaderByteCount - 100;
            for (int n = 0; n < num; ++n) {
                this.m_headerList.get(n).save(raf, version);
                long pos = raf.getFilePointer();
                if (pos <= maxOffset) continue;
                throw new Exception("Too many header descriptions");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readTraceHeaderEntryList(RandomAccessFile raf) throws Exception {
        try {
            this.m_headerList.clear();
            long offset = 1000L;
            raf.seek(offset);
            int num = raf.readInt();
            int version = raf.readInt();
            for (int n = 0; n < num; ++n) {
                this.m_headerList.add(new TraceHeader(raf, version));
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public long traceCount() {
        return this.m_traceCount;
    }

    public SeismicDataFile(String fileName, int compressionType, int samplesPerTrace, int traceHeaderBytes) throws Exception {
        try {
            this.m_fileName = fileName;
            if (Tools_FileSystem.exists_file(this.m_fileName)) {
                throw new Exception("File already exists");
            }
            this.m_compressionType = compressionType;
            this.m_bytesPerSample = -9999;
            if (this.m_compressionType == 1000) {
                this.m_bytesPerSample = 4;
            }
            if (this.m_compressionType == 2000) {
                this.m_bytesPerSample = 2;
            }
            if (this.m_bytesPerSample < 1) {
                throw new Exception("Unrecognized compression type");
            }
            this.m_samplesPerTrace = Math.max(samplesPerTrace, 0);
            this.m_traceHeaderBytes = Math.max(traceHeaderBytes, 100);
            this.m_bytesPerTrace = this.m_traceHeaderBytes + this.m_traceDataHeaderBytes + this.m_bytesPerSample * this.m_samplesPerTrace;
            this.m_traceBuffer = ByteBuffer.allocate(this.m_bytesPerTrace);
            this.saveFileHeader();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public SeismicDataFile(String fileName) throws Exception {
        try {
            this.m_fileName = fileName;
            if (!Tools_FileSystem.exists_file(this.m_fileName)) {
                throw new Exception("File does not exist");
            }
            ByteBuffer buffer = ByteBuffer.allocate(this.m_fileHeaderByteCount);
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            raf.read(buffer.array(), 0, this.m_fileHeaderByteCount);
            int magic = buffer.getInt(0);
            if (magic != 234234) {
                throw new Exception("magic != 234234");
            }
            int version = buffer.getInt(4);
            if (version == 1000) {
                this.m_compressionType = buffer.getInt(8);
                this.m_bytesPerSample = buffer.getInt(12);
                this.m_samplesPerTrace = buffer.getInt(16);
                this.m_traceHeaderBytes = buffer.getInt(20);
                this.m_traceDataHeaderBytes = buffer.getInt(24);
                this.m_bytesPerTrace = buffer.getInt(28);
            }
            this.m_traceBuffer = ByteBuffer.allocate(this.m_bytesPerTrace);
            this.readTraceHeaderEntryList(raf);
            long totalBytesForTraces = raf.length() - (long)this.m_fileHeaderByteCount;
            this.m_traceCount = totalBytesForTraces / (long)this.m_bytesPerTrace;
            System.out.println("SeismicDataFile m_traceCount = " + Long.toString(this.m_traceCount));
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void saveFileHeader() throws Exception {
        try {
            ByteBuffer buffer = ByteBuffer.allocate(this.m_fileHeaderByteCount);
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            int magic = 234234;
            int version = 1000;
            buffer.putInt(0, magic);
            buffer.putInt(4, version);
            if (version == 1000) {
                buffer.putInt(8, this.m_compressionType);
                buffer.putInt(12, this.m_bytesPerSample);
                buffer.putInt(16, this.m_samplesPerTrace);
                buffer.putInt(20, this.m_traceHeaderBytes);
                buffer.putInt(24, this.m_traceDataHeaderBytes);
                buffer.putInt(28, this.m_bytesPerTrace);
            }
            raf.write(buffer.array(), 0, this.m_fileHeaderByteCount);
            this.saveTraceHeaderEntryList(raf);
            raf.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public boolean hasTraceHeaderEntry(String table, String column) throws Exception {
        try {
            for (TraceHeader header : this.m_headerList) {
                if (!table.equalsIgnoreCase(header.Table) || !column.equalsIgnoreCase(header.Column)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addTraceHeaderEntries(String table, Ensemble ensemble) throws Exception {
        try {
            ArrayList<String> columnNames = ensemble.dictionary().getListOfColumnNames(table);
            for (String col : columnNames) {
                if (this.hasTraceHeaderEntry(table, col)) continue;
                DataType dt = ensemble.dictionary().getPreferredType(table, col);
                if (dt == DataType.Int) {
                    this.addTraceHeaderEntry(table, col, 1000);
                }
                if (dt == DataType.Short || dt == DataType.Bool) {
                    this.addTraceHeaderEntry(table, col, 1001);
                }
                if (dt == DataType.Float) {
                    this.addTraceHeaderEntry(table, col, 1002);
                }
                if (dt == DataType.Double) {
                    this.addTraceHeaderEntry(table, col, 1003);
                }
                if (dt != DataType.Long) continue;
                this.addTraceHeaderEntry(table, col, 1004);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void addTraceHeaderEntry(String table, String column, int type) throws Exception {
        try {
            boolean typeOkay;
            if (this.hasTraceHeaderEntry(table, column)) {
                throw new Exception("Header already exists");
            }
            int offset = 0;
            int num = this.m_headerList.size();
            if (num > 0) {
                TraceHeader h = this.m_headerList.get(num - 1);
                if (h.Type == 1001) {
                    offset = h.Offset + 2;
                }
                if (h.Type == 1000) {
                    offset = h.Offset + 4;
                }
                if (h.Type == 1002) {
                    offset = h.Offset + 4;
                }
                if (h.Type == 1003) {
                    offset = h.Offset + 8;
                }
                if (h.Type == 1004) {
                    offset = h.Offset + 8;
                }
            }
            if (offset + 8 > this.m_traceHeaderBytes) {
                throw new Exception("Trace headers full....");
            }
            boolean bl = typeOkay = type == 1001 || type == 1000 || type == 1002 || type == 1003 || type == 1004;
            if (!typeOkay) {
                throw new Exception("bad type");
            }
            this.m_headerList.add(new TraceHeader(table, column, type, offset));
            this.saveFileHeader();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void prepareEnsembleHeaderDictionary(EnsembleHeaderDictionary dict) throws Exception {
        try {
            this.m_offsetHeaderIndex = -999;
            for (TraceHeader header : this.m_headerList) {
                if (header.Type == 1001) {
                    header.EnsembleHeaderIndex = dict.addEntry(header.Table, header.Column, DataType.Short);
                }
                if (header.Type == 1000) {
                    header.EnsembleHeaderIndex = dict.addEntry(header.Table, header.Column, DataType.Int);
                }
                if (header.Type == 1002) {
                    header.EnsembleHeaderIndex = dict.addEntry(header.Table, header.Column, DataType.Float);
                }
                if (header.Type == 1003) {
                    header.EnsembleHeaderIndex = dict.addEntry(header.Table, header.Column, DataType.Double);
                }
                if (header.Type == 1004) {
                    header.EnsembleHeaderIndex = dict.addEntry(header.Table, header.Column, DataType.Long);
                }
                String s = String.format("%s  %s  %d  %d  %d", header.Table, header.Column, header.Type, header.EnsembleHeaderIndex, header.Offset);
                if (!header.Table.equalsIgnoreCase("Trace") || !header.Column.equalsIgnoreCase("Offset")) continue;
                this.m_offsetHeaderIndex = header.EnsembleHeaderIndex;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void populateTempTraceHeader() throws Exception {
        try {
            for (TraceHeader header : this.m_headerList) {
                int headerIndex = header.EnsembleHeaderIndex;
                int offset = this.m_tempOffset + header.Offset;
                if (header.Type == 1001) {
                    this.m_tempTraceHeader.putInt(headerIndex, this.m_tempBuffer.getShort(offset));
                }
                if (header.Type == 1000) {
                    this.m_tempTraceHeader.putInt(headerIndex, this.m_tempBuffer.getInt(offset));
                }
                if (header.Type == 1002) {
                    this.m_tempTraceHeader.putFloat(headerIndex, this.m_tempBuffer.getFloat(offset));
                }
                if (header.Type == 1003) {
                    this.m_tempTraceHeader.putDouble(headerIndex, this.m_tempBuffer.getDouble(offset));
                }
                if (header.Type == 1004) {
                    this.m_tempTraceHeader.putLong(headerIndex, this.m_tempBuffer.getLong(offset));
                }
                if (this.m_offsetHeaderIndex != headerIndex) continue;
                offset = -999;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void populateFloatArrayWrapper() throws Exception {
        try {
            int s;
            int tdoff = this.m_tempOffset + this.m_traceHeaderBytes;
            int doff = tdoff + this.m_traceDataHeaderBytes;
            if (this.m_samplesPerTrace < 1) {
                this.m_tempFloatArrayWrapper.clear();
                return;
            }
            if (this.m_samplesPerTrace != this.m_dataArray.length) {
                this.m_dataArray = new float[this.m_samplesPerTrace];
            }
            float t0 = this.m_tempBuffer.getFloat(tdoff + 0);
            float digi = this.m_tempBuffer.getFloat(tdoff + 4);
            float scalar = this.m_tempBuffer.getFloat(tdoff + 8);
            float max = this.m_tempBuffer.getFloat(tdoff + 12);
            if (scalar > 0.0f) {
                scalar = 1.0f / scalar;
            }
            if (this.m_compressionType == 2000) {
                for (s = 0; s < this.m_samplesPerTrace; ++s) {
                    this.m_dataArray[s] = scalar * (float)this.m_tempBuffer.getShort(doff);
                    doff += 2;
                }
            }
            if (this.m_compressionType == 1000) {
                for (s = 0; s < this.m_samplesPerTrace; ++s) {
                    this.m_dataArray[s] = this.m_tempBuffer.getFloat(doff);
                    doff += 4;
                }
            }
            this.m_tempFloatArrayWrapper.insertArray(this.m_dataArray, this.m_samplesPerTrace);
            this.m_tempFloatArrayWrapper.setFirstSampleCoord(t0);
            this.m_tempFloatArrayWrapper.setSampleInterval(digi);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void readEnsemble(Ensemble ensemble, int startIndex, int count) throws Exception {
        try {
            if (startIndex < 0 || startIndex >= (int)this.m_traceCount) {
                throw new Exception("((startIndex < 0) || (startIndex >= (int)m_traceCount))");
            }
            int lastIndex = startIndex + count - 1;
            if (lastIndex < startIndex || lastIndex >= (int)this.m_traceCount) {
                throw new Exception("((lastIndex < startIndex) || (lastIndex >= (int)m_traceCount))");
            }
            this.prepareEnsembleHeaderDictionary(ensemble.dictionary());
            int totalBytes = this.m_bytesPerTrace * count;
            this.m_tempBuffer = ByteBuffer_Shared.buffer(0, totalBytes);
            long startOffset = (long)this.m_fileHeaderByteCount + (long)this.m_bytesPerTrace * (long)startIndex;
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            raf.seek(startOffset);
            raf.read(this.m_tempBuffer.array(), 0, totalBytes);
            raf.close();
            for (int n = 0; n < count; ++n) {
                EnsembleTrace trace = ensemble.addTrace();
                this.m_tempFloatArrayWrapper = trace.data();
                this.m_tempTraceHeader = trace.header();
                this.m_tempOffset = n * this.m_bytesPerTrace;
                this.populateTempTraceHeader();
                this.populateFloatArrayWrapper();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void appendEnsemble(Ensemble ensemble) throws Exception {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            for (TraceHeader header : this.m_headerList) {
                if (dict.containsEntry(header.Table, header.Column)) {
                    header.EnsembleHeaderIndex = dict.getEntryIndex(header.Table, header.Column);
                    continue;
                }
                header.EnsembleHeaderIndex = -9999;
            }
            int totalBytes = this.m_bytesPerTrace * ensemble.traceCount();
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, totalBytes);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                int s;
                EnsembleTrace trace = ensemble.trace(n);
                int bufferOffset = n * this.m_bytesPerTrace;
                Column_Abstract traceHeader = trace.header();
                for (TraceHeader header : this.m_headerList) {
                    int headerIndex = header.EnsembleHeaderIndex;
                    int offset = bufferOffset + header.Offset;
                    if (headerIndex < 0) {
                        if (header.Type == 1001) {
                            buffer.putShort(offset, (short)-9999);
                        }
                        if (header.Type == 1000) {
                            buffer.putInt(offset, -9999);
                        }
                        if (header.Type == 1002) {
                            buffer.putFloat(offset, -9999.0f);
                        }
                        if (header.Type == 1003) {
                            buffer.putDouble(offset, -9999.0);
                        }
                        if (header.Type != 1004) continue;
                        buffer.putDouble(offset, -9999.0);
                        continue;
                    }
                    if (header.Type == 1001) {
                        buffer.putShort(offset, (short)traceHeader.getInt(headerIndex));
                    }
                    if (header.Type == 1000) {
                        buffer.putInt(offset, traceHeader.getInt(headerIndex));
                    }
                    if (header.Type == 1002) {
                        buffer.putFloat(offset, traceHeader.getFloat(headerIndex));
                    }
                    if (header.Type == 1003) {
                        buffer.putDouble(offset, traceHeader.getDouble(headerIndex));
                    }
                    if (header.Type != 1004) continue;
                    buffer.putLong(offset, traceHeader.getLong(headerIndex));
                }
                FloatArrayWrapper data = trace.data();
                int tdoff = bufferOffset + this.m_traceHeaderBytes;
                int doff = tdoff + this.m_traceDataHeaderBytes;
                if (data.length() < 1 || this.m_samplesPerTrace < 1) {
                    buffer.putFloat(tdoff + 0, 0.0f);
                    buffer.putFloat(tdoff + 4, 4.0f);
                    buffer.putFloat(tdoff + 8, 1.0f);
                    buffer.putFloat(tdoff + 12, 0.0f);
                    for (int s2 = 0; s2 < this.m_samplesPerTrace; ++s2) {
                        buffer.putFloat(doff, 0.0f);
                        doff += this.m_bytesPerSample;
                    }
                    continue;
                }
                if (this.m_dataArray.length != data.length()) {
                    this.m_dataArray = new float[data.length()];
                }
                data.copyToArray(this.m_dataArray);
                float max = 1.0E-9f;
                float t0 = data.getFirstSampleCoord_WithShifts();
                float digi = data.getSampleInterval();
                for (int s3 = 0; s3 < data.length(); ++s3) {
                    max = Math.max(max, Math.abs(this.m_dataArray[s3]));
                }
                float scalar = 32000.0f / max;
                buffer.putFloat(tdoff + 0, t0);
                buffer.putFloat(tdoff + 4, digi);
                buffer.putFloat(tdoff + 8, scalar);
                buffer.putFloat(tdoff + 12, max);
                if (this.m_compressionType == 2000) {
                    for (s = 0; s < data.length(); ++s) {
                        short v = (short)(this.m_dataArray[s] * scalar);
                        buffer.putShort(doff, v);
                        doff += this.m_bytesPerSample;
                    }
                    for (s = data.length(); s < this.m_samplesPerTrace; ++s) {
                        buffer.putShort(doff, (short)0);
                        doff += this.m_bytesPerSample;
                    }
                }
                if (this.m_compressionType != 1000) continue;
                for (s = 0; s < data.length(); ++s) {
                    buffer.putFloat(doff, this.m_dataArray[s]);
                    doff += this.m_bytesPerSample;
                }
                for (s = data.length(); s < this.m_samplesPerTrace; ++s) {
                    buffer.putFloat(doff, 0.0f);
                    doff += this.m_bytesPerSample;
                }
            }
            RandomAccessFile raf = new RandomAccessFile(this.m_fileName, "rw");
            long len = raf.length();
            raf.seek(len);
            raf.write(buffer.array(), 0, totalBytes);
            raf.close();
            this.m_traceCount += (long)ensemble.traceCount();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected class TraceHeader {
        public String Table = "";
        public String Column = "";
        public int Offset = 0;
        public int Type = 1000;
        public int EnsembleHeaderIndex = -9999;

        public TraceHeader(String table, String col, int t, int off) {
            this.Table = table;
            this.Column = col;
            this.Type = t;
            this.Offset = off;
        }

        public TraceHeader(RandomAccessFile raf, int version) throws Exception {
            try {
                if (version == 1000) {
                    this.Table = raf.readUTF();
                    this.Column = raf.readUTF();
                    this.Type = raf.readInt();
                    this.Offset = raf.readInt();
                    return;
                }
                throw new Exception("Unrecognized version");
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                throw error;
            }
        }

        public void save(RandomAccessFile raf, int version) throws Exception {
            try {
                if (version == 1000) {
                    raf.writeUTF(this.Table);
                    raf.writeUTF(this.Column);
                    raf.writeInt(this.Type);
                    raf.writeInt(this.Offset);
                    return;
                }
                throw new Exception("Unrecognized version");
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                throw error;
            }
        }
    }
}

