/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Math;

import com.PecosCore.Shared.ExceptionMonitor;

public class ComplexMatrix {
    protected int m_rowCount = 0;
    protected int m_columnCount = 0;
    protected double[][] m_real;
    protected double[][] m_imag;
    protected double[][] m_phase;
    protected double[][] m_amplitude;
    protected double m_maxAmplitude = 0.0;
    protected int m_maxAmplitudeRow = 0;
    protected int m_maxAmplitudeColumn = 0;
    protected double[] m_tempColReal;
    protected double[] m_tempColImag;
    protected double[] m_tempRowReal;
    protected double[] m_tempRowImag;

    public int rowCount() {
        return this.m_rowCount;
    }

    public int columnCount() {
        return this.m_columnCount;
    }

    public double[][] real() {
        return this.m_real;
    }

    public double[][] imag() {
        return this.m_imag;
    }

    public double[][] phase() {
        return this.m_phase;
    }

    public double[][] amplitude() {
        return this.m_amplitude;
    }

    public double maxAmplitude() {
        return this.m_maxAmplitude;
    }

    public int maxAmplitudeRow() {
        return this.m_maxAmplitudeRow;
    }

    public int maxAmplitudeColumn() {
        return this.m_maxAmplitudeColumn;
    }

    public double[] tempColReal() {
        return this.m_tempColReal;
    }

    public double[] tempColImag() {
        return this.m_tempColImag;
    }

    public double[] tempRowReal() {
        return this.m_tempRowReal;
    }

    public double[] tempRowImag() {
        return this.m_tempRowImag;
    }

    public ComplexMatrix(ComplexMatrix input) {
        try {
            this.copy(input);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ComplexMatrix() {
        try {
            this.allocate(3, 3);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public ComplexMatrix(int rowCount, int columnCount) {
        try {
            this.allocate(rowCount, columnCount);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeAmplitudeAndPhase() {
        try {
            this.m_maxAmplitudeRow = 0;
            this.m_maxAmplitudeColumn = 0;
            this.m_maxAmplitude = 0.0;
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    double ampsq = this.m_real[row][col] * this.m_real[row][col] + this.m_imag[row][col] * this.m_imag[row][col];
                    if (ampsq > 1.0E-30) {
                        this.m_amplitude[row][col] = Math.sqrt(ampsq);
                        this.m_phase[row][col] = Math.atan2(this.m_imag[row][col], this.m_real[row][col]);
                        if (!(this.m_amplitude[row][col] > this.m_maxAmplitude)) continue;
                        this.m_maxAmplitude = this.m_amplitude[row][col];
                        this.m_maxAmplitudeRow = row;
                        this.m_maxAmplitudeColumn = col;
                        continue;
                    }
                    this.m_amplitude[row][col] = 0.0;
                    this.m_phase[row][col] = 0.0;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void set(double r, double i) throws Exception {
        try {
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    this.m_real[row][col] = r;
                    this.m_imag[row][col] = i;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public double magnitude() throws Exception {
        try {
            double sum = 0.0;
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    sum = sum + this.m_real[row][col] * this.m_real[row][col] + this.m_imag[row][col] * this.m_imag[row][col];
                }
            }
            return sum;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void multiply(ComplexMatrix left, ComplexMatrix right) throws Exception {
        try {
            if (right.rowCount() != left.columnCount()) {
                throw new Exception("right.columnCount() != left.rowCount()");
            }
            int len = right.rowCount();
            this.allocate(left.rowCount(), right.columnCount());
            for (int row = 0; row < this.m_rowCount; ++row) {
                left.prepareTempRow(row);
                for (int col = 0; col < this.m_columnCount; ++col) {
                    right.prepareTempCol(col);
                    double[] rr = right.tempColReal();
                    double[] ri = right.tempColImag();
                    double[] lr = left.tempRowReal();
                    double[] li = left.tempRowImag();
                    double sumr = 0.0;
                    double sumi = 0.0;
                    for (int n = 0; n < len; ++n) {
                        sumr += rr[n] * lr[n] - ri[n] * li[n];
                        sumi += rr[n] * li[n] + lr[n] * ri[n];
                    }
                    this.m_real[row][col] = sumr;
                    this.m_imag[row][col] = sumi;
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add(ComplexMatrix input, double multiplier) throws Exception {
        try {
            if (input.columnCount() != this.columnCount()) {
                throw new Exception("input.columnCount() != columnCount()");
            }
            if (input.rowCount() != this.rowCount()) {
                throw new Exception("input.rowCount() != rowCount()");
            }
            double[][] inputr = input.real();
            double[][] inputi = input.imag();
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    this.m_real[row][col] = this.m_real[row][col] + multiplier * inputr[row][col];
                    this.m_imag[row][col] = this.m_imag[row][col] + multiplier * inputi[row][col];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void subtract(ComplexMatrix input, double multiplier) throws Exception {
        try {
            if (input.columnCount() != this.columnCount()) {
                throw new Exception("input.columnCount() != columnCount()");
            }
            if (input.rowCount() != this.rowCount()) {
                throw new Exception("input.rowCount() != rowCount()");
            }
            double[][] inputr = input.real();
            double[][] inputi = input.imag();
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    this.m_real[row][col] = this.m_real[row][col] - multiplier * inputr[row][col];
                    this.m_imag[row][col] = this.m_imag[row][col] - multiplier * inputi[row][col];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void copy(ComplexMatrix input) throws Exception {
        try {
            this.allocate(input.rowCount(), input.columnCount());
            double[][] inputr = input.real();
            double[][] inputi = input.imag();
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    this.m_real[row][col] = inputr[row][col];
                    this.m_imag[row][col] = inputi[row][col];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void transpose(ComplexMatrix input) throws Exception {
        try {
            this.allocate(input.columnCount(), input.rowCount());
            double[][] inputr = input.real();
            double[][] inputi = input.imag();
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    this.m_real[row][col] = inputr[col][row];
                    this.m_imag[row][col] = inputi[col][row];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void conjugateTranspose(ComplexMatrix input) throws Exception {
        try {
            this.allocate(input.columnCount(), input.rowCount());
            double[][] inputr = input.real();
            double[][] inputi = input.imag();
            for (int row = 0; row < this.m_rowCount; ++row) {
                for (int col = 0; col < this.m_columnCount; ++col) {
                    this.m_real[row][col] = inputr[col][row];
                    this.m_imag[row][col] = -inputi[col][row];
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void allocate(int rowCount, int columnCount) {
        try {
            rowCount = Math.max(1, rowCount);
            columnCount = Math.max(1, columnCount);
            if (rowCount == this.m_rowCount && columnCount == this.m_columnCount) {
                return;
            }
            this.m_rowCount = rowCount;
            this.m_columnCount = columnCount;
            this.m_amplitude = new double[this.m_rowCount][this.m_columnCount];
            this.m_phase = new double[this.m_rowCount][this.m_columnCount];
            this.m_real = new double[this.m_rowCount][this.m_columnCount];
            this.m_imag = new double[this.m_rowCount][this.m_columnCount];
            this.m_tempRowReal = new double[this.m_columnCount];
            this.m_tempRowImag = new double[this.m_columnCount];
            this.m_tempColReal = new double[this.m_rowCount];
            this.m_tempColImag = new double[this.m_rowCount];
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepareTempRow(int row) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("((row < 0) || (row >= m_rowCount))");
            }
            for (int col = 0; col < this.m_columnCount; ++col) {
                this.m_tempRowReal[col] = this.m_real[row][col];
                this.m_tempRowImag[col] = this.m_imag[row][col];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepareTempCol(int col) throws Exception {
        try {
            if (col < 0 || col >= this.m_columnCount) {
                throw new Exception("((col < 0) || (col >= m_columnCount))");
            }
            for (int row = 0; row < this.m_rowCount; ++row) {
                this.m_tempColReal[row] = this.m_real[row][col];
                this.m_tempColImag[row] = this.m_imag[row][col];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

