/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Geometry;

import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class TableParserConflict {
    public int ID;
    public int Row;
    public int Line;
    public int Point;
    public int Index;
    public ArrayList<ConflictColumn> Columns = new ArrayList();

    public ConflictColumn getConflictColumn(String name, double oldVal) {
        try {
            for (ConflictColumn cc : this.Columns) {
                if (!name.equalsIgnoreCase(cc.Name)) continue;
                return cc;
            }
            ConflictColumn newcc = new ConflictColumn();
            newcc.Name = name;
            newcc.InitialValue = oldVal;
            this.Columns.add(newcc);
            return newcc;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public boolean addConflict(String column, double oldVal, double newVal, int fileID, long indexInFile) {
        try {
            ConflictColumn cc = this.getConflictColumn(column, oldVal);
            for (ConflictEntry e : cc.Entries) {
                double diff = Math.abs(newVal - e.Value);
                if (!(diff < 0.5)) continue;
                return false;
            }
            ConflictEntry entry = new ConflictEntry();
            entry.Value = newVal;
            entry.FileID = fileID;
            entry.IndexInFile = indexInFile;
            cc.Entries.add(entry);
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    public static class ConflictColumn {
        public String Name;
        public double InitialValue;
        public ArrayList<ConflictEntry> Entries = new ArrayList();
    }

    public static class ConflictEntry {
        public double Value;
        public int FileID;
        public long IndexInFile;
    }
}

