/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Geometry;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Column_Int;
import com.PecosCore.Data.DataType;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integers;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;

public class LPIMapper {
    public boolean UseLineNumber = true;
    public boolean UsePointIndex = true;
    protected int m_count = 0;
    protected Column_Int m_id;
    protected Column_Int m_line;
    protected Column_Int m_point;
    protected Column_Int m_index;
    protected HashMap_Integers<Integer> m_hash = new HashMap_Integers();

    public int count() {
        return this.m_count;
    }

    public LPIMapper() {
        try {
            this.m_id = new Column_Int("ID");
            this.m_line = new Column_Int("Line");
            this.m_point = new Column_Int("Point");
            this.m_index = new Column_Int("Index");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void prepEnsembleID(Ensemble ensemble, String table) {
        try {
            int indexTraceID = ensemble.dictionary().addEntry("Trace", table + "ID", DataType.Int);
            int indexTableID = ensemble.dictionary().addEntry(table, table + "ID", DataType.Int);
            int indexPoint = -9999;
            if (ensemble.dictionary().containsEntry(table, "PointNumber")) {
                indexPoint = ensemble.dictionary().getEntryIndex(table, "PointNumber");
            }
            int indexLine = -9999;
            if (ensemble.dictionary().containsEntry(table, "LineNumber")) {
                indexLine = ensemble.dictionary().getEntryIndex(table, "LineNumber");
            }
            int indexIndex = -9999;
            if (ensemble.dictionary().containsEntry(table, "PointIndex")) {
                indexIndex = ensemble.dictionary().getEntryIndex(table, "PointIndex");
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                Column_Abstract header = ensemble.trace(n).header();
                int point = -9999;
                if (indexPoint >= 0) {
                    point = header.getInt(indexPoint);
                }
                int line = -9999;
                if (indexLine >= 0) {
                    line = header.getInt(indexLine);
                }
                int index = -9999;
                if (indexIndex >= 0) {
                    index = header.getInt(indexIndex);
                }
                int id = this.getID(line, point, index);
                header.putInt(indexTraceID, id);
                header.putInt(indexTableID, id);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void read(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int version = file.readInt();
            if (version == 1000) {
                this.m_count = file.readInt();
                this.UseLineNumber = file.readBoolean();
                this.UsePointIndex = file.readBoolean();
                this.m_id.read(file);
                this.m_line.read(file);
                this.m_point.read(file);
                this.m_index.read(file);
            }
            file.close();
            for (int n = 0; n < this.m_count; ++n) {
                int id = this.m_id.getInt(n);
                int line = this.m_line.getInt(n);
                int point = this.m_point.getInt(n);
                int index = this.m_index.getInt(n);
                this.m_hash.put(new Integer(id), line, point, index);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void save(String fileName) {
        try {
            RandomAccessFile file = new RandomAccessFile(fileName, "rw");
            int version = 1000;
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_count);
                file.writeBoolean(this.UseLineNumber);
                file.writeBoolean(this.UsePointIndex);
                this.m_id.save(file);
                this.m_line.save(file);
                this.m_point.save(file);
                this.m_index.save(file);
            }
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int getID(int line, int point, int index) throws Exception {
        try {
            if (!this.UseLineNumber) {
                line = -9999;
            }
            if (!this.UsePointIndex) {
                index = -9999;
            }
            return this.m_hash.get(line, point, index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add(int id, int line, int point, int index) throws Exception {
        try {
            if (!this.UseLineNumber) {
                line = -9999;
            }
            if (!this.UsePointIndex) {
                index = -9999;
            }
            if (this.m_hash.containsKey(line, point, index)) {
                throw new Exception("Already exists");
            }
            this.m_id.putInt(this.m_count, id);
            this.m_line.putInt(this.m_count, line);
            this.m_point.putInt(this.m_count, point);
            this.m_index.putInt(this.m_count, index);
            ++this.m_count;
            this.m_hash.put(new Integer(id), line, point, index);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }
}

