/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Ensemble.Worker;

import com.PecosCore.Data.ParameterTree;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_Sequence;
import com.PecosCore.Ensemble.Worker.EnsembleWorker_SharedData;
import com.PecosCore.Refraction.IRefractionStaticsProject;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.GenericObjectListener;
import com.PecosCore.Tools.Tools_XML;
import com.PecosCore.Windows.Refraction.Picking.PickPlaneEnum;
import com.PecosCore.Windows.Shared.IProgressMonitor;
import java.io.Serializable;
import java.util.List;
import javax.swing.JComponent;
import org.w3c.dom.Element;

public abstract class EnsembleWorker_Base
extends GenericObjectListener
implements Serializable {
    transient IRefractionStaticsProject _refractionStaticsProject = null;
    transient EnsembleWorker_Sequence _parent_sequence = null;
    public static final String Modified = "Modified";
    public static final String Parameters = "Parameters";
    public static final String SendMessageToOwner = "SendMessageToOwner";
    boolean _bRunningInGeospark = false;
    public boolean RequiresRefractionStaticsProject = false;
    public boolean EnsembleSource = false;
    public int ID = -999999;
    public String Abbreviation = "NOTSET";
    public String ShortDescription = "NOTSET";
    public String WorkerType = "NOTSET";
    protected String m_concat = null;
    public boolean InteractiveMode = false;
    public boolean FinalEnsemble = false;
    public String DistanceUnits = "unknown";
    public boolean InteractiveFlowsOkay = true;
    public boolean WorkerTurnedOn = true;
    public boolean WorkerToggleLocked = true;
    public boolean FirstBreakAutoPicker = false;
    public boolean RequiresShotOrderedData = false;
    public EnsembleWorker_SharedData SharedData;
    public String ActionString = "";
    protected String m_successString = "Success, run time = %0.2f ms";
    protected String m_offString = "Item not on";
    public boolean BelongsToInputSequence = false;
    protected ParameterTree m_parameterTree = new ParameterTree();
    public boolean Success = false;
    public String Reason = "Not yet called";
    public boolean IasAutopicker = false;
    public String AutopickerColumnName = "Not yet called";
    public double WorkTime = 0.0;
    protected PickPlaneEnum m_pickPlane;
    protected double m_sparseCmpX;
    protected double m_sparseCmpY;

    public IRefractionStaticsProject getRefractionStaticsProject() {
        return this._refractionStaticsProject;
    }

    public void setRefractionStaticsProject(IRefractionStaticsProject project) {
        this._refractionStaticsProject = project;
    }

    public EnsembleWorker_Sequence getParentSequence() {
        return this._parent_sequence;
    }

    public void setParentSequence(EnsembleWorker_Sequence sequence) {
        this._parent_sequence = sequence;
    }

    public ParameterTree getParameterTree() {
        return this.m_parameterTree;
    }

    public void readParameters(IRefractionStaticsProject project) throws Exception {
    }

    public int getIterationCount() {
        return 1;
    }

    public boolean getIsOkToLaunchBatch() {
        return true;
    }

    public String getLaunchBatchError() {
        return "";
    }

    public boolean getIsRunningInGeoSpark() {
        return this._bRunningInGeospark;
    }

    public void setIsRunningInGeoSpark(boolean bRunningInGeospark) {
        this._bRunningInGeospark = bRunningInGeospark;
    }

    public boolean requiresTraceTableColumns() {
        return false;
    }

    public boolean isEnsembleSource() {
        return this.EnsembleSource;
    }

    public boolean prepareSource() {
        return false;
    }

    public boolean hasMoreEnsembles() {
        return false;
    }

    public double percentDone() {
        return 0.0;
    }

    public void resetInputWorker() {
    }

    public void work_OverrideSequence(IProgressMonitor progress) {
    }

    public List<String> getErrorList() {
        return null;
    }

    public List<String> getWarningList() {
        return null;
    }

    public List<String> getInfoList() {
        return null;
    }

    public Ensemble nextEnsemble() {
        return null;
    }

    public String getColumnName() {
        try {
            throw new Exception("no column name set for module: " + this.ShortDescription);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "";
        }
    }

    public void printClassInfo() {
        try {
            System.err.println("printClassInfo getCanonicalName = " + this.getClass().getCanonicalName());
            System.err.println("printClassInfo getName = " + this.getClass().getName());
            System.err.println("printClassInfo getSimpleName = " + this.getClass().getSimpleName());
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public abstract String uniqueID();

    public EnsembleWorker_Base cloneWithParameterTree() throws Exception {
        try {
            Class<?> c = this.getClass();
            EnsembleWorker_Base worker = (EnsembleWorker_Base)c.newInstance();
            worker.setParameterTree(this.m_parameterTree.createExactCopy());
            return worker;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public abstract void reloadEditorWidgetFromParams();

    public String concat() {
        if (this.m_concat == null) {
            this.m_concat = this.ShortDescription;
        }
        return this.m_concat;
    }

    public ParameterTree parameterTree() {
        return this.m_parameterTree;
    }

    public void setParameterTree(ParameterTree tree) {
        if (tree != null) {
            this.m_parameterTree = tree;
        }
    }

    public void saveParametersInXmlNode(Element node) throws Exception {
        try {
            Element paramNode = node.getOwnerDocument().createElement(Parameters);
            this.m_parameterTree.writeToNode(paramNode);
            node.appendChild(paramNode);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void readParametersFromXmlNode(Element node) throws Exception {
        try {
            Element paramNode = Tools_XML.getChildWithTagName(node, Parameters, false);
            if (paramNode != null) {
                this.m_parameterTree.readFromNode(paramNode);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public abstract boolean hasEditorWidget();

    public abstract JComponent editorWidget() throws Exception;

    public abstract void getParametersFromWidget();

    protected abstract void work(Ensemble var1) throws Exception;

    public void performWork(Ensemble ensemble) throws Exception {
        try {
            this.IasAutopicker = false;
            this.AutopickerColumnName = "";
            this.Success = true;
            this.Reason = "";
            this.WorkTime = 0.0;
            if (!this.WorkerTurnedOn) {
                throw new Exception("WorkerTurnedOn == false");
            }
            long startTime = System.nanoTime();
            this.work(ensemble);
            long endTime = System.nanoTime();
            this.WorkTime = 1.0E-6 * (double)(endTime - startTime);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void setPickPlane(PickPlaneEnum pickPlane) {
        this.m_pickPlane = pickPlane;
    }

    public void setSparseCmpX(double x) {
        try {
            this.m_sparseCmpX = x;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void setSparseCmpY(double y) {
        try {
            this.m_sparseCmpY = y;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public abstract int outputCount();

    public abstract boolean outputValid(int var1) throws Exception;

    public abstract String outputName(int var1) throws Exception;

    public abstract Ensemble output(int var1) throws Exception;
}

