/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.TraceTable;

import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Data.TraceTable.ITraceTable_Wrapper;
import com.PecosCore.Data.TraceTable.TraceTable;
import com.PecosCore.Data.TraceTable.TraceTable_SingleColumnIndexer;
import com.PecosCore.Data.TraceTable.TraceTable_TwoColumnIndexer;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;

public class TraceTable_Wrapper
implements ITraceTable_Wrapper {
    protected TraceTable_TwoColumnIndexer m_gridIndexer;
    protected TraceTable_SingleColumnIndexer m_receiverIndexer;
    protected TraceTable_SingleColumnIndexer m_shotIndexer;
    protected TraceTable m_traceTable;
    protected Column_Long m_indexColumn = new Column_Long();
    protected int m_indexCount = 0;

    public TraceTable_SingleColumnIndexer receiverIndexer() {
        return this.m_receiverIndexer;
    }

    public TraceTable_SingleColumnIndexer shotIndexer() {
        return this.m_shotIndexer;
    }

    public TraceTable_Wrapper(String path) {
        try {
            this.m_traceTable = new TraceTable(path, "Trace");
            this.m_receiverIndexer = new TraceTable_SingleColumnIndexer(path, "ReceiverID");
            if (!this.m_receiverIndexer.valid() && this.m_traceTable.column_exists("ReceiverID")) {
                this.createIndex(this.m_receiverIndexer, "ReceiverID");
            }
            this.m_shotIndexer = new TraceTable_SingleColumnIndexer(path, "ShotID");
            if (!this.m_shotIndexer.valid() && this.m_traceTable.column_exists("ShotID")) {
                this.createIndex(this.m_shotIndexer, "ShotID");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void recreateReceiverIndex() {
        try {
            this.createIndex(this.m_receiverIndexer, "ReceiverID");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void exportColumn(String columnName, boolean forceInt) {
        try {
            if (!this.m_traceTable.column_exists(columnName)) {
                return;
            }
            int indexCol = this.m_traceTable.column_indexOfColumn(columnName);
            DataType type = this.m_traceTable.column_type(indexCol);
            boolean isInt = type == DataType.Int || type == DataType.Short;
            String fileName = this.m_traceTable.path() + "/" + columnName + "_export.txt";
            boolean numWritten = false;
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));
            int row = 0;
            while ((long)row < this.m_traceTable.rowCount()) {
                if (isInt) {
                    out.println(Integer.toString(this.m_traceTable.getInt(row, indexCol)));
                } else {
                    float v = this.m_traceTable.getFloat(row, indexCol);
                    if (forceInt) {
                        out.println(Integer.toString(Math.round(v)));
                    } else {
                        out.println(Float.toString(v));
                    }
                }
                if (row % 100000 == 0) {
                    System.out.println(" " + row);
                }
                ++row;
            }
            out.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void recomputeGridIndexer() {
        try {
            this.createDoubleIndex(this.m_gridIndexer, "Inline", "Crossline");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, String columnName1, int min1, int max1, String columnName2, int min2, int max2) throws Exception {
        try {
            long start = System.currentTimeMillis();
            this.m_traceTable.populateEnsemble(ensemble, columnName1, min1, max1, columnName2, min2, max2);
            long l = System.currentTimeMillis();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void prepareIndexColumn(String columnName, int min, int max) throws Exception {
        try {
            this.m_indexCount = 0;
            if (columnName.equalsIgnoreCase("ShotID") && this.m_shotIndexer.valid()) {
                for (int v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_shotIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                return;
            }
            if (columnName.equalsIgnoreCase("ReceiverID") && this.m_receiverIndexer.valid()) {
                for (int v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_receiverIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                return;
            }
            int colIndex = this.m_traceTable.column_indexOfColumn(columnName);
            int row = 0;
            while ((long)row < this.m_traceTable.rowCount()) {
                int v = this.m_traceTable.getInt(row, colIndex);
                if (v >= min && v <= max) {
                    this.m_indexColumn.putInt(this.m_indexCount, row);
                    ++this.m_indexCount;
                }
                ++row;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void setIntValueUsingPreparedIndices(String columnName, int v) throws Exception {
        try {
            if (!this.m_traceTable.column_exists(columnName)) {
                return;
            }
            int colIndex = this.m_traceTable.column_indexOfColumn(columnName);
            for (int n = 0; n < this.m_indexCount; ++n) {
                int row = this.m_indexColumn.getInt(n);
                this.m_traceTable.putInt(row, colIndex, v);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void populateEnsemble(Ensemble ensemble, String columnName, int min, int max) throws Exception {
        try {
            if (columnName.equalsIgnoreCase("ShotID") && this.m_shotIndexer.valid()) {
                this.m_indexCount = 0;
                for (int v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_shotIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                return;
            }
            if (columnName.equalsIgnoreCase("ReceiverID") && this.m_receiverIndexer.valid()) {
                this.m_indexCount = 0;
                for (int v = min; v <= max; ++v) {
                    this.m_indexCount = this.m_receiverIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                return;
            }
            this.m_traceTable.populateEnsemble(ensemble, columnName, min, max);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void populateEnsemble(Ensemble ensemble, String columnName, List<Integer> values) throws Exception {
        try {
            if (columnName.equalsIgnoreCase("ShotID") && this.m_shotIndexer.valid()) {
                this.m_indexCount = 0;
                for (Integer v : values) {
                    this.m_indexCount = this.m_shotIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                return;
            }
            if (columnName.equalsIgnoreCase("ReceiverID") && this.m_receiverIndexer.valid()) {
                this.m_indexCount = 0;
                for (Integer v : values) {
                    this.m_indexCount = this.m_receiverIndexer.get(v, this.m_indexCount, this.m_indexColumn);
                }
                this.m_traceTable.populateEnsemble(ensemble, this.m_indexColumn, this.m_indexCount);
                return;
            }
            this.m_traceTable.populateEnsemble(ensemble, columnName, values);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createDoubleIndex(TraceTable_TwoColumnIndexer indexer, String colName1, String colName2) throws Exception {
        try {
            int key2;
            int key1;
            int row;
            Runtime rt = Runtime.getRuntime();
            indexer.clear();
            if (!this.m_traceTable.column_exists(colName1)) {
                return;
            }
            if (!this.m_traceTable.column_exists(colName2)) {
                return;
            }
            int rowCount = (int)this.m_traceTable.rowCount();
            long startMem = rt.freeMemory();
            System.out.println("call prepare_FirstPass.." + Integer.toString((int)(startMem - rt.freeMemory())));
            indexer.prepare_FirstPass(rowCount);
            System.out.println("after prepare_FirstPass.." + Integer.toString((int)(startMem - rt.freeMemory())));
            int index1 = this.m_traceTable.column_indexOfColumn(colName1);
            int index2 = this.m_traceTable.column_indexOfColumn(colName2);
            for (row = 0; row < rowCount; ++row) {
                key1 = this.m_traceTable.getInt(row, index1);
                key2 = this.m_traceTable.getInt(row, index2);
                indexer.add_FirstPass(key1, key2);
            }
            System.out.println("after add_FirstPass.." + Integer.toString((int)(startMem - rt.freeMemory())));
            indexer.prepare_SecondPass();
            System.out.println("after prepare_SecondPass.." + Integer.toString((int)(startMem - rt.freeMemory())));
            for (row = 0; row < rowCount; ++row) {
                key1 = this.m_traceTable.getInt(row, index1);
                key2 = this.m_traceTable.getInt(row, index2);
                indexer.add_SecondPass(key1, key2, row);
            }
            System.out.println("after add_SecondPass.." + Integer.toString((int)(startMem - rt.freeMemory())));
            indexer.finished_SecondPass();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createIndex(TraceTable_SingleColumnIndexer indexer, String colName) throws Exception {
        try {
            int shotID;
            int row;
            indexer.clear();
            if (!this.m_traceTable.column_exists(colName)) {
                return;
            }
            int rowCount = (int)this.m_traceTable.rowCount();
            indexer.prepare_FirstPass(rowCount);
            int index = this.m_traceTable.column_indexOfColumn(colName);
            for (row = 0; row < rowCount; ++row) {
                shotID = this.m_traceTable.getInt(row, index);
                indexer.add_FirstPass(shotID);
            }
            indexer.prepare_SecondPass();
            for (row = 0; row < rowCount; ++row) {
                shotID = this.m_traceTable.getInt(row, index);
                indexer.add_SecondPass(shotID, row);
            }
            indexer.finished_SecondPass();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public String path() {
        return this.m_traceTable.path();
    }

    @Override
    public ITraceTable traceTable() {
        return this.m_traceTable;
    }

    @Override
    public void recreateIndexers() {
        try {
            this.createIndex(this.m_shotIndexer, "ShotID");
            this.createIndex(this.m_receiverIndexer, "ReceiverID");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

