/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.TraceTable;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Map.HashKey_TwoInt;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class TraceTable_TwoColumnIndexer {
    protected String m_fileName_Buffer = "";
    protected String m_fileName_Entry = "";
    protected String m_path;
    protected String m_columnName1;
    protected String m_columnName2;
    protected HashKey_TwoInt m_tempKey = new HashKey_TwoInt(0, 0);
    protected HashMap<HashKey_TwoInt, Entry> m_map = new HashMap();
    protected ByteBuffer m_buffer;
    protected int m_rowCount = 0;
    protected int m_maxCount = 0;
    protected int m_numBufferBytes = 0;
    protected boolean m_valid = false;

    public boolean valid() {
        return this.m_valid;
    }

    public TraceTable_TwoColumnIndexer(String path, String colName1, String colName2) throws Exception {
        try {
            this.m_columnName1 = colName1;
            this.m_columnName2 = colName2;
            this.m_path = path;
            this.m_fileName_Buffer = TraceTable_TwoColumnIndexer.fileNameBuffer(path, colName1, colName2);
            this.m_fileName_Entry = TraceTable_TwoColumnIndexer.fileNameEntry(path, colName1, colName2);
            if (Tools_FileSystem.exists_file(this.m_fileName_Buffer) && Tools_FileSystem.exists_file(this.m_fileName_Entry)) {
                this.readEntries();
                this.m_valid = true;
            } else {
                this.clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clear() throws Exception {
        try {
            this.m_map.clear();
            Tools_FileSystem.deleteFile(this.m_fileName_Buffer);
            Tools_FileSystem.deleteFile(this.m_fileName_Entry);
            this.m_valid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readEntries() throws Exception {
        try {
            this.m_map.clear();
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            int magic = 434324;
            int tempMagic = file.readInt();
            int version = file.readInt();
            if (tempMagic != magic) {
                file.close();
                throw new Exception("tempMagic != magic");
            }
            if (version == 1000) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry(0, 0);
                    e.Key1 = file.readInt();
                    e.Key2 = file.readInt();
                    e.Count = file.readInt();
                    e.BufferOffset = file.readInt();
                    this.m_map.put(new HashKey_TwoInt(e.Key1, e.Key2), e);
                }
            } else {
                file.close();
                throw new Exception("bad version");
            }
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String fileNameBuffer(String path, String column1, String column2) {
        return path + "/Index_" + column1 + "_" + column2 + ".buffer";
    }

    public static String fileNameEntry(String path, String column1, String column2) {
        return path + "/Index_" + column1 + "_" + column2 + ".entry";
    }

    public int get(int key1, int key2, int startIndexInColumn, Column_Abstract column) throws Exception {
        try {
            this.m_tempKey.setKey(key1, key2);
            if (!this.m_map.containsKey(this.m_tempKey)) {
                return startIndexInColumn;
            }
            Entry entry = this.m_map.get(this.m_tempKey);
            int offset = entry.BufferOffset;
            int numBytes = 8 + 4 * entry.Count;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
            file.seek(entry.BufferOffset);
            file.read(buff.array(), 0, numBytes);
            file.close();
            int qc1 = buff.getInt();
            int qc2 = buff.getInt();
            if (qc1 != key1) {
                throw new Exception("qc1 != key1");
            }
            if (qc2 != key2) {
                throw new Exception("qc2 != key2");
            }
            int row = startIndexInColumn;
            for (int n = 0; n < entry.Count; ++n) {
                int traceTableRow = buff.getInt();
                column.putInt(row, traceTableRow);
                ++row;
            }
            return startIndexInColumn += entry.Count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_FirstPass(int rowCount) throws Exception {
        try {
            this.clear();
            this.m_rowCount = rowCount;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_FirstPass(int key1, int key2) throws Exception {
        try {
            this.m_tempKey.setKey(key1, key2);
            if (!this.m_map.containsKey(this.m_tempKey)) {
                this.m_map.put(new HashKey_TwoInt(key1, key2), new Entry(key1, key2));
            }
            Entry entry = this.m_map.get(this.m_tempKey);
            ++entry.Count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_SecondPass() throws Exception {
        try {
            this.m_numBufferBytes = 8 * this.m_map.size() + 4 * this.m_rowCount;
            this.m_buffer = ByteBuffer.allocate(this.m_numBufferBytes);
            int bufferOffset = 0;
            for (Entry entry : this.m_map.values()) {
                entry.NumAdded = 0;
                entry.BufferOffset = bufferOffset;
                this.m_buffer.putInt(bufferOffset, entry.Key1);
                this.m_buffer.putInt(bufferOffset + 4, entry.Key2);
                bufferOffset = bufferOffset + 8 + 4 * entry.Count;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_SecondPass(int key1, int key2, int row) throws Exception {
        try {
            this.m_tempKey.setKey(key1, key2);
            Entry entry = this.m_map.get(this.m_tempKey);
            int offset = entry.BufferOffset + 8 + 4 * entry.NumAdded;
            this.m_buffer.putInt(offset, row);
            ++entry.NumAdded;
            if (entry.NumAdded > entry.Count) {
                throw new Exception("entry.NumAdded > entry.Count");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finished_SecondPass() throws Exception {
        try {
            int totalCount = 0;
            for (Entry entry : this.m_map.values()) {
                if (entry.Count != entry.NumAdded) {
                    throw new Exception("entry.Count != entry.NumAdded");
                }
                totalCount += entry.Count;
            }
            if (totalCount != this.m_rowCount) {
                throw new Exception("totalCount != m_rowCount");
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
            file.write(this.m_buffer.array(), 0, this.m_numBufferBytes);
            file.close();
            this.m_buffer = null;
            file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            int magic = 434324;
            int version = 1000;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_map.size());
                for (Entry entry : this.m_map.values()) {
                    file.writeInt(entry.Key1);
                    file.writeInt(entry.Key2);
                    file.writeInt(entry.Count);
                    file.writeInt(entry.BufferOffset);
                }
            }
            file.close();
            System.gc();
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected class Entry {
        public int Key1;
        public int Key2;
        public int Count = 0;
        public int NumAdded = 0;
        public int BufferOffset = 0;

        public Entry(int key1, int key2) {
            this.Key1 = key1;
            this.Key2 = key2;
        }
    }
}

