/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.TraceTable;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Map.HashKey_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.HashMap;

public class TraceTable_SingleColumnIndexer {
    protected String m_fileName_Buffer = "";
    protected String m_fileName_Entry = "";
    protected String m_path;
    protected String m_columnName;
    protected HashKey_Integer m_tempKey = new HashKey_Integer(0);
    protected HashMap<HashKey_Integer, Entry> m_map = new HashMap();
    protected int m_rowCount = 0;
    protected int m_maxCount = 0;
    protected boolean m_valid = false;
    protected static final int OldMagic = 434324;

    public boolean valid() {
        return this.m_valid;
    }

    public TraceTable_SingleColumnIndexer(String path, String colName) throws Exception {
        try {
            this.m_columnName = colName;
            this.m_path = path;
            this.m_fileName_Buffer = TraceTable_SingleColumnIndexer.fileNameBuffer(path, colName);
            this.m_fileName_Entry = TraceTable_SingleColumnIndexer.fileNameEntry(path, colName);
            boolean foo = true;
            if (Tools_FileSystem.exists_file(this.m_fileName_Buffer) && Tools_FileSystem.exists_file(this.m_fileName_Entry)) {
                this.readEntries();
                this.m_valid = true;
            } else {
                this.clear();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void clear() throws Exception {
        try {
            this.m_map.clear();
            Tools_FileSystem.deleteFile(this.m_fileName_Buffer);
            Tools_FileSystem.deleteFile(this.m_fileName_Entry);
            this.m_valid = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected void readEntries() throws Exception {
        try {
            this.m_map.clear();
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            int magic = file.readInt();
            int version = file.readInt();
            if (magic != 434324) {
                file.close();
                throw new Exception("tempMagic != magic");
            }
            if (version == 1001) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry(0);
                    e.Value = file.readInt();
                    e.Count = file.readInt();
                    e.BufferOffset = file.readLong();
                    this.m_map.put(new HashKey_Integer(e.Value), e);
                }
                file.close();
                return;
            }
            if (version == 1000) {
                int num = file.readInt();
                for (int n = 0; n < num; ++n) {
                    Entry e = new Entry(0);
                    e.Value = file.readInt();
                    e.Count = file.readInt();
                    e.BufferOffset = file.readInt();
                    this.m_map.put(new HashKey_Integer(e.Value), e);
                }
                file.close();
                return;
            }
            file.close();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String fileNameBuffer(String path, String column) {
        return path + "/Index_" + column + ".buffer";
    }

    public static String fileNameEntry(String path, String column) {
        return path + "/Index_" + column + ".entry";
    }

    public int get(int value, int startIndexInColumn, Column_Abstract column) throws Exception {
        try {
            this.m_tempKey.Key = value;
            if (!this.m_map.containsKey(this.m_tempKey)) {
                return startIndexInColumn;
            }
            Entry entry = this.m_map.get(this.m_tempKey);
            int numBytes = 4 + 4 * entry.Count;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
            file.seek(entry.BufferOffset);
            file.read(buff.array(), 0, numBytes);
            file.close();
            int qcValue = buff.getInt();
            if (qcValue != value) {
                throw new Exception("qcValue != value");
            }
            int row = startIndexInColumn;
            for (int n = 0; n < entry.Count; ++n) {
                int traceTableRow = buff.getInt();
                column.putInt(row, traceTableRow);
                ++row;
            }
            return startIndexInColumn += entry.Count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_FirstPass(int rowCount) throws Exception {
        try {
            this.clear();
            this.m_rowCount = rowCount;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_FirstPass(int value) throws Exception {
        try {
            this.m_tempKey.Key = value;
            if (!this.m_map.containsKey(this.m_tempKey)) {
                this.m_map.put(new HashKey_Integer(value), new Entry(value));
            }
            Entry entry = this.m_map.get(this.m_tempKey);
            ++entry.Count;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void prepare_SecondPass() throws Exception {
        try {
            for (Entry entry : this.m_map.values()) {
                entry.NumAdded = 0;
                entry.Row = new int[entry.Count];
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void add_SecondPass(int value, int row) throws Exception {
        try {
            this.m_tempKey.Key = value;
            Entry entry = this.m_map.get(this.m_tempKey);
            entry.Row[entry.NumAdded] = row;
            ++entry.NumAdded;
            if (entry.NumAdded > entry.Count) {
                throw new Exception("entry.NumAdded > entry.Count");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finished_SecondPass() throws Exception {
        try {
            int totalCount = 0;
            int maxCount = 0;
            for (Entry entry : this.m_map.values()) {
                if (entry.Count != entry.NumAdded) {
                    throw new Exception("entry.Count != entry.NumAdded");
                }
                totalCount += entry.Count;
                maxCount = Math.max(maxCount, entry.Count);
            }
            if (totalCount != this.m_rowCount) {
                throw new Exception("totalCount != m_rowCount");
            }
            RandomAccessFile file = new RandomAccessFile(this.m_fileName_Buffer, "rw");
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, 4 + 4 * maxCount);
            for (Entry entry : this.m_map.values()) {
                entry.BufferOffset = file.getFilePointer();
                buff.putInt(0, entry.Value);
                for (int n = 0; n < entry.Count; ++n) {
                    buff.putInt(4 + n * 4, entry.Row[n]);
                }
                int numBytes = 4 + 4 * entry.Count;
                file.write(buff.array(), 0, numBytes);
                entry.Row = null;
            }
            file = new RandomAccessFile(this.m_fileName_Entry, "rw");
            int magic = 434324;
            int version = 1001;
            file.writeInt(magic);
            file.writeInt(version);
            if (version == 1000) {
                file.writeInt(this.m_map.size());
                for (Entry entry : this.m_map.values()) {
                    file.writeInt(entry.Value);
                    file.writeInt(entry.Count);
                    file.writeInt((int)entry.BufferOffset);
                }
            }
            if (version == 1001) {
                file.writeInt(this.m_map.size());
                for (Entry entry : this.m_map.values()) {
                    file.writeInt(entry.Value);
                    file.writeInt(entry.Count);
                    file.writeLong(entry.BufferOffset);
                }
            }
            file.close();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            this.m_valid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected class Entry {
        public int Value;
        public int Count = 0;
        public int NumAdded = 0;
        public long BufferOffset = 0L;
        public int[] Row;

        public Entry(int value) {
            this.Value = value;
        }
    }
}

