/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.TraceTable;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.Column_Long;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Abstract;
import com.PecosCore.Data.TraceTable.Huge.ITraceTable;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleHeaderDictionary;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_XML;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TraceTable
implements ITraceTable {
    protected long m_fileLength = 0L;
    protected String m_path = "";
    protected String m_name = "";
    protected String m_headerFileName_Old;
    protected String m_headerFileName_New;
    protected String m_dataFileName;
    protected RandomAccessFile m_creatorWriter = null;
    protected Column_Long m_indexColumn = new Column_Long();
    protected int m_bytesAllocatedPerRow = 0;
    protected int m_bytesUsedPerRow = 0;
    protected int m_rowCount = 0;
    protected ArrayList<Column> m_columns = new ArrayList();
    protected boolean m_sectionContentsModified = false;
    protected boolean m_sectionValid = false;
    protected int m_sectionRowCount = 20000;
    protected ByteBuffer m_sectionBuffer = null;
    protected int m_sectionBufferByteCount = 20000;
    protected int m_sectionMinimumRowIndex;
    protected int m_sectionMaximumRowIndex;
    protected int m_sectionCurrentRowOffset;
    protected int m_sectionEntryOffset;
    protected int m_headerMagic = 9384765;
    protected int m_headerVersion = 1000;
    protected boolean m_loadKilledTraces = false;

    @Override
    public long rowCount() {
        return this.m_rowCount;
    }

    @Override
    public void addRows(long rowCount) {
        try {
            if (rowCount < 1L) {
                return;
            }
            long startRowCount = this.m_rowCount;
            int rowsPerChunk = 5000;
            int bytesPerChunk = rowsPerChunk * this.m_bytesAllocatedPerRow;
            ByteBuffer buff = ByteBuffer.allocate(bytesPerChunk);
            RandomAccessFile raf = new RandomAccessFile(this.m_dataFileName, "rw");
            raf.seek(raf.length());
            for (long row = 0L; row < rowCount; row += (long)rowsPerChunk) {
                long numRows = rowsPerChunk;
                long lastRow = row + (long)rowsPerChunk - 1L;
                if (lastRow >= rowCount) {
                    lastRow = rowCount - 1L;
                    numRows = lastRow - row + 1L;
                }
                if (numRows < 1L) continue;
                raf.write(buff.array(), 0, (int)(numRows * (long)this.m_bytesAllocatedPerRow));
            }
            raf.close();
            this.m_rowCount += (int)rowCount;
            for (long r = startRowCount; r < (long)this.m_rowCount; ++r) {
                for (int c = 0; c < this.column_count(); ++c) {
                    this.putInt(r, c, -9999);
                }
            }
            this.saveHeaderFile(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public String path() {
        return this.m_path;
    }

    public TraceTable(String path, String name) throws Exception {
        try {
            boolean headerExists;
            this.prepFileNames(path, name);
            boolean bl = headerExists = Tools_FileSystem.exists_file(this.m_headerFileName_Old) || Tools_FileSystem.exists_file(this.m_headerFileName_New);
            if (!headerExists) {
                throw new Exception("header file does not exist");
            }
            this.readHeaderFile();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public TraceTable(String path, String name, Ensemble ensemble, int extraColumns) throws Exception {
        try {
            boolean headerExists;
            this.prepFileNames(path, name);
            boolean bl = headerExists = Tools_FileSystem.exists_file(this.m_headerFileName_Old) || Tools_FileSystem.exists_file(this.m_headerFileName_New);
            if (headerExists || Tools_FileSystem.exists_file(this.m_dataFileName)) {
                throw new Exception("Files must not exist");
            }
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int currentOffset = 0;
            for (int n = 0; n < dict.size(); ++n) {
                EnsembleHeaderDictionary.Entry entry = dict.getEntry(n);
                if (!entry.Table.equalsIgnoreCase("Trace")) continue;
                DataType t = entry.PreferredType;
                if (t == DataType.Short) {
                    t = DataType.Int;
                }
                if (t == DataType.Long) {
                    t = DataType.Int;
                }
                if (t == DataType.Double) {
                    t = DataType.Float;
                }
                if (t != DataType.Int && t != DataType.Float) continue;
                Column column = new Column();
                column.Offset = currentOffset;
                column.Type = t;
                column.Name = entry.Column;
                currentOffset += t.Length;
                this.m_columns.add(column);
            }
            this.m_bytesUsedPerRow = currentOffset;
            extraColumns = Math.max(extraColumns, 4);
            extraColumns = Math.min(extraColumns, 12);
            this.m_bytesAllocatedPerRow = this.m_bytesUsedPerRow + extraColumns * DataType.Float.Length;
            this.m_creatorWriter = new RandomAccessFile(this.m_dataFileName, "rw");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public TraceTable(String path, String name, Table_Abstract table, int extraColumns) throws Exception {
        try {
            boolean headerExists;
            this.prepFileNames(path, name);
            boolean bl = headerExists = Tools_FileSystem.exists_file(this.m_headerFileName_Old) || Tools_FileSystem.exists_file(this.m_headerFileName_New);
            if (headerExists || Tools_FileSystem.exists_file(this.m_dataFileName)) {
                throw new Exception("Files must not exist");
            }
            int currentOffset = 0;
            for (int c = 0; c < table.column_count(); ++c) {
                DataType t = table.column_type(c);
                if (t != DataType.Int && t != DataType.Float && t != DataType.Double) continue;
                Column column = new Column();
                column.Offset = currentOffset;
                column.Type = t;
                column.Name = table.column_name(c);
                currentOffset += t.Length;
                this.m_columns.add(column);
            }
            this.m_bytesUsedPerRow = currentOffset;
            extraColumns = Math.max(extraColumns, 4);
            extraColumns = Math.min(extraColumns, 12);
            this.m_bytesAllocatedPerRow = this.m_bytesUsedPerRow + extraColumns * DataType.Float.Length;
            this.m_creatorWriter = new RandomAccessFile(this.m_dataFileName, "rw");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized int sectionRowCount() {
        return this.m_sectionRowCount;
    }

    protected synchronized void prepFileNames(String path, String name) throws Exception {
        try {
            if (!Tools_FileSystem.exists_path(path)) {
                throw new Exception("Path must exist");
            }
            this.m_path = path;
            this.m_name = name;
            this.m_headerFileName_Old = TraceTable.headerFileName_Old(path, name);
            this.m_headerFileName_New = TraceTable.headerFileName_New(path, name);
            this.m_dataFileName = TraceTable.dataFileName(path, name);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String dataFileName(String path, String name) throws Exception {
        try {
            return path + "/" + name + ".data";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String headerFileName_Old(String path, String name) throws Exception {
        try {
            return path + "/" + name + ".header";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public static String headerFileName_New(String path, String name) throws Exception {
        try {
            return path + "/" + name + ".xml";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void saveHeaderFile(Logger logger) throws Exception {
        try {
            if (logger != null) {
                logger.log(Level.INFO, "saveHeaderFile, call createDocument");
            }
            Document document = Tools_XML.createDocument();
            if (logger != null) {
                logger.log(Level.INFO, "saveHeaderFile, call createElement");
            }
            Element root = document.createElement("Header");
            document.appendChild(root);
            root.setAttribute("BytesUsedPerRow", Integer.toString(this.m_bytesUsedPerRow));
            root.setAttribute("BytesAllocatedPerRow", Integer.toString(this.m_bytesAllocatedPerRow));
            root.setAttribute("RowCount", Integer.toString(this.m_rowCount));
            root.setAttribute("ColumnCount", Integer.toString(this.m_columns.size()));
            for (Column column : this.m_columns) {
                Element colNode = root.getOwnerDocument().createElement("Column");
                root.appendChild(colNode);
                colNode.setAttribute("Name", column.Name);
                colNode.setAttribute("Type", column.Type.Description);
                colNode.setAttribute("Offset", Integer.toString(column.Offset));
            }
            if (logger != null) {
                logger.log(Level.INFO, "saveHeaderFile, call writeDocumentToFile");
            }
            Tools_XML.writeDocumentToFile(logger, document, this.m_headerFileName_New);
        }
        catch (Exception error) {
            if (logger != null) {
                logger.log(Level.INFO, error.getMessage());
            } else {
                ExceptionMonitor.add(error);
            }
            throw error;
        }
    }

    @Override
    public synchronized void readHeaderFile() throws Exception {
        try {
            if (Tools_FileSystem.exists_file(this.m_headerFileName_New)) {
                Document doc = Tools_XML.readDocument(this.m_headerFileName_New);
                Element root = (Element)doc.getFirstChild();
                this.m_bytesUsedPerRow = Integer.parseInt(root.getAttribute("BytesUsedPerRow"));
                this.m_bytesAllocatedPerRow = Integer.parseInt(root.getAttribute("BytesAllocatedPerRow"));
                this.m_rowCount = Integer.parseInt(root.getAttribute("RowCount"));
                int numCols = Integer.parseInt(root.getAttribute("ColumnCount"));
                ArrayList<Element> columnNodeList = Tools_XML.getChildListWithTagName(root, "Column");
                for (Element columnNode : columnNodeList) {
                    Column column = new Column();
                    column.Name = columnNode.getAttribute("Name");
                    String colTypeDesc = columnNode.getAttribute("Type");
                    column.Type = DataType.typeFromDescription(colTypeDesc);
                    column.Offset = Integer.parseInt(columnNode.getAttribute("Offset"));
                    this.m_columns.add(column);
                }
                this.prepareSectionBuffer(null);
                return;
            }
            RandomAccessFile reader = new RandomAccessFile(this.m_headerFileName_Old, "rw");
            int magic = reader.readInt();
            if (magic != this.m_headerMagic) {
                throw new Exception("magic != m_headerMagic");
            }
            int version = reader.readInt();
            if (version == 1000) {
                this.m_bytesUsedPerRow = reader.readInt();
                this.m_bytesAllocatedPerRow = reader.readInt();
                this.m_rowCount = reader.readInt();
                int numCols = reader.readInt();
                for (int col = 0; col < numCols; ++col) {
                    Column column = new Column();
                    column.Name = reader.readUTF();
                    String typeDesc = reader.readUTF();
                    column.Type = DataType.typeFromDescription(typeDesc);
                    column.Offset = reader.readInt();
                    this.m_columns.add(column);
                }
            } else {
                reader.close();
                throw new Exception("bad version");
            }
            reader.close();
            this.prepareSectionBuffer(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized void expandFile(int newAllocatedByteCount) throws Exception {
        try {
            this.saveCurrentSection();
            this.m_sectionBuffer = null;
            if (newAllocatedByteCount <= this.m_bytesAllocatedPerRow) {
                return;
            }
            newAllocatedByteCount = Math.max(newAllocatedByteCount, this.m_bytesAllocatedPerRow + 20);
            int numRowsPerBlob = 10000;
            int bytesPerBlob_Old = numRowsPerBlob * this.m_bytesAllocatedPerRow;
            int bytesPerBlob_New = numRowsPerBlob * newAllocatedByteCount;
            ByteBuffer oldBuff = ByteBuffer_Shared.buffer(0, bytesPerBlob_Old);
            ByteBuffer newBuff = ByteBuffer_Shared.buffer(1, bytesPerBlob_New);
            String tempFileName = this.m_path + "/crap.bin";
            RandomAccessFile reader = new RandomAccessFile(this.m_dataFileName, "rw");
            RandomAccessFile writer = new RandomAccessFile(tempFileName, "rw");
            int currentRow = 0;
            byte[] oldArray = oldBuff.array();
            byte[] newArray = newBuff.array();
            for (int n = 0; n < newArray.length; ++n) {
                newArray[n] = 0;
            }
            while (currentRow < this.m_rowCount) {
                System.out.println(String.format("row = %d", currentRow));
                int lastRowIndex = currentRow + numRowsPerBlob;
                lastRowIndex = Math.min(lastRowIndex, this.m_rowCount - 1);
                int numRows = lastRowIndex - currentRow + 1;
                reader.read(oldArray, 0, numRows * this.m_bytesAllocatedPerRow);
                for (int row = 0; row < numRows; ++row) {
                    int oldOff = row * this.m_bytesAllocatedPerRow;
                    int newOff = row * newAllocatedByteCount;
                    for (int b = 0; b < this.m_bytesAllocatedPerRow; ++b) {
                        newArray[newOff + b] = oldArray[oldOff + b];
                    }
                }
                writer.write(newArray, 0, numRows * newAllocatedByteCount);
                currentRow += numRowsPerBlob;
            }
            reader.close();
            writer.close();
            Tools_FileSystem.copyFile(tempFileName, this.m_dataFileName);
            this.m_bytesAllocatedPerRow = newAllocatedByteCount;
            this.saveHeaderFile(null);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized boolean needToExpandTableMemory(DataType type) throws Exception {
        try {
            boolean ok;
            boolean bl = ok = type == DataType.Double || type == DataType.Int || type == DataType.Float;
            if (!ok) {
                throw new Exception("bad type");
            }
            int numBytesNeeded = this.m_bytesUsedPerRow + type.Length;
            return numBytesNeeded > this.m_bytesAllocatedPerRow;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized int column_append(String colName, DataType type) throws Exception {
        try {
            boolean ok;
            this.saveCurrentSection();
            for (Column column : this.m_columns) {
                if (!colName.equalsIgnoreCase(column.Name)) continue;
                return this.column_indexOfColumn(colName);
            }
            boolean bl = ok = type == DataType.Double || type == DataType.Int || type == DataType.Float;
            if (!ok) {
                throw new Exception("bad type");
            }
            int numBytesNeeded = this.m_bytesUsedPerRow + type.Length;
            if (numBytesNeeded > this.m_bytesAllocatedPerRow) {
                throw new Exception("numBytesNeeded > m_bytesAllocatedPerRow");
            }
            Column newCol = new Column();
            newCol.Name = colName;
            newCol.Type = type;
            newCol.Offset = this.m_bytesUsedPerRow;
            this.m_columns.add(newCol);
            this.m_bytesUsedPerRow += type.Length;
            this.saveHeaderFile(null);
            return this.column_indexOfColumn(colName);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized ArrayList<String> columns() {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (int n = 0; n < this.m_columns.size(); ++n) {
                Column column = this.m_columns.get(n);
                list.add(column.Name);
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    @Override
    public synchronized ArrayList<String> columns(String prefix) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            for (int n = 0; n < this.m_columns.size(); ++n) {
                Column column = this.m_columns.get(n);
                String colName = column.Name;
                if (!colName.startsWith(prefix)) continue;
                list.add(colName);
            }
            Collections.sort(list);
            return list;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return new ArrayList<String>();
        }
    }

    @Override
    public synchronized DataType column_type(int index) {
        return this.m_columns.get((int)index).Type;
    }

    @Override
    public synchronized String column_name(int index) {
        return this.m_columns.get((int)index).Name;
    }

    @Override
    public synchronized int column_count() {
        return this.m_columns.size();
    }

    @Override
    public synchronized int column_indexOfColumn(String colName) {
        try {
            for (int n = 0; n < this.m_columns.size(); ++n) {
                Column column = this.m_columns.get(n);
                if (!colName.equalsIgnoreCase(column.Name)) continue;
                return n;
            }
            return -9999;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return -9999;
        }
    }

    @Override
    public synchronized boolean column_exists(String colName) {
        try {
            for (Column column : this.m_columns) {
                if (!colName.equalsIgnoreCase(column.Name)) continue;
                return true;
            }
            return false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return false;
        }
    }

    protected synchronized void prepareSectionBuffer(Logger logger) {
        try {
            this.m_sectionValid = false;
            this.m_sectionContentsModified = false;
            this.m_sectionRowCount = Math.min(10000, this.m_rowCount);
            this.m_sectionBufferByteCount = this.m_sectionRowCount * this.m_bytesAllocatedPerRow;
            this.m_sectionBuffer = ByteBuffer.allocate(this.m_sectionBufferByteCount);
            this.m_sectionMinimumRowIndex = -9999;
            this.m_sectionMaximumRowIndex = -9999;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected synchronized void prepareSectionAndColumn(int row, int columnIndex) throws Exception {
        try {
            this.prepareSection(row);
            this.m_sectionEntryOffset = this.m_sectionCurrentRowOffset + this.m_columns.get((int)columnIndex).Offset;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void saveCurrentSection() throws Exception {
        try {
            if (!this.m_sectionValid) {
                return;
            }
            if (!this.m_sectionContentsModified) {
                return;
            }
            long offset = (long)this.m_sectionMinimumRowIndex * (long)this.m_bytesAllocatedPerRow;
            RandomAccessFile reader = null;
            reader = new RandomAccessFile(this.m_dataFileName, "rw");
            reader.seek(offset);
            reader.write(this.m_sectionBuffer.array(), 0, this.m_sectionBufferByteCount);
            reader.close();
            this.m_sectionContentsModified = false;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    protected synchronized void prepareSection(int row) throws Exception {
        try {
            if (row < 0 || row >= this.m_rowCount) {
                throw new Exception("(row < 0) || (row >= m_rowCount)");
            }
            if (row >= this.m_sectionMinimumRowIndex && row <= this.m_sectionMaximumRowIndex) {
                this.m_sectionCurrentRowOffset = (row - this.m_sectionMinimumRowIndex) * this.m_bytesAllocatedPerRow;
                return;
            }
            this.saveCurrentSection();
            this.m_sectionMinimumRowIndex = row;
            this.m_sectionMaximumRowIndex = this.m_sectionMinimumRowIndex + this.m_sectionRowCount - 1;
            if (this.m_sectionMaximumRowIndex >= this.m_rowCount) {
                this.m_sectionMaximumRowIndex = this.m_rowCount - 1;
                this.m_sectionMinimumRowIndex = this.m_sectionMaximumRowIndex - this.m_sectionRowCount + 1;
            }
            long offset = (long)this.m_sectionMinimumRowIndex * (long)this.m_bytesAllocatedPerRow;
            RandomAccessFile reader = null;
            reader = new RandomAccessFile(this.m_dataFileName, "rw");
            reader.seek(offset);
            reader.read(this.m_sectionBuffer.array(), 0, this.m_sectionBufferByteCount);
            reader.close();
            this.m_sectionValid = true;
            this.m_sectionContentsModified = false;
            this.m_sectionCurrentRowOffset = (row - this.m_sectionMinimumRowIndex) * this.m_bytesAllocatedPerRow;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void mergeHeaderValue(Ensemble ensemble, String colName) {
        try {
            if (!this.column_exists(colName)) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Trace", colName)) {
                return;
            }
            if (!ensemble.dictionary().containsEntry("Trace", "TraceIndex")) {
                return;
            }
            ensemble.sortInt(0, "Trace", "TraceIndex", "Trace", "TraceIndex");
            int columnIndex = this.column_indexOfColumn(colName);
            int headerIndex_Col = ensemble.dictionary().getEntryIndex("Trace", colName);
            int headerIndex_Row = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            if (this.column_type(columnIndex) == DataType.Int) {
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int row = trace.header().getInt(headerIndex_Row);
                    int v = trace.header().getInt(headerIndex_Col);
                    this.putInt(row, columnIndex, v);
                }
            } else {
                for (int n = 0; n < ensemble.traceCount(); ++n) {
                    EnsembleTrace trace = ensemble.trace(n);
                    int row = trace.header().getInt(headerIndex_Row);
                    float v = trace.header().getFloat(headerIndex_Col);
                    this.putFloat(row, columnIndex, v);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void copyColumnFloat_All(String c1, String c2) {
        try {
            int index2;
            if (!this.column_exists(c1)) {
                return;
            }
            if (!this.column_exists(c2)) {
                return;
            }
            int index1 = this.column_indexOfColumn(c1);
            if (index1 == (index2 = this.column_indexOfColumn(c2))) {
                return;
            }
            for (int row = 0; row < this.m_rowCount; ++row) {
                float v = this.getFloat(row, index1);
                this.putFloat(row, index2, v);
            }
            this.saveCurrentSection();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void copyColumnFloat_JustInvalid(String c1, String c2, float minValid) {
        try {
            int index2;
            if (!this.column_exists(c1)) {
                return;
            }
            if (!this.column_exists(c2)) {
                return;
            }
            int index1 = this.column_indexOfColumn(c1);
            if (index1 == (index2 = this.column_indexOfColumn(c2))) {
                return;
            }
            for (int row = 0; row < this.m_rowCount; ++row) {
                float v1 = this.getFloat(row, index1);
                float v2 = this.getFloat(row, index2);
                if (!(v2 < minValid)) continue;
                this.putFloat(row, index2, v1);
            }
            this.saveCurrentSection();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized void setColumnValue(int columnIndex, float v) {
        try {
            for (int row = 0; row < this.m_rowCount; ++row) {
                this.putFloat(row, columnIndex, v);
            }
            this.saveCurrentSection();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public synchronized String getString(long r, int columnIndex) {
        try {
            int row = (int)r;
            if (this.m_columns.get((int)columnIndex).Type == DataType.Int) {
                return Integer.toString(this.getInt(row, columnIndex));
            }
            if (this.m_columns.get((int)columnIndex).Type == DataType.Float) {
                return Float.toString(this.getFloat(row, columnIndex));
            }
            return "Error";
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return "Error";
        }
    }

    @Override
    public synchronized void putInt(long r, int columnIndex, int value) throws Exception {
        try {
            int row = (int)r;
            if (this.m_columns.get((int)columnIndex).Type == DataType.Float) {
                this.putFloat(row, columnIndex, value);
                return;
            }
            if (this.m_columns.get((int)columnIndex).Type != DataType.Int) {
                throw new Exception("Type != DataType.Int");
            }
            this.prepareSectionAndColumn(row, columnIndex);
            this.m_sectionBuffer.putInt(this.m_sectionEntryOffset, value);
            this.m_sectionContentsModified = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized int getInt(long r, int columnIndex) throws Exception {
        try {
            int row = (int)r;
            this.prepareSectionAndColumn(row, columnIndex);
            if (this.m_columns.get((int)columnIndex).Type == DataType.Int) {
                int v = this.m_sectionBuffer.getInt(this.m_sectionEntryOffset);
                return v;
            }
            if (this.m_columns.get((int)columnIndex).Type == DataType.Float) {
                int v = Math.round(this.m_sectionBuffer.getFloat(this.m_sectionEntryOffset));
                return v;
            }
            throw new Exception("Unrecognized type");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public void putLong(long r, int columnIndex, long value) throws Exception {
        try {
            int row = (int)r;
            if (this.m_columns.get((int)columnIndex).Type != DataType.Long) {
                throw new Exception("Type != DataType.Long");
            }
            this.prepareSectionAndColumn(row, columnIndex);
            this.m_sectionBuffer.putLong(this.m_sectionEntryOffset, value);
            this.m_sectionContentsModified = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public long getLong(long r, int columnIndex) throws Exception {
        try {
            int row = (int)r;
            this.prepareSectionAndColumn(row, columnIndex);
            if (this.m_columns.get((int)columnIndex).Type == DataType.Int) {
                return this.m_sectionBuffer.getInt(this.m_sectionEntryOffset);
            }
            if (this.m_columns.get((int)columnIndex).Type == DataType.Float) {
                return Math.round(this.m_sectionBuffer.getFloat(this.m_sectionEntryOffset));
            }
            if (this.m_columns.get((int)columnIndex).Type == DataType.Long) {
                return this.m_sectionBuffer.getLong(this.m_sectionEntryOffset);
            }
            throw new Exception("Unrecognized type");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void putFloat(long r, int columnIndex, float value) throws Exception {
        try {
            int row = (int)r;
            if (this.m_columns.get((int)columnIndex).Type == DataType.Int) {
                this.putInt(row, columnIndex, Math.round(value));
                return;
            }
            if (this.m_columns.get((int)columnIndex).Type != DataType.Float) {
                throw new Exception("Type != DataType.Float");
            }
            this.prepareSectionAndColumn(row, columnIndex);
            this.m_sectionBuffer.putFloat(this.m_sectionEntryOffset, value);
            this.m_sectionContentsModified = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized float getFloat(long r, int columnIndex) throws Exception {
        try {
            int row = (int)r;
            this.prepareSectionAndColumn(row, columnIndex);
            if (this.m_columns.get((int)columnIndex).Type == DataType.Float) {
                return this.m_sectionBuffer.getFloat(this.m_sectionEntryOffset);
            }
            if (this.m_columns.get((int)columnIndex).Type == DataType.Int) {
                return this.m_sectionBuffer.getInt(this.m_sectionEntryOffset);
            }
            throw new Exception("Unrecognized type");
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void setFlag(long r, int columnIndex, int flagBit, boolean setFlagOn) throws Exception {
        try {
            int row = (int)r;
            if (this.m_columns.get((int)columnIndex).Type != DataType.Int) {
                throw new Exception("Type != DataType.Int");
            }
            int current = this.getInt(row, columnIndex);
            current = setFlagOn ? (current |= flagBit) : (current &= ~flagBit);
            this.putInt(row, columnIndex, current);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized boolean getFlag(long r, int columnIndex, int flagBit) throws Exception {
        try {
            int row = (int)r;
            if (this.m_columns.get((int)columnIndex).Type != DataType.Int) {
                throw new Exception("Type != DataType.Int");
            }
            int current = this.getInt(row, columnIndex);
            return (current &= flagBit) != 0;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized boolean toggleFlag(long r, int columnIndex, int flagBit) throws Exception {
        try {
            int row = (int)r;
            if (this.getFlag(row, columnIndex, flagBit)) {
                this.setFlag(row, columnIndex, flagBit, false);
            } else {
                this.setFlag(row, columnIndex, flagBit, true);
            }
            this.saveCurrentSection();
            return this.getFlag(row, columnIndex, flagBit);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void populateTable(Table_Abstract table, long s, int count) throws Exception {
        try {
            int start = (int)s;
            for (Column column : this.m_columns) {
                column.Connector = table.column_append(column.Name, column.Type);
            }
            for (int n = 0; n < count; ++n) {
                int traceRow = start + n;
                if (traceRow < 0 || traceRow >= this.m_rowCount) continue;
                this.prepareSection(traceRow);
                int tableRow = table.row_increment();
                for (Column column : this.m_columns) {
                    int offset = this.m_sectionCurrentRowOffset + column.Offset;
                    if (column.Type == DataType.Float) {
                        float val = this.m_sectionBuffer.getFloat(offset);
                        table.putFloat(tableRow, column.Connector, val);
                    }
                    if (column.Type == DataType.Double) {
                        double val = this.m_sectionBuffer.getDouble(offset);
                        table.putDouble(tableRow, column.Connector, val);
                    }
                    if (column.Type != DataType.Int) continue;
                    int val = this.m_sectionBuffer.getInt(offset);
                    table.putInt(tableRow, column.Connector, val);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void populateEnsemble(Ensemble ensemble, long s, int count) throws Exception {
        try {
            int start = (int)s;
            int numOkay = 0;
            for (int n = 0; n < count; ++n) {
                int row = start + n;
                if (row < 0 || row >= this.m_rowCount) continue;
                this.m_indexColumn.putInt(numOkay, row);
                ++numOkay;
            }
            if (numOkay < 1) {
                System.out.println("numOkay = 0");
            }
            this.populateEnsemble(ensemble, this.m_indexColumn, numOkay);
            if (ensemble.traceCount() < 1) {
                System.out.println("ensemble.traceCount() < 1");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void fillEnsembleHeaders(Ensemble ensemble) throws Exception {
        try {
            ensemble.sortInt(0, "Trace", "TraceIndex", "Trace", "TraceIndex");
            for (Column column : this.m_columns) {
                column.Connector = ensemble.dictionary().addEntry("Trace", column.Name, column.Type);
            }
            int indexTrace = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Int);
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int row = trace.header().getInt(indexTrace);
                this.prepareSection(row);
                for (Column column : this.m_columns) {
                    int offset = this.m_sectionCurrentRowOffset + column.Offset;
                    if (column.Type == DataType.Float) {
                        float val = this.m_sectionBuffer.getFloat(offset);
                        trace.header().putFloat(column.Connector, val);
                    }
                    if (column.Type == DataType.Double) {
                        double val = this.m_sectionBuffer.getDouble(offset);
                        trace.header().putDouble(column.Connector, val);
                    }
                    if (column.Type != DataType.Int) continue;
                    int val = this.m_sectionBuffer.getInt(offset);
                    trace.header().putInt(column.Connector, val);
                }
            }
            ensemble.removeKilledTraces();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void populateEnsembleUsingTraceIndex(Ensemble ensemble) throws Exception {
        try {
            if (ensemble.traceCount() < 1) {
                return;
            }
            ensemble.sortInt(0, "Trace", "TraceIndex", "Trace", "TraceIndex");
            int indexTrace = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            for (Column column : this.m_columns) {
                column.Connector = ensemble.dictionary().addEntry("Trace", column.Name, column.Type);
            }
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                EnsembleTrace trace = ensemble.trace(n);
                int row = trace.header().getInt(indexTrace);
                for (int col = 0; col < this.m_columns.size(); ++col) {
                    Column column = this.m_columns.get(col);
                    if (column.Type == DataType.Float) {
                        float val = this.getFloat(row, col);
                        trace.header().putFloat(column.Connector, val);
                    }
                    if (column.Type == DataType.Double) {
                        double val = this.getFloat(row, col);
                        trace.header().putDouble(column.Connector, val);
                    }
                    if (column.Type != DataType.Int) continue;
                    int val = this.getInt(row, col);
                    trace.header().putInt(column.Connector, val);
                }
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void setLoadKilledTraces(boolean loadKilledTraces) {
        try {
            this.m_loadKilledTraces = loadKilledTraces;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public synchronized void populateEnsemble(Ensemble ensemble, Column_Long indices, int count) throws Exception {
        try {
            indices.sort(count);
            for (Column column : this.m_columns) {
                column.Connector = ensemble.dictionary().addEntry("Trace", column.Name, column.Type);
            }
            int indexTrace = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Int);
            int colKilled = -9999;
            if (!this.m_loadKilledTraces && this.column_exists("Killed")) {
                colKilled = this.column_indexOfColumn("Killed");
            }
            int colTraceCode = -9999;
            if (this.column_exists("TraceCode")) {
                colTraceCode = this.column_indexOfColumn("TraceCode");
            }
            for (int n = 0; n < count; ++n) {
                int row = indices.getInt(n);
                if (row >= 0 && row < this.m_rowCount) {
                    int code;
                    int killed = 0;
                    if (colKilled >= 0) {
                        killed = this.getInt(row, colKilled);
                    }
                    if (colTraceCode >= 0 && (code = this.getInt(row, colTraceCode)) != 1) {
                        killed = 1;
                    }
                    if (killed != 0) continue;
                    EnsembleTrace trace = ensemble.addTrace();
                    trace.header().putInt(indexTrace, row);
                    for (int col = 0; col < this.m_columns.size(); ++col) {
                        Column column = this.m_columns.get(col);
                        if (column.Type == DataType.Float) {
                            float val = this.getFloat(row, col);
                            trace.header().putFloat(column.Connector, val);
                        }
                        if (column.Type == DataType.Double) {
                            double val = this.getFloat(row, col);
                            trace.header().putDouble(column.Connector, val);
                        }
                        if (column.Type != DataType.Int) continue;
                        int val = this.getInt(row, col);
                        trace.header().putInt(column.Connector, val);
                    }
                    continue;
                }
                System.out.println("Bad index");
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void populateEnsemble(Ensemble ensemble, String columnName1, int min1, int max1, String columnName2, int min2, int max2) throws Exception {
        try {
            int selectorOffset1 = -9999;
            int selectorOffset2 = -9999;
            for (Column column : this.m_columns) {
                if (columnName1.equalsIgnoreCase(column.Name) && column.Type == DataType.Int) {
                    selectorOffset1 = column.Offset;
                }
                if (!columnName2.equalsIgnoreCase(column.Name) || column.Type != DataType.Int) continue;
                selectorOffset2 = column.Offset;
            }
            if (selectorOffset1 < 0) {
                return;
            }
            if (selectorOffset2 < 0) {
                return;
            }
            int count = 0;
            int indexTrace = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Int);
            for (int row = 0; row < this.m_rowCount; ++row) {
                this.prepareSection(row);
                int v1 = this.m_sectionBuffer.getInt(this.m_sectionCurrentRowOffset + selectorOffset1);
                int v2 = this.m_sectionBuffer.getInt(this.m_sectionCurrentRowOffset + selectorOffset2);
                if (v1 < min1 || v1 > max1 || v2 < min2 || v2 > max2) continue;
                this.m_indexColumn.putInt(count, row);
                ++count;
            }
            this.populateEnsemble(ensemble, this.m_indexColumn, count);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void populateEnsemble(Ensemble ensemble, long[] indices, int num) throws Exception {
        try {
            int count = 0;
            if (indices == null) {
                return;
            }
            num = Math.min(num, indices.length);
            for (int n = 0; n < num; ++n) {
                int row = (int)indices[n];
                if (row < 0 || row >= this.m_rowCount) continue;
                this.m_indexColumn.putInt(count, row);
                ++count;
            }
            this.populateEnsemble(ensemble, this.m_indexColumn, count);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void populateEnsemble(Ensemble ensemble, String columnName, int min, int max) throws Exception {
        try {
            int selectorOffset = -9999;
            for (Column column : this.m_columns) {
                if (!columnName.equalsIgnoreCase(column.Name) || column.Type != DataType.Int) continue;
                selectorOffset = column.Offset;
            }
            if (selectorOffset < 0) {
                return;
            }
            int indexTrace = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Int);
            int count = 0;
            for (int row = 0; row < this.m_rowCount; ++row) {
                this.prepareSection(row);
                int v = this.m_sectionBuffer.getInt(this.m_sectionCurrentRowOffset + selectorOffset);
                if (v < min || v > max) continue;
                this.m_indexColumn.putInt(count, row);
                ++count;
            }
            this.populateEnsemble(ensemble, this.m_indexColumn, count);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public synchronized void populateEnsemble(Ensemble ensemble, String columnName, List<Integer> values) throws Exception {
        try {
            int selectorOffset = -9999;
            for (Column column : this.m_columns) {
                if (!columnName.equalsIgnoreCase(column.Name) || column.Type != DataType.Int) continue;
                selectorOffset = column.Offset;
            }
            if (selectorOffset < 0) {
                return;
            }
            int indexTrace = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Int);
            int count = 0;
            for (int row = 0; row < this.m_rowCount; ++row) {
                this.prepareSection(row);
                int v = this.m_sectionBuffer.getInt(this.m_sectionCurrentRowOffset + selectorOffset);
                boolean bContainsValue = false;
                for (Integer val : values) {
                    if (val != v) continue;
                    bContainsValue = true;
                }
                if (!bContainsValue) continue;
                this.m_indexColumn.putInt(count, row);
                ++count;
            }
            this.populateEnsemble(ensemble, this.m_indexColumn, count);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized void finishedAppending(Logger logger) throws Exception {
        try {
            if (this.m_creatorWriter == null) {
                if (logger != null) {
                    logger.log(Level.INFO, "(m_creatorWriter == null)");
                }
                throw new Exception("m_creatorWriter == null");
            }
            this.m_creatorWriter.close();
            this.m_creatorWriter = null;
            this.saveHeaderFile(logger);
            this.prepareSectionBuffer(logger);
        }
        catch (Exception error) {
            if (logger == null) {
                ExceptionMonitor.add(error);
            } else {
                logger.log(Level.INFO, "finishedAppending exception, " + error.getMessage());
            }
            throw error;
        }
    }

    @Override
    public synchronized void appendTable(Table_Abstract table) throws Exception {
        try {
            if (this.m_creatorWriter == null) {
                throw new Exception("m_creatorWriter == null");
            }
            if (table.row_count() < 1) {
                return;
            }
            for (Column column : this.m_columns) {
                column.Connector = -9999;
                if (!table.column_exists(column.Name)) continue;
                column.Connector = table.column_indexOfColumn(column.Name);
            }
            int numBytes = table.row_count() * this.m_bytesAllocatedPerRow;
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
            for (int row = 0; row < table.row_count(); ++row) {
                int rowOffset = row * this.m_bytesAllocatedPerRow;
                for (Column column : this.m_columns) {
                    if (column.Connector < 0) continue;
                    int offset = rowOffset + column.Offset;
                    if (column.Type == DataType.Float) {
                        buffer.putFloat(offset, table.getFloat(row, column.Connector));
                    }
                    if (column.Type == DataType.Double) {
                        buffer.putDouble(offset, table.getDouble(row, column.Connector));
                    }
                    if (column.Type == DataType.Short) {
                        buffer.putInt(offset, table.getInt(row, column.Connector));
                    }
                    if (column.Type != DataType.Int) continue;
                    buffer.putInt(offset, table.getInt(row, column.Connector));
                }
            }
            this.m_creatorWriter.write(buffer.array(), 0, numBytes);
            this.m_rowCount += table.row_count();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    @Override
    public synchronized int appendEnsemble(Ensemble ensemble) throws Exception {
        try {
            if (this.m_creatorWriter == null) {
                throw new Exception("m_creatorWriter == null");
            }
            EnsembleHeaderDictionary dict = ensemble.dictionary();
            int indexTraceOkay = dict.addEntry("Temp", "Okay", DataType.Int);
            for (int row = 0; row < ensemble.traceCount(); ++row) {
                Column_Abstract header = ensemble.trace(row).header();
                header.putInt(indexTraceOkay, 1);
            }
            int numValidTraces = ensemble.traceCount();
            int indexShotID = -9999;
            int indexRecID = -9999;
            if (dict.containsEntry("Trace", "ShotID")) {
                indexShotID = dict.getEntryIndex("Trace", "ShotID");
            }
            if (dict.containsEntry("Trace", "ReceiverID")) {
                indexRecID = dict.getEntryIndex("Trace", "ReceiverID");
            }
            if (indexRecID >= 0 || indexShotID >= 0) {
                numValidTraces = 0;
                for (int row = 0; row < ensemble.traceCount(); ++row) {
                    Column_Abstract header = ensemble.trace(row).header();
                    int shotID = -9999;
                    int recID = -9999;
                    boolean shotOkay = true;
                    if (indexShotID >= 0) {
                        shotID = header.getInt(indexShotID);
                        shotOkay = shotID >= 1;
                    }
                    boolean recOkay = true;
                    if (indexRecID >= 0) {
                        recID = header.getInt(indexRecID);
                        boolean bl = recOkay = recID >= 1;
                    }
                    if (recOkay && shotOkay) {
                        ++numValidTraces;
                        continue;
                    }
                    header.putInt(indexTraceOkay, 0);
                }
            }
            if (numValidTraces < 1) {
                return 0;
            }
            for (Column column : this.m_columns) {
                column.Connector = -9999;
                if (!dict.containsEntry("Trace", column.Name)) continue;
                column.Connector = dict.getEntryIndex("Trace", column.Name);
            }
            int numBytes = numValidTraces * this.m_bytesAllocatedPerRow;
            ByteBuffer buffer = ByteBuffer_Shared.buffer(0, numBytes);
            int validIndex = 0;
            for (int row = 0; row < ensemble.traceCount(); ++row) {
                Column_Abstract header = ensemble.trace(row).header();
                if (header.getInt(indexTraceOkay) == 0) continue;
                int rowOffset = validIndex * this.m_bytesAllocatedPerRow;
                for (Column column : this.m_columns) {
                    if (column.Connector < 0) continue;
                    int offset = rowOffset + column.Offset;
                    if (column.Type == DataType.Float) {
                        float v = header.getFloat(column.Connector);
                        buffer.putFloat(offset, v);
                    }
                    if (column.Type == DataType.Double) {
                        buffer.putDouble(offset, header.getDouble(column.Connector));
                    }
                    if (column.Type == DataType.Short) {
                        int v = header.getInt(column.Connector);
                        buffer.putInt(offset, v);
                    }
                    if (column.Type != DataType.Int) continue;
                    int v = header.getInt(column.Connector);
                    buffer.putInt(offset, v);
                }
                ++validIndex;
            }
            this.m_creatorWriter.write(buffer.array(), 0, numBytes);
            this.m_rowCount += numValidTraces;
            return numValidTraces;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void createAppender() {
        try {
            if (this.m_creatorWriter != null) {
                return;
            }
            this.m_creatorWriter = new RandomAccessFile(this.m_dataFileName, "rw");
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void seekToEnd() {
        try {
            this.m_creatorWriter.seek(this.m_creatorWriter.length());
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public static class Column {
        public String Name;
        public DataType Type;
        public int Offset;
        public int Connector = -9999;
    }
}

