/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Data.Table_Memory;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Map.HashMap_Integer;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Shared.MemoryMonitor;
import com.PecosCore.Shared.Range_Double;
import com.PecosCore.Tools.Tools_FileSystem;
import com.PecosCore.Tools.Tools_XML;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class Table_Abstract {
    public int MouseMoveRow = -9999;
    public int MouseMoveID = -9999;
    public boolean MouseMoveChanged = false;
    public int SelectedRow = -9999;
    public int SelectedID = -9999;
    public static String FileSuffix = ".tbl";
    protected boolean m_bModifiedSinceLastSave = false;

    public synchronized void fillEnsemble(Ensemble ensemble) {
        try {
            for (int row = 0; row < this.row_count(); ++row) {
                ensemble.addTrace();
            }
            for (int col = 0; col < this.column_count(); ++col) {
                String colName = this.column_name(col);
                DataType type = this.column_type(col);
                int headerIndex = ensemble.dictionary().addEntry(this.name(), colName, type);
                for (int row = 0; row < this.row_count(); ++row) {
                    Column_Abstract header = ensemble.trace(row).header();
                    if (type == DataType.Double) {
                        header.putDouble(headerIndex, this.getDouble(row, col));
                    }
                    if (type == DataType.Float) {
                        header.putFloat(headerIndex, this.getFloat(row, col));
                    }
                    if (type == DataType.Int) {
                        header.putInt(headerIndex, this.getInt(row, col));
                    }
                    if (type == DataType.Short) {
                        header.putInt(headerIndex, this.getInt(row, col));
                    }
                    if (type == DataType.Bool) {
                        header.putBool(headerIndex, this.getBool(row, col));
                    }
                    if (type != DataType.Long) continue;
                    header.putLong(headerIndex, this.getLong(row, col));
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void populateFromEnsemble(Ensemble ensemble) {
        try {
            this.row_clear(false);
            for (int t = 0; t < ensemble.traceCount(); ++t) {
                this.row_increment();
            }
            String tableName = this.name();
            for (int col = 0; col < this.column_count(); ++col) {
                String colName = this.column_name(col);
                if (ensemble.dictionary().containsEntry(tableName, colName)) {
                    // empty if block
                }
                DataType type = ensemble.dictionary().getPreferredType(tableName, colName);
                int headerIndex = ensemble.dictionary().getEntryIndex(tableName, colName);
                for (int row = 0; row < ensemble.traceCount(); ++row) {
                    if (type == DataType.Int || type == DataType.Short) {
                        int v = ensemble.trace(row).header().getInt(headerIndex);
                        this.putInt(row, col, v);
                        continue;
                    }
                    if (type == DataType.Bool) {
                        boolean v = ensemble.trace(row).header().getBool(headerIndex);
                        this.putBool(row, col, v);
                        continue;
                    }
                    double v = ensemble.trace(row).header().getDouble(headerIndex);
                    this.putDouble(row, col, v);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized boolean selectNearestSpatialPoint_MouseMove(double x, double y) throws Exception {
        try {
            String colID = this.name() + "ID";
            if (!this.column_exists("Easting")) {
                throw new Exception("column_exists(Pecos.Easting) == false");
            }
            if (!this.column_exists("Northing")) {
                throw new Exception("column_exists(Pecos.Northing) == false");
            }
            if (!this.column_exists(colID)) {
                throw new Exception("column_exists(colID) == false");
            }
            if (this.row_count() < 1) {
                return false;
            }
            double nearestSquared = 1.0E40;
            double nx = 0.0;
            double ny = 0.0;
            int indexX = this.column_indexOfColumn("Easting");
            int indexY = this.column_indexOfColumn("Northing");
            int indexID = this.column_indexOfColumn(colID);
            int tempRow = -9999;
            for (int row = 0; row < this.row_count(); ++row) {
                double dx = x - this.getDouble(row, indexX);
                double dy = y - this.getDouble(row, indexY);
                double squared = Math.abs(dx) + Math.abs(dy);
                if (!(squared < nearestSquared)) continue;
                nearestSquared = squared;
                tempRow = row;
                nx = this.getDouble(row, indexX);
                ny = this.getDouble(row, indexY);
            }
            this.MouseMoveChanged = tempRow != this.MouseMoveRow;
            this.MouseMoveRow = tempRow;
            this.MouseMoveID = this.getInt(this.MouseMoveRow, indexID);
            if (this.MouseMoveChanged) {
                // empty if block
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static Table_Abstract make_dummy(String name, int rows) {
        try {
            Table_Memory t = new Table_Memory();
            ((Table_Abstract)t).setName(name);
            int colid = ((Table_Abstract)t).column_append(name + "ID", DataType.Int);
            int col1 = ((Table_Abstract)t).column_append("col1", DataType.Double);
            int col2 = ((Table_Abstract)t).column_append("col2", DataType.Double);
            int col3 = ((Table_Abstract)t).column_append("col3", DataType.Double);
            int col4 = ((Table_Abstract)t).column_append("col4", DataType.Double);
            int col5 = ((Table_Abstract)t).column_append("col5", DataType.Double);
            int col6 = ((Table_Abstract)t).column_append("col6", DataType.Double);
            int col7 = ((Table_Abstract)t).column_append("col7", DataType.Double);
            int col8 = ((Table_Abstract)t).column_append("col8", DataType.Double);
            for (int n = 0; n < rows; ++n) {
                int r = ((Table_Abstract)t).row_increment();
                ((Table_Abstract)t).putInt(r, colid, n);
                ((Table_Abstract)t).putDouble(r, col1, r * n);
                ((Table_Abstract)t).putDouble(r, col2, r * n);
                ((Table_Abstract)t).putDouble(r, col3, r * n);
                ((Table_Abstract)t).putDouble(r, col4, r * n);
                ((Table_Abstract)t).putDouble(r, col5, r * n);
            }
            return t;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    public synchronized boolean selectNearestSpatialPoint(double x, double y) throws Exception {
        try {
            this.SelectedRow = -9999;
            this.SelectedID = -9999;
            String colID = this.name() + "ID";
            if (!this.column_exists("Easting")) {
                throw new Exception("column_exists(Pecos.Easting) == false");
            }
            if (!this.column_exists("Northing")) {
                throw new Exception("column_exists(Pecos.Northing) == false");
            }
            if (!this.column_exists(colID)) {
                throw new Exception("column_exists(colID) == false");
            }
            if (this.row_count() < 1) {
                return false;
            }
            double nearestSquared = 1.0E40;
            int indexX = this.column_indexOfColumn("Easting");
            int indexY = this.column_indexOfColumn("Northing");
            int indexID = this.column_indexOfColumn(colID);
            for (int row = 0; row < this.row_count(); ++row) {
                double dy;
                double dx = x - this.getDouble(row, indexX);
                double squared = dx * dx + (dy = y - this.getDouble(row, indexY)) * dy;
                if (!(squared < nearestSquared)) continue;
                nearestSquared = squared;
                this.SelectedRow = row;
            }
            this.SelectedID = this.getInt(this.SelectedRow, indexID);
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public synchronized void exportCSV(String fileName, String filterColumn, double minValid, double maxValid) {
        BufferedWriter writer = null;
        try {
            int index = this.column_indexOfColumn(filterColumn);
            writer = new BufferedWriter(new FileWriter(fileName));
            for (int n = 0; n < this.column_count(); ++n) {
                if (n >= 1) {
                    writer.write(", ");
                }
                writer.write(this.column_name(n));
            }
            writer.newLine();
            for (int row = 0; row < this.row_count(); ++row) {
                double v = this.getDouble(row, index);
                if (!(v >= minValid) || !(v <= maxValid)) continue;
                for (int n = 0; n < this.column_count(); ++n) {
                    if (n >= 1) {
                        writer.write(", ");
                    }
                    writer.write(this.getString(row, n));
                }
                writer.newLine();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void importXML(String fileName) {
        try {
            this.column_removeAll();
            this.row_clear(true);
            if (!Tools_FileSystem.exists_file(fileName)) {
                return;
            }
            Document doc = Tools_XML.readDocument(fileName);
            Element root = (Element)doc.getFirstChild();
            String name = root.getAttribute("Name");
            this.setName(name);
            int rowCount = Integer.parseInt(root.getAttribute("RowCount"));
            this.row_countset(rowCount);
            ArrayList<Element> columnNodeList = Tools_XML.getChildListWithTagName(root, "Column");
            for (Element columnNode : columnNodeList) {
                String colName = columnNode.getAttribute("Name");
                String colTypeDesc = columnNode.getAttribute("Type");
                DataType type = DataType.typeFromDescription(colTypeDesc);
                int colIndex = this.column_append(colName, type);
                ArrayList<Element> rowNodeList = Tools_XML.getChildListWithTagName(columnNode, "Row");
                for (Element rowNode : rowNodeList) {
                    int rowIndex = Integer.parseInt(rowNode.getAttribute("Index"));
                    String v = rowNode.getAttribute("Value");
                    this.putString(rowIndex, colIndex, v);
                }
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void exportXML(String fileName) {
        try {
            boolean print = true;
            long used_bean = MemoryMonitor.singleton().used_bean();
            long used_run = MemoryMonitor.singleton().used_runtime();
            Document document = Tools_XML.createDocument();
            Element root = document.createElement("Table");
            document.appendChild(root);
            root.setAttribute("Name", this.name());
            root.setAttribute("RowCount", Integer.toString(this.row_count()));
            for (int n = 0; n < this.column_count(); ++n) {
                Element columnNode = root.getOwnerDocument().createElement("Column");
                root.appendChild(columnNode);
                columnNode.setAttribute("Name", this.column_name(n));
                columnNode.setAttribute("Type", this.column_type((int)n).Description);
                for (int r = 0; r < this.row_count(); ++r) {
                    Element rowNode = root.getOwnerDocument().createElement("Row");
                    columnNode.appendChild(rowNode);
                    rowNode.setAttribute("Index", Integer.toString(r));
                    rowNode.setAttribute("Value", this.getString(r, n));
                }
            }
            Tools_XML.writeDocumentToFile(document, fileName);
            if (print) {
                long used_bean2 = MemoryMonitor.singleton().used_bean();
                long used_run2 = MemoryMonitor.singleton().used_runtime();
                long bd = (used_bean2 - used_bean) / 1000000L;
                long rd = (used_run2 - used_run) / 1000000L;
                System.out.println("===========================> exportXML: " + this.name() + " beandiff " + bd + " rundiff " + rd);
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void exportCSV(String fileName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            for (int n = 0; n < this.column_count(); ++n) {
                if (n >= 1) {
                    writer.write(", ");
                }
                writer.write(this.column_name(n));
            }
            writer.newLine();
            for (int row = 0; row < this.row_count(); ++row) {
                for (int n = 0; n < this.column_count(); ++n) {
                    if (n >= 1) {
                        writer.write(", ");
                    }
                    writer.write(this.getString(row, n));
                }
                writer.newLine();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized void exportColumn(String fileName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(fileName));
            int maxWidth = 11;
            for (int n = 0; n < this.column_count(); ++n) {
                int len = this.column_name(n).length();
                maxWidth = Math.max(maxWidth, len);
            }
            maxWidth += 2;
            StringBuilder sb = new StringBuilder();
            for (int n = 0; n < this.column_count(); ++n) {
                int length = (n + 1) * maxWidth;
                sb.append(this.column_name(n));
                while (sb.length() < length) {
                    sb.append(" ");
                }
            }
            writer.write(sb.toString());
            writer.newLine();
            for (int row = 0; row < this.row_count(); ++row) {
                sb = new StringBuilder();
                for (int n = 0; n < this.column_count(); ++n) {
                    int length = (n + 1) * maxWidth;
                    sb.append(this.getString(row, n));
                    while (sb.length() < length) {
                        sb.append(" ");
                    }
                }
                writer.write(sb.toString());
                writer.newLine();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public synchronized int append(Table_Abstract table) {
        try {
            int rowCount = this.row_count();
            int[] index = new int[table.column_count()];
            for (int col = 0; col < table.column_count(); ++col) {
                String name = table.column_name(col);
                DataType type = table.column_type(col);
                index[col] = this.column_append(name, type);
            }
            for (int row = 0; row < table.row_count(); ++row) {
                int newRow = this.row_increment();
                for (int col = 0; col < table.column_count(); ++col) {
                    DataType type = table.column_type(col);
                    if (type == DataType.Bool) {
                        this.putBool(newRow, index[col], table.getBool(row, col));
                    }
                    if (type == DataType.Double) {
                        this.putDouble(newRow, index[col], table.getDouble(row, col));
                    }
                    if (type == DataType.Float) {
                        this.putFloat(newRow, index[col], table.getFloat(row, col));
                    }
                    if (type == DataType.Int) {
                        this.putInt(newRow, index[col], table.getInt(row, col));
                    }
                    if (type == DataType.Short) {
                        this.putInt(newRow, index[col], table.getInt(row, col));
                    }
                    if (type == DataType.Long) {
                        this.putLong(newRow, index[col], table.getLong(row, col));
                    }
                    if (type != DataType.Text) continue;
                    this.putString(newRow, index[col], table.getString(row, col));
                }
            }
            return rowCount;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return this.row_count();
        }
    }

    public boolean modifiedSinceLastSave() {
        return this.m_bModifiedSinceLastSave;
    }

    public abstract void saveBinary(String var1) throws Exception;

    public abstract void readBinary(String var1) throws Exception;

    public synchronized void saveToPath(String path) throws Exception {
        try {
            String fileName = path + "/" + this.name() + ".xml";
            this.exportXML(fileName);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public abstract HashMap_Integer createMapID() throws Exception;

    public abstract HashMap_Integer createMapTwoColumn(String var1, String var2) throws Exception;

    public abstract String name() throws Exception;

    public abstract void setName(String var1);

    public abstract void moveColumnsToUnusedStorage();

    public abstract void deleteColumnsInUnusedStorage();

    public abstract int traceHeader_getIndex(int var1) throws Exception;

    public abstract void traceHeader_setIndex(int var1, int var2) throws Exception;

    /*
     * Loose catch block
     */
    public synchronized boolean canConvertToDouble(int row, int column) {
        String s;
        block6: {
            if (column < 0) {
                return false;
            }
            s = this.getString(row, column);
            if (s.length() >= 1) break block6;
            return false;
            {
                catch (Exception ex) {
                    ExceptionMonitor.add(ex);
                    return false;
                }
            }
        }
        try {
            double v = Double.parseDouble(s);
            return true;
        }
        catch (Exception error) {
            return false;
        }
    }

    public synchronized boolean columnHasSingleValue(String colName) throws Exception {
        try {
            if (this.row_count() < 1) {
                return true;
            }
            int index = this.column_indexOfColumn(colName);
            int val = this.getInt(0, index);
            for (int row = 1; row < this.row_count(); ++row) {
                if (val == this.getInt(row, index)) continue;
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public abstract void putBool(int var1, int var2, boolean var3) throws Exception;

    public abstract boolean getBool(int var1, int var2) throws Exception;

    public abstract void putInt(int var1, int var2, int var3) throws Exception;

    public abstract int getInt(int var1, int var2) throws Exception;

    public abstract void putLong(int var1, int var2, long var3) throws Exception;

    public abstract long getLong(int var1, int var2) throws Exception;

    public abstract void putFloat(int var1, int var2, float var3) throws Exception;

    public abstract float getFloat(int var1, int var2) throws Exception;

    public abstract void putDouble(int var1, int var2, double var3) throws Exception;

    public abstract double getDouble(int var1, int var2) throws Exception;

    public abstract void putString(int var1, int var2, String var3) throws Exception;

    public abstract String getString(int var1, int var2) throws Exception;

    public abstract String getString(int var1, int var2, int var3) throws Exception;

    public abstract void column_copy_double(String var1, String var2) throws Exception;

    public abstract int column_count();

    public abstract boolean column_exists(String var1) throws Exception;

    public abstract int column_append(String var1, DataType var2) throws Exception;

    public abstract ArrayList<String> column_listOfNames() throws Exception;

    public abstract String column_name(int var1) throws Exception;

    public abstract DataType column_type(int var1) throws Exception;

    public abstract int column_indexOfColumn(String var1) throws Exception;

    public abstract void column_setToValue(int var1, double var2) throws Exception;

    public abstract void column_removeAll() throws Exception;

    public abstract void column_range(String var1, Range_Double var2) throws Exception;

    public abstract void row_countset(int var1) throws Exception;

    public abstract int row_count();

    public abstract void row_delete(int var1) throws Exception;

    public abstract void row_clearRowValues(int var1) throws Exception;

    public abstract int row_increment() throws Exception;

    public abstract void row_clear(boolean var1) throws Exception;

    protected class EnsembleConnector {
        public int EnsembleIndex;

        protected EnsembleConnector() {
        }
    }
}

