/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Seismic;

import com.PecosCore.Data.DataType;
import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.CompressedTrace;
import com.PecosCore.Ensemble.Ensemble;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Ensemble.Tools_Ensemble;
import com.PecosCore.Shared.ExceptionMonitor;
import com.PecosCore.Tools.Tools_FileSystem;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class SparseCmpGatherManager {
    protected String m_path;
    protected double m_spacing;
    protected double m_radius;
    public double MinOffset = 0.0;
    public double MaxOffset = 20000.0;
    protected int m_windowCount = 10;
    protected int m_samplesPerWindow = 10;
    protected int m_samplesPerTrace = 200;
    protected boolean m_firstTrace = true;
    protected ArrayList<CmpGather> m_cmpList = new ArrayList();
    public CmpGather SelectedCmpGather = null;
    public double SelectedX;
    public double SelectedY;
    public int SelectedIndex = 0;

    public SparseCmpGatherManager(String path) {
        try {
            this.m_path = path;
            this.scan();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public int size() {
        try {
            return this.m_cmpList.size();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0;
        }
    }

    public double getCmpX(int index) {
        try {
            return this.m_cmpList.get((int)index).X;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public double getCmpY(int index) {
        try {
            return this.m_cmpList.get((int)index).Y;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0;
        }
    }

    public boolean valid() {
        return this.m_cmpList.size() >= 1;
    }

    public boolean selectNearestCMP(double x, double y, Ensemble ensemble) {
        try {
            ensemble.clearTraces(false);
            this.SelectedCmpGather = null;
            if (this.m_cmpList.size() < 1) {
                return false;
            }
            double minDist = 1.0E40;
            CmpGather nearest = null;
            this.SelectedIndex = 0;
            for (int n = 0; n < this.m_cmpList.size(); ++n) {
                CmpGather cmp = this.m_cmpList.get(n);
                double dx = cmp.X - x;
                double dy = cmp.Y - y;
                double dsq = dx * dx + dy * dy;
                if (!(dsq < minDist)) continue;
                minDist = dsq;
                nearest = cmp;
                this.SelectedIndex = n;
            }
            String fileName = this.getFileName(nearest.IndexX, nearest.IndexY);
            this.SelectedCmpGather = new CmpGather(fileName, true);
            this.SelectedCmpGather.extractEnsemble(ensemble);
            this.SelectedX = this.SelectedCmpGather.X;
            this.SelectedY = this.SelectedCmpGather.Y;
            return true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.SelectedCmpGather = null;
            return false;
        }
    }

    public void next(Ensemble ensemble) {
        try {
            ensemble.clearTraces(false);
            this.SelectedCmpGather = null;
            if (this.m_cmpList.size() < 1) {
                return;
            }
            ++this.SelectedIndex;
            if (this.SelectedIndex >= this.m_cmpList.size()) {
                this.SelectedIndex = 0;
            }
            CmpGather nearest = this.m_cmpList.get(this.SelectedIndex);
            String fileName = this.getFileName(nearest.IndexX, nearest.IndexY);
            this.SelectedCmpGather = new CmpGather(fileName, true);
            this.SelectedCmpGather.extractEnsemble(ensemble);
            this.SelectedX = this.SelectedCmpGather.X;
            this.SelectedY = this.SelectedCmpGather.Y;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.SelectedCmpGather = null;
        }
    }

    public void prior(Ensemble ensemble) {
        try {
            ensemble.clearTraces(false);
            this.SelectedCmpGather = null;
            if (this.m_cmpList.size() < 1) {
                return;
            }
            --this.SelectedIndex;
            if (this.SelectedIndex < 0) {
                this.SelectedIndex = this.m_cmpList.size() - 1;
            }
            CmpGather nearest = this.m_cmpList.get(this.SelectedIndex);
            String fileName = this.getFileName(nearest.IndexX, nearest.IndexY);
            this.SelectedCmpGather = new CmpGather(fileName, true);
            this.SelectedCmpGather.extractEnsemble(ensemble);
            this.SelectedX = this.SelectedCmpGather.X;
            this.SelectedY = this.SelectedCmpGather.Y;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            this.SelectedCmpGather = null;
        }
    }

    public void scan() {
        try {
            this.m_cmpList.clear();
            File path = new File(this.m_path);
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getAbsolutePath();
                if (!files[i].isFile() || !fileName.endsWith("data")) continue;
                CmpGather cmp = new CmpGather(fileName, false);
                if (cmp.Valid) {
                    this.m_cmpList.add(cmp);
                    continue;
                }
                files[i].delete();
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected String getFileName(int indexX, int indexY) {
        try {
            return String.format("%s/CMP_%d_%d.data", this.m_path, indexX, indexY);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return null;
        }
    }

    public void prepare(double spacing, double radius) {
        try {
            this.m_cmpList.clear();
            this.SelectedCmpGather = null;
            this.m_firstTrace = true;
            File path = new File(this.m_path);
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile()) continue;
                files[i].delete();
            }
            this.m_spacing = spacing;
            this.m_radius = radius;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected CmpGather addCMP(double midX, double midY) throws Exception {
        try {
            int cmpIndexX = (int)Math.floor(0.5 + midX / this.m_spacing);
            int cmpIndexY = (int)Math.floor(0.5 + midY / this.m_spacing);
            for (CmpGather cmp : this.m_cmpList) {
                if (cmp.IndexX != cmpIndexX || cmp.IndexY != cmpIndexY) continue;
                return cmp;
            }
            CmpGather cmp = new CmpGather();
            cmp.IndexX = cmpIndexX;
            cmp.IndexY = cmpIndexY;
            cmp.X = (double)cmp.IndexX * this.m_spacing;
            cmp.Y = (double)cmp.IndexY * this.m_spacing;
            this.m_cmpList.add(cmp);
            return cmp;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void finishAppending() throws Exception {
        try {
            this.SelectedCmpGather = null;
            this.flush(true);
            for (CmpGather cmp : this.m_cmpList) {
                cmp.finishAppending();
            }
            this.scan();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void append(Ensemble ensemble) throws Exception {
        try {
            Tools_Ensemble.computeAzimuthAndOffset(ensemble);
            int indexShotID = ensemble.dictionary().getEntryIndex("Shot", "ShotID");
            int indexRecID = ensemble.dictionary().getEntryIndex("Receiver", "ReceiverID");
            int indexOffset = ensemble.dictionary().getEntryIndex("Trace", "Offset");
            int indexX = ensemble.dictionary().getEntryIndex("Trace", "CdpX");
            int indexY = ensemble.dictionary().getEntryIndex("Trace", "CdpY");
            int indexTraceIndex = ensemble.dictionary().getEntryIndex("Trace", "TraceIndex");
            float[] data = new float[10];
            for (int n = 0; n < ensemble.traceCount(); ++n) {
                FloatArrayWrapper wrapper;
                EnsembleTrace trace = ensemble.trace(n);
                double off = trace.header().getDouble(indexOffset);
                double tx = trace.header().getDouble(indexX);
                double ty = trace.header().getDouble(indexY);
                CmpGather cmp = this.addCMP(tx, ty);
                double dx = cmp.X - tx;
                double dy = cmp.Y - ty;
                if (!(Math.sqrt(dx * dx + dy * dy) < this.m_radius) || !(off >= this.MinOffset) || !(off <= this.MaxOffset) || (wrapper = trace.data()).length() <= 0) continue;
                if (this.m_firstTrace) {
                    this.m_firstTrace = false;
                    this.m_samplesPerTrace = wrapper.length();
                    this.m_windowCount = 1 + this.m_samplesPerTrace / this.m_samplesPerWindow;
                }
                if (data.length != wrapper.length()) {
                    data = new float[wrapper.length()];
                }
                wrapper.copyToArray(data);
                int shotID = trace.header().getInt(indexShotID);
                int recID = trace.header().getInt(indexRecID);
                long traceIndex = trace.header().getLong(indexTraceIndex);
                CompressedTrace ct = new CompressedTrace(shotID, recID, traceIndex, wrapper.getFirstSampleCoord_Initial(), wrapper.getSampleInterval(), this.m_windowCount, this.m_samplesPerWindow, data);
                cmp.Traces.add(ct);
            }
            this.flush(false);
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public void flush(boolean force) throws Exception {
        try {
            if (!force) {
                int count = 0;
                for (CmpGather cmp : this.m_cmpList) {
                    count += cmp.Traces.size();
                }
                if (count < 20000) {
                    return;
                }
            }
            for (CmpGather cmp : this.m_cmpList) {
                cmp.flush();
                cmp.finishAppending();
            }
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
            System.gc();
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            throw error;
        }
    }

    public class CmpGather {
        public double X;
        public double Y;
        public int IndexX;
        public int IndexY;
        public int TraceCount = 0;
        public ArrayList<CompressedTrace> Traces = new ArrayList();
        public boolean Valid = true;

        public CmpGather() {
        }

        public CmpGather(String fileName, boolean readTraces) {
            try {
                this.Valid = false;
                RandomAccessFile reader = new RandomAccessFile(fileName, "rw");
                int magic = reader.readInt();
                if (magic != 838383) {
                    reader.close();
                    return;
                }
                int version = reader.readInt();
                if (version != 1000) {
                    reader.close();
                    return;
                }
                this.TraceCount = reader.readInt();
                this.X = reader.readDouble();
                this.Y = reader.readDouble();
                this.IndexX = reader.readInt();
                this.IndexY = reader.readInt();
                if (readTraces) {
                    String msg = String.format("readTraces: (%d,%d)  total = %d", this.IndexX, this.IndexY, this.TraceCount);
                    System.out.println(msg);
                    for (int n = 0; n < this.TraceCount; ++n) {
                        long fileLength;
                        long filePointer = reader.getFilePointer();
                        if (filePointer < (fileLength = reader.length())) {
                            this.Traces.add(new CompressedTrace(reader));
                            continue;
                        }
                        System.out.println(String.format("Out of file %d %d", n, this.TraceCount));
                    }
                }
                reader.close();
                this.Valid = true;
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
                this.Valid = false;
            }
        }

        public void extractEnsemble(Ensemble ensemble) {
            try {
                ensemble.clearTraces(false);
                int indexShotID = ensemble.dictionary().addEntry("Trace", "ShotID", DataType.Int);
                int indexRecID = ensemble.dictionary().addEntry("Trace", "ReceiverID", DataType.Int);
                int indexTrace = ensemble.dictionary().addEntry("Trace", "TraceIndex", DataType.Long);
                float[] data = new float[10];
                for (CompressedTrace ct : this.Traces) {
                    EnsembleTrace trace = ensemble.addTrace();
                    trace.header().putInt(indexShotID, ct.ShotID);
                    trace.header().putInt(indexRecID, ct.ReceiverID);
                    trace.header().putLong(indexTrace, ct.TraceTableIndex);
                    if (ct.Data.length != data.length) {
                        data = new float[ct.Data.length];
                    }
                    ct.getData(data);
                    trace.data().insertArray(data, data.length);
                    trace.data().setFirstSampleCoord(ct.Time);
                    trace.data().setSampleInterval(ct.Digi);
                }
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void finishAppending() {
            try {
                int version = 1000;
                int magic = 838383;
                String fileName = SparseCmpGatherManager.this.getFileName(this.IndexX, this.IndexY);
                if (this.TraceCount < 1) {
                    if (Tools_FileSystem.exists_file(fileName)) {
                        Tools_FileSystem.deleteFile(fileName);
                    }
                    return;
                }
                RandomAccessFile writerNew = new RandomAccessFile(fileName, "rw");
                writerNew.writeInt(magic);
                writerNew.writeInt(version);
                writerNew.writeInt(this.TraceCount);
                writerNew.writeDouble(this.X);
                writerNew.writeDouble(this.Y);
                writerNew.writeInt(this.IndexX);
                writerNew.writeInt(this.IndexY);
                writerNew.close();
                String msg = String.format("finishAppending: (%d,%d)  total = %d  current = %d", this.IndexX, this.IndexY, this.TraceCount, this.Traces.size());
                System.out.println(msg);
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }

        public void flush() {
            try {
                if (this.Traces.size() < 1) {
                    return;
                }
                int version = 1000;
                int magic = 838383;
                String fileName = SparseCmpGatherManager.this.getFileName(this.IndexX, this.IndexY);
                if (!Tools_FileSystem.exists_file(fileName)) {
                    RandomAccessFile writerNew = new RandomAccessFile(fileName, "rw");
                    writerNew.writeInt(magic);
                    writerNew.writeInt(version);
                    writerNew.writeInt(this.TraceCount);
                    writerNew.writeDouble(this.X);
                    writerNew.writeDouble(this.Y);
                    writerNew.writeInt(this.IndexX);
                    writerNew.writeInt(this.IndexY);
                    writerNew.close();
                }
                File f = new File(fileName);
                RandomAccessFile writer = new RandomAccessFile(fileName, "rw");
                writer.seek(f.length());
                for (CompressedTrace ct : this.Traces) {
                    ct.write(writer);
                }
                writer.close();
                this.TraceCount += this.Traces.size();
                String msg = String.format("flush: (%d,%d)  total = %d  current = %d", this.IndexX, this.IndexY, this.TraceCount, this.Traces.size());
                System.out.println(msg);
                this.Traces.clear();
            }
            catch (Exception error) {
                ExceptionMonitor.add(error);
            }
        }
    }
}

