/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Seismic;

import com.PecosCore.Data.FloatArrayWrapper;
import com.PecosCore.Data.Seismic.ITraceInterpolator;
import com.PecosCore.Ensemble.EnsembleTrace;
import com.PecosCore.Shared.ExceptionMonitor;
import java.util.ArrayList;

public class CubicTraceInterpolator
implements ITraceInterpolator {
    protected float[] m_a = new float[30];
    protected float[] m_b = new float[30];
    protected float[] m_c = new float[30];
    protected float[] m_d = new float[30];
    protected float[] m_input = new float[30];
    protected float m_inputTime0;
    protected float m_inputDigi;
    protected boolean m_inputValid = false;
    protected float m_inverseInputDigi;
    protected float m_maxInputSampleIndex;
    protected static CubicTraceInterpolator m_singleton = null;
    protected float[] m_tempTraceArray = new float[20];
    protected ArrayList<Extrema> m_peakList = new ArrayList();
    protected int m_numPeaks = 0;
    protected ArrayList<Extrema> m_troughList = new ArrayList();
    protected int m_numTroughs = 0;

    public float[] input() {
        return this.m_input;
    }

    @Override
    public float inputTime0() {
        return this.m_inputTime0;
    }

    public void setInputTime0(float t0) {
        this.m_inputTime0 = t0;
    }

    @Override
    public float inputDigi() {
        return this.m_inputDigi;
    }

    public boolean inputValid() {
        return this.m_inputValid;
    }

    public static CubicTraceInterpolator singletonA() {
        try {
            if (m_singleton == null) {
                m_singleton = new CubicTraceInterpolator();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected void setInputValid(boolean valid) {
        this.m_inputValid = valid;
    }

    protected void setMaxInputSampleIndex(float maxInputSampleIndex) {
        this.m_maxInputSampleIndex = maxInputSampleIndex;
    }

    @Override
    public void copyToOther(ITraceInterpolator other) throws Exception {
        try {
            if (!(other instanceof CubicTraceInterpolator)) {
                throw new Exception("");
            }
            CubicTraceInterpolator cti = (CubicTraceInterpolator)other;
            cti.insertABCD(this.m_a, this.m_b, this.m_c, this.m_d);
            cti.setTimeAndDigi(this.m_inputTime0, this.m_inputDigi);
            cti.setInputValid(this.m_inputValid);
            cti.setMaxInputSampleIndex(this.m_maxInputSampleIndex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void setTimeAndDigi(float inputTime0, float inputDigi) throws Exception {
        try {
            this.m_inputTime0 = inputTime0;
            this.m_inputDigi = inputDigi;
            this.m_inverseInputDigi = 1.0f / inputDigi;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void insertABCD(float[] a, float[] b, float[] c, float[] d) {
        try {
            int N = a.length;
            if (this.m_a.length != N) {
                this.m_a = new float[N];
                this.m_b = new float[N];
                this.m_c = new float[N];
                this.m_d = new float[N];
            }
            System.arraycopy(a, 0, this.m_a, 0, N);
            System.arraycopy(b, 0, this.m_b, 0, N);
            System.arraycopy(c, 0, this.m_c, 0, N);
            System.arraycopy(d, 0, this.m_d, 0, N);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void prepareInput(EnsembleTrace trace) {
        try {
            this.m_inputValid = false;
            if (trace == null) {
                return;
            }
            FloatArrayWrapper wrapper = trace.data();
            if (wrapper.length() < 2) {
                return;
            }
            if (this.m_tempTraceArray.length <= wrapper.length()) {
                this.m_tempTraceArray = new float[100 + wrapper.length()];
            }
            wrapper.copyToArray(this.m_tempTraceArray);
            this.prepareInput(this.m_tempTraceArray, wrapper.getFirstSampleCoord_WithShifts(), wrapper.getSampleInterval());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void prepareInput(float[] input, float inputTime0, float inputDigi) {
        try {
            this.m_inputTime0 = inputTime0;
            this.m_inputDigi = inputDigi;
            this.m_inverseInputDigi = 1.0f / inputDigi;
            this.m_inputValid = false;
            if (input == null) {
                return;
            }
            if (input.length < 4) {
                return;
            }
            int N = input.length;
            this.m_maxInputSampleIndex = (float)(N - 1) - 0.001f;
            if (this.m_input.length < N) {
                this.m_input = new float[N + 50];
                this.m_a = new float[N + 50];
                this.m_b = new float[N + 50];
                this.m_c = new float[N + 50];
                this.m_d = new float[N + 50];
            }
            System.arraycopy(input, 0, this.m_input, 0, N);
            this.m_a[0] = input[0];
            this.m_b[0] = input[1] - input[0];
            this.m_c[0] = 0.0f;
            this.m_d[0] = 0.0f;
            this.m_a[N - 2] = input[N - 2];
            this.m_b[N - 2] = input[N - 1] - input[N - 2];
            this.m_c[N - 2] = 0.0f;
            this.m_d[N - 2] = 0.0f;
            float inverseSix = 0.16666667f;
            for (int n = 1; n < N - 2; ++n) {
                this.m_a[n] = input[n];
                this.m_c[n] = 0.5f * (input[n + 1] + input[n - 1]) - input[n];
                this.m_d[n] = (input[n + 2] - input[n - 1] + 3.0f * (input[n] - input[n + 1])) * inverseSix;
                this.m_b[n] = 0.5f * (input[n + 1] - input[n - 1]) - this.m_d[n];
            }
            this.m_inputValid = true;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    public void computeExtrema() {
        try {
            this.m_numTroughs = 0;
            this.m_numPeaks = 0;
            int maxIndex = (int)(this.m_maxInputSampleIndex - 0.5f);
            for (int n = 1; n < maxIndex; ++n) {
                Extrema e;
                double output;
                double second;
                double b = 2.0f * this.m_c[n];
                double a = 3.0f * this.m_d[n];
                double c = this.m_b[n];
                double fac = b * b - 4.0 * a * c;
                if (!(fac > 0.0) || !(Math.abs(a) > 0.0)) continue;
                double x = (-b + Math.sqrt(fac)) / (2.0 * a);
                if (x >= 0.0 && x <= 1.0) {
                    second = (double)(2.0f * this.m_c[n]) + (double)(6.0f * this.m_d[n]) * x;
                    output = (double)this.m_a[n] + x * (double)this.m_b[n] + x * x * (double)this.m_c[n] + x * x * x * (double)this.m_d[n];
                    if (second > 0.0 && output < 0.0) {
                        if (this.m_numTroughs >= this.m_troughList.size()) {
                            this.m_troughList.add(new Extrema());
                        }
                        e = this.m_troughList.get(this.m_numTroughs);
                        e.Amplitude = (float)output;
                        e.Time = this.m_inputTime0 + this.m_inputDigi * (float)((double)n + x);
                        ++this.m_numTroughs;
                    }
                    if (second < 0.0 && output > 0.0) {
                        if (this.m_numPeaks >= this.m_peakList.size()) {
                            this.m_peakList.add(new Extrema());
                        }
                        e = this.m_peakList.get(this.m_numPeaks);
                        e.Amplitude = (float)output;
                        e.Time = this.m_inputTime0 + this.m_inputDigi * (float)((double)n + x);
                        ++this.m_numPeaks;
                    }
                }
                if (!((x = (-b - Math.sqrt(fac)) / (2.0 * a)) >= 0.0) || !(x <= 1.0)) continue;
                second = (double)(2.0f * this.m_c[n]) + (double)(6.0f * this.m_d[n]) * x;
                output = (double)this.m_a[n] + x * (double)this.m_b[n] + x * x * (double)this.m_c[n] + x * x * x * (double)this.m_d[n];
                if (second > 0.0 && output < 0.0) {
                    if (this.m_numTroughs >= this.m_troughList.size()) {
                        this.m_troughList.add(new Extrema());
                    }
                    e = this.m_troughList.get(this.m_numTroughs);
                    e.Amplitude = (float)output;
                    e.Time = this.m_inputTime0 + this.m_inputDigi * (float)((double)n + x);
                    ++this.m_numTroughs;
                }
                if (!(second < 0.0) || !(output > 0.0)) continue;
                if (this.m_numPeaks >= this.m_peakList.size()) {
                    this.m_peakList.add(new Extrema());
                }
                e = this.m_peakList.get(this.m_numPeaks);
                e.Amplitude = (float)output;
                e.Time = this.m_inputTime0 + this.m_inputDigi * (float)((double)n + x);
                ++this.m_numPeaks;
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    @Override
    public float interpolate(float outputTime) throws Exception {
        try {
            if (!this.m_inputValid) {
                throw new Exception("m_inputValid == false");
            }
            float inputSampleIndex = (outputTime - this.m_inputTime0) * this.m_inverseInputDigi;
            if (inputSampleIndex >= 0.0f && inputSampleIndex < this.m_maxInputSampleIndex) {
                int i = (int)inputSampleIndex;
                float x = inputSampleIndex - (float)i;
                float output = this.m_a[i] + x * this.m_b[i] + x * x * this.m_c[i] + x * x * x * this.m_d[i];
                return output;
            }
            return 0.0f;
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
            return 0.0f;
        }
    }

    @Override
    public void interpolate(float[] output, float outputTime0, float outputDigi) {
        try {
            int n;
            for (n = 0; n < output.length; ++n) {
                output[n] = 0.0f;
            }
            if (!this.m_inputValid) {
                return;
            }
            for (n = 0; n < output.length; ++n) {
                output[n] = this.interpolate(outputTime0 + (float)n * outputDigi);
            }
        }
        catch (Exception error) {
            ExceptionMonitor.add(error);
        }
    }

    protected class Extrema {
        public float Amplitude;
        public float Time;

        protected Extrema() {
        }
    }
}

