/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.NumPy;

import com.PecosCore.Shared.ExceptionMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

public class NumPyExporter {
    protected int m_sampleCount;
    protected ArrayList<float[]> m_list = new ArrayList();
    protected int m_shotID;
    protected int m_receiverLine;
    protected String m_outputPath;

    public NumPyExporter(String outputPath) {
        this.m_outputPath = outputPath;
    }

    public void prep(int shotID, int receiverLine, int numSamples) {
        try {
            this.m_sampleCount = 3 + numSamples;
            this.m_shotID = shotID;
            this.m_receiverLine = receiverLine;
            this.m_list.clear();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void add(int index, float pick, float offset, float[] samples) {
        try {
            float[] trace = new float[this.m_sampleCount];
            trace[0] = index;
            trace[1] = pick;
            trace[2] = offset;
            for (int n = 0; n < samples.length; ++n) {
                trace[n + 3] = samples[n];
            }
            this.m_list.add(trace);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    public void finish() {
        try {
            boolean bOk;
            String filePath = this.m_outputPath + "S" + this.m_shotID + "RL" + this.m_receiverLine + ".npy";
            File file = new File(filePath);
            if (file.exists() && !(bOk = file.delete())) {
                throw new Exception("unable to delete : " + filePath);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel wChannel = fileOutputStream.getChannel();
            String magicString = "NUMPY";
            byte magicFirstByte = -109;
            byte[] magic = magicString.getBytes(StandardCharsets.UTF_8);
            byte major = 1;
            byte minor = 0;
            String descrString = "{'descr': 'Float32', ";
            byte[] descr = descrString.getBytes(StandardCharsets.UTF_8);
            String fortranString = "'fortran_order': False, ";
            byte[] fortran = fortranString.getBytes(StandardCharsets.UTF_8);
            String shapeString = "'shape': (" + this.m_list.size() + "," + this.m_sampleCount + "), }";
            byte[] shape = shapeString.getBytes(StandardCharsets.UTF_8);
            String endLine = "\n";
            byte[] endl = endLine.getBytes(StandardCharsets.UTF_8);
            int lengthPadding = 0;
            int bytesUsed = 1 + magic.length + 4 + descr.length + fortran.length + shape.length + endl.length;
            if (bytesUsed % 16 != 0) {
                lengthPadding = 16 - bytesUsed % 16;
            }
            byte[] headerLenByte = new byte[2];
            short headerLength = (short)(bytesUsed + lengthPadding - 10);
            headerLenByte[0] = (byte)headerLength;
            headerLenByte[1] = (byte)(headerLength >> 8);
            int fileSize = bytesUsed + lengthPadding + 4 * this.m_list.size() * this.m_sampleCount;
            ByteBuffer bb = ByteBuffer.allocate(fileSize);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            bb.put(magicFirstByte);
            bb.put(magic);
            bb.put(major);
            bb.put(minor);
            bb.put(headerLenByte);
            bb.put(descr);
            bb.put(fortran);
            bb.put(shape);
            if (lengthPadding > 0) {
                byte[] padding = new byte[lengthPadding];
                for (int i = 0; i < lengthPadding; ++i) {
                    padding[i] = 32;
                }
                bb.put(padding);
            }
            bb.put(endl);
            for (float[] trace : this.m_list) {
                for (int n = 0; n < trace.length; ++n) {
                    bb.putFloat(trace[n]);
                    if (!Float.isNaN(trace[n])) continue;
                    System.out.println("NaN at trace: " + trace[0] + "  sample: " + (n - 3));
                }
            }
            bb.flip();
            wChannel.write(bb);
            wChannel.close();
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }
}

