/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data.Model;

import com.PecosCore.Data.Model.Model3D_Profile;
import com.PecosCore.Shared.ExceptionMonitor;

public class Model3D_Profile_SimpleAnalysis {
    final float MAX_TIME = 1000000.0f;
    protected int m_lowerIndex;
    protected int m_upperIndex;
    protected float m_lowerWeight;
    protected float m_upperWeight;
    protected double[] m_lookupOffset = new double[10];
    protected double[] m_lookupAzimuth = new double[10];
    protected double[] m_lookupCos2 = new double[10];
    protected double[] m_lookupSin2 = new double[10];
    protected int[][] m_fromNodeZ = new int[3][3];
    protected int[][] m_fromNodeH = new int[3][3];
    protected Model3D_Profile m_profile;
    protected float[][] m_time;
    protected float[][] m_velZ;
    protected float[][] m_velH;
    protected float[][] m_slowZ;
    protected float[][] m_slowH;
    protected int m_numH;
    protected int m_numZ;
    protected double m_sizeH;
    protected double m_sizeZ;
    protected double m_originZ;
    protected int m_magicFromShot = -99;
    protected int m_magicFromInvalid = -999999;
    protected double m_minTime;
    protected boolean[] m_minimum;

    protected void prepZ(double z, boolean updateTimes) {
        try {
            if (z <= 0.0) {
                this.m_lowerIndex = 0;
                this.m_upperIndex = 0;
                this.m_lowerWeight = 1.0f;
                this.m_upperWeight = 0.0f;
                if (updateTimes) {
                    this.m_time[0][this.m_lowerIndex] = 0.0f;
                    this.m_time[0][this.m_upperIndex] = 0.0f;
                    this.m_fromNodeZ[0][this.m_lowerIndex] = this.m_magicFromShot;
                    this.m_fromNodeZ[0][this.m_upperIndex] = this.m_magicFromShot;
                    this.m_fromNodeH[0][this.m_lowerIndex] = this.m_magicFromShot;
                    this.m_fromNodeH[0][this.m_upperIndex] = this.m_magicFromShot;
                }
                return;
            }
            this.m_lowerIndex = (int)(z / this.m_sizeZ);
            if (this.m_lowerIndex >= this.m_numZ - 1) {
                this.m_lowerIndex = this.m_numZ - 1;
                this.m_upperIndex = this.m_numZ - 1;
                this.m_lowerWeight = 1.0f;
                this.m_upperWeight = 0.0f;
                if (updateTimes) {
                    this.m_time[0][this.m_lowerIndex] = 0.0f;
                    this.m_time[0][this.m_upperIndex] = 0.0f;
                    this.m_fromNodeZ[0][this.m_lowerIndex] = this.m_magicFromShot;
                    this.m_fromNodeZ[0][this.m_upperIndex] = this.m_magicFromShot;
                    this.m_fromNodeH[0][this.m_lowerIndex] = this.m_magicFromShot;
                    this.m_fromNodeH[0][this.m_upperIndex] = this.m_magicFromShot;
                }
                return;
            }
            this.m_upperIndex = this.m_lowerIndex + 1;
            double lowerZ = (double)this.m_lowerIndex * this.m_sizeZ;
            double upperZ = lowerZ + this.m_sizeZ;
            this.m_upperWeight = (float)((z - lowerZ) / this.m_sizeZ);
            this.m_lowerWeight = 1.0f - this.m_upperWeight;
            double vel = 0.5 * (double)(this.m_velZ[0][this.m_lowerIndex] + this.m_velZ[0][this.m_upperIndex]);
            if (updateTimes) {
                this.m_time[0][this.m_lowerIndex] = (float)((z - lowerZ) / vel);
                this.m_time[0][this.m_upperIndex] = (float)((upperZ - z) / vel);
                this.m_fromNodeZ[0][this.m_lowerIndex] = this.m_magicFromShot;
                this.m_fromNodeZ[0][this.m_upperIndex] = this.m_magicFromShot;
                this.m_fromNodeH[0][this.m_lowerIndex] = this.m_magicFromShot;
                this.m_fromNodeH[0][this.m_upperIndex] = this.m_magicFromShot;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public double minTime() {
        return this.m_minTime;
    }

    protected void prepFromArrays() {
        try {
            boolean sizeOK;
            boolean bl = sizeOK = this.m_fromNodeZ.length >= this.m_numH && this.m_fromNodeZ[0].length == this.m_numZ;
            if (!sizeOK) {
                this.m_fromNodeZ = new int[this.m_numH + 20][this.m_numZ];
                this.m_fromNodeH = new int[this.m_numH + 20][this.m_numZ];
            }
            for (int h = 0; h < this.m_fromNodeZ.length; ++h) {
                for (int z = 0; z < this.m_fromNodeZ[0].length; ++z) {
                    this.m_fromNodeZ[h][z] = this.m_magicFromInvalid;
                    this.m_fromNodeH[h][z] = this.m_magicFromInvalid;
                }
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    public void forward_method2(Model3D_Profile profile, double fromZ, double toZ) {
        try {
            double z1;
            int h;
            int n;
            int iz;
            fromZ -= profile.originZ();
            toZ -= profile.originZ();
            this.m_profile = profile;
            this.m_numH = this.m_profile.NumNodesH;
            this.m_numZ = this.m_profile.nodeCountZ();
            this.m_time = this.m_profile.getDataArray("Time");
            this.m_velZ = this.m_profile.getDataArray("VelocityZ");
            this.m_velH = this.m_profile.getDataArray("VelocityH");
            this.m_sizeH = this.m_profile.nodeSpacing();
            this.m_sizeZ = this.m_profile.nodeSpacing();
            this.m_originZ = this.m_profile.originZ();
            int sIndexZ = (int)(fromZ / this.m_sizeZ);
            int rIndexZ = (int)(toZ / this.m_sizeZ);
            this.prepFromArrays();
            double Dh = profile.offset();
            double Dz = fromZ - toZ;
            int maxIndexH = profile.maximumIndexH();
            double recX = Dh / this.m_sizeH;
            double recZ = toZ / this.m_sizeZ;
            for (int h2 = 0; h2 < this.m_numH; ++h2) {
                for (iz = 0; iz < this.m_numZ; ++iz) {
                    this.m_time[h2][iz] = 1000000.0f;
                }
            }
            this.m_slowZ = new float[this.m_numH][this.m_numZ];
            this.m_slowH = new float[this.m_numH][this.m_numZ];
            for (int ih = 0; ih < this.m_numH; ++ih) {
                for (iz = 0; iz < this.m_numZ; ++iz) {
                    this.m_slowH[ih][iz] = 1.0f / this.m_velH[ih][iz];
                    this.m_slowZ[ih][iz] = 1.0f / this.m_velZ[ih][iz];
                }
            }
            this.prepZ(fromZ, true);
            for (n = this.m_lowerIndex - 1; n >= 0; --n) {
                this.m_time[0][n] = this.m_time[0][n + 1] + (float)this.m_sizeZ / this.m_velZ[0][n];
            }
            for (n = this.m_upperIndex + 1; n < this.m_numZ; ++n) {
                this.m_time[0][n] = this.m_time[0][n - 1] + (float)this.m_sizeZ / this.m_velZ[0][n];
            }
            int initColumn = 5;
            for (h = 1; h < initColumn; ++h) {
                double vz = this.m_lowerWeight * this.m_velZ[0][this.m_lowerIndex] + this.m_upperWeight * this.m_velZ[0][this.m_upperIndex];
                double vh = this.m_lowerWeight * this.m_velH[0][this.m_lowerIndex] + this.m_upperWeight * this.m_velH[0][this.m_upperIndex];
                for (int iz1 = 0; iz1 < this.m_numZ; ++iz1) {
                    double vz1 = this.m_velZ[h][iz1];
                    double vh1 = this.m_velH[h][iz1];
                    z1 = (double)iz1 * this.m_sizeZ;
                    double dz = z1 - fromZ;
                    double dx = (double)h * this.m_sizeH;
                    this.m_time[h][iz1] = (float)Math.sqrt(dx * dx / (vh1 * vh1) + dz * dz / (vz1 * vz1));
                }
            }
            this.m_minimum = new boolean[this.m_numZ];
            for (h = initColumn; h < this.m_numH; ++h) {
                int step;
                int n2;
                int topC = Math.max(1, sIndexZ - h);
                int botC = Math.min(this.m_numZ - 2, sIndexZ + h);
                float[] priorTime = this.m_time[h - 1];
                for (n2 = 0; n2 <= this.m_numZ - 1; ++n2) {
                    this.m_minimum[n2] = false;
                }
                for (n2 = topC; n2 <= botC; ++n2) {
                    if (!(priorTime[n2] <= priorTime[n2 + 1]) || !(priorTime[n2] <= priorTime[n2 - 1]) || priorTime[n2] == 1000000.0f) continue;
                    this.m_minimum[n2] = true;
                    this.computeMinima(h, n2);
                }
                for (n2 = 0; n2 < this.m_numZ; ++n2) {
                    if (!this.m_minimum[n2]) continue;
                    step = 1;
                    while (priorTime[n2 + step] > priorTime[n2 + step - 1] && n2 + step < this.m_numZ - 1) {
                        this.updateCorner(h, n2 + step, -1);
                        ++step;
                    }
                }
                for (n2 = this.m_numZ - 1; n2 >= 0; --n2) {
                    if (!this.m_minimum[n2]) continue;
                    step = 1;
                    while (!this.m_minimum[n2 - step] && n2 - step > 0) {
                        this.updateCorner(h, n2 - step, 1);
                        ++step;
                    }
                }
            }
            double x = recX;
            double z = recZ;
            double x0 = maxIndexH;
            double x1 = x0 + 1.0;
            double z0 = rIndexZ;
            z1 = z0 + 1.0;
            double t00 = this.m_time[maxIndexH][rIndexZ];
            double t10 = this.m_time[maxIndexH + 1][rIndexZ];
            double t01 = this.m_time[maxIndexH][rIndexZ + 1];
            double t11 = this.m_time[maxIndexH + 1][rIndexZ + 1];
            double denom = (x1 - x0) * (z1 - z0);
            double tRec = t00 * (x1 - x) * (z1 - z) + t10 * (x - x0) * (z1 - z) + t01 * (x1 - x) * (z - z0) + t11 * (x - x0) * (z - z0);
            this.m_minTime = tRec /= denom;
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }

    protected void updateCorner(int x, int z, int dz) throws Exception {
        try {
            double sHave = 0.25 * (double)(this.m_slowH[x - 1][z] + this.m_slowH[x][z] + this.m_slowH[x][z + dz] + this.m_slowH[x - 1][z + dz]);
            double sZave = 0.25 * (double)(this.m_slowZ[x - 1][z] + this.m_slowZ[x][z] + this.m_slowZ[x][z + dz] + this.m_slowZ[x - 1][z + dz]);
            double S1 = sHave * sHave + sZave * sZave;
            double S2 = sHave * sHave - sZave * sZave;
            double S3 = 2.0 * sHave * sZave;
            double t0 = this.m_time[x - 1][z + dz];
            double t1 = this.m_time[x][z + dz];
            double t2 = this.m_time[x - 1][z];
            double rad = this.m_sizeH * this.m_sizeH * S1 - Math.pow(t2 - t1, 2.0);
            if (rad > 0.0) {
                float temp = (float)(t0 + S2 / S1 * (t1 - t2) + S3 / S1 * Math.sqrt(rad));
                this.m_time[x][z] = Math.min(temp, this.m_time[x][z]);
                return;
            }
            double tv = t1 + this.m_sizeZ * 0.5 * (double)(this.m_slowZ[x][z] + this.m_slowZ[x][z + dz]);
            double th = t2 + this.m_sizeH * 0.5 * (double)(this.m_slowH[x][z] + this.m_slowH[x - 1][z]);
            double td = t0 + Math.sqrt(sHave * sHave * this.m_sizeH * this.m_sizeH + sZave * sZave * this.m_sizeZ * this.m_sizeZ);
            double temp = Math.min(td, Math.min(tv, th));
            this.m_time[x][z] = (float)Math.min(temp, (double)this.m_time[x][z]);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected void computeMinima(int x, int z) throws Exception {
        try {
            if (z == 0) {
                double sHave = 0.5 * (double)(this.m_slowH[x - 1][z] + this.m_slowH[x][z]);
                double sZave = 0.5 * (double)(this.m_slowH[x][z] + this.m_slowH[x][z + 1]);
                double ttH = sHave * this.m_sizeH;
                double ttZ = sZave * this.m_sizeZ;
                this.m_time[x][z] = (float)((double)this.m_time[x - 1][z] + ttH);
                double dt2H = Math.pow(sHave * ttH, 2.0);
                double dt2Z = Math.pow(sZave * ttZ, 2.0);
                double dtDiag = Math.sqrt(Math.pow(dt2H, 2.0) + Math.pow(dt2Z, 2.0));
                double temp = (double)this.m_time[x - 1][z + 1] + dtDiag;
                this.m_time[x][z] = (float)Math.min((double)this.m_time[x][z], temp);
                return;
            }
            if (z == this.m_numZ - 1) {
                double sHave = 0.5 * (double)(this.m_slowH[x - 1][z] + this.m_slowH[x][z]);
                double sZave = 0.5 * (double)(this.m_slowH[x][z] + this.m_slowH[x][z - 1]);
                double ttH = sHave * this.m_sizeH;
                double ttZ = sZave * this.m_sizeZ;
                this.m_time[x][z] = (float)((double)this.m_time[x - 1][z] + ttH);
                double dt2H = Math.pow(sHave * ttH, 2.0);
                double dt2Z = Math.pow(sZave * ttZ, 2.0);
                double dtDiag = Math.sqrt(Math.pow(dt2H, 2.0) + Math.pow(dt2Z, 2.0));
                double temp = (double)this.m_time[x - 1][z - 1] + dtDiag;
                this.m_time[x][z] = (float)Math.min((double)this.m_time[x][z], temp);
                return;
            }
            double sHave = 0.25 * (double)(this.m_slowH[x - 1][z] + this.m_slowH[x][z] + this.m_slowH[x - 1][z - 1] + this.m_slowH[x][z - 1]);
            double sZave = 0.25 * (double)(this.m_slowZ[x - 1][z] + this.m_slowZ[x][z] + this.m_slowZ[x - 1][z - 1] + this.m_slowZ[x][z - 1]);
            double t1 = this.m_time[x - 1][z + 1];
            double t2 = this.m_time[x - 1][z - 1];
            double rad = Math.pow(this.m_sizeH * sHave, 2.0) - 0.25 * Math.pow(t2 - t1, 2.0) * Math.pow(sHave / sZave, 2.0);
            if (rad < 0.0) {
                double temp = 0.5 * this.m_sizeH * (double)(this.m_slowH[x - 1][z] + this.m_slowH[x][z]);
                this.m_time[x][z] = (float)((double)this.m_time[x - 1][z] + temp);
                return;
            }
            this.m_time[x][z] = (float)((double)this.m_time[x - 1][z] + Math.sqrt(rad));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public void forward_method1(Model3D_Profile profile, double fromZ, double toZ) {
        try {
            int n;
            fromZ -= profile.originZ();
            toZ -= profile.originZ();
            this.m_profile = profile;
            this.m_numH = this.m_profile.NumNodesH;
            this.m_numZ = this.m_profile.nodeCountZ();
            this.m_time = this.m_profile.getDataArray("Time");
            this.m_velZ = this.m_profile.getDataArray("VelocityZ");
            this.m_velH = this.m_profile.getDataArray("VelocityH");
            this.m_sizeH = this.m_profile.nodeSpacing();
            this.m_sizeZ = this.m_profile.nodeSpacing();
            this.m_originZ = this.m_profile.originZ();
            double tempz = this.m_sizeH * Math.abs(fromZ - toZ) / (profile.offset() + this.m_sizeZ);
            int numZ = 10 + (int)(tempz / this.m_sizeZ);
            numZ = Math.min(numZ, this.m_numZ / 3);
            this.prepFromArrays();
            for (int h = 0; h < this.m_numH; ++h) {
                for (int iz = 0; iz < this.m_numZ; ++iz) {
                    this.m_time[h][iz] = 1.0E7f;
                }
            }
            if (this.m_lookupOffset.length < this.m_numZ) {
                this.m_lookupOffset = new double[this.m_numZ + 10];
                this.m_lookupAzimuth = new double[this.m_numZ + 10];
                this.m_lookupCos2 = new double[this.m_numZ + 10];
                this.m_lookupSin2 = new double[this.m_numZ + 10];
            }
            for (int iz = 0; iz < this.m_numZ; ++iz) {
                for (int ih = 0; ih < this.m_numH; ++ih) {
                    this.m_time[ih][iz] = 100000.0f;
                }
            }
            for (n = 0; n < this.m_lookupOffset.length; ++n) {
                double dz = (double)n * this.m_sizeZ;
                this.m_lookupOffset[n] = Math.sqrt(dz * dz + this.m_sizeH * this.m_sizeH);
                this.m_lookupAzimuth[n] = Math.atan2(dz, this.m_sizeH);
                this.m_lookupCos2[n] = Math.cos(this.m_lookupAzimuth[n]) * Math.cos(this.m_lookupAzimuth[n]);
                this.m_lookupSin2[n] = Math.sin(this.m_lookupAzimuth[n]) * Math.sin(this.m_lookupAzimuth[n]);
            }
            this.prepZ(fromZ, true);
            for (n = this.m_lowerIndex - 1; n >= 0; --n) {
                this.m_time[0][n] = this.m_time[0][n + 1] + (float)this.m_sizeZ / this.m_velZ[0][n];
            }
            for (n = this.m_upperIndex + 1; n < this.m_numZ; ++n) {
                this.m_time[0][n] = this.m_time[0][n - 1] + (float)this.m_sizeZ / this.m_velZ[0][n];
            }
            double vz = this.m_lowerWeight * this.m_velZ[0][this.m_lowerIndex] + this.m_upperWeight * this.m_velZ[0][this.m_upperIndex];
            double vh = this.m_lowerWeight * this.m_velH[0][this.m_lowerIndex] + this.m_upperWeight * this.m_velH[0][this.m_upperIndex];
            for (int iz1 = 0; iz1 < this.m_numZ; ++iz1) {
                double vz1 = this.m_velZ[1][iz1];
                double vh1 = this.m_velH[1][iz1];
                double z1 = (double)iz1 * this.m_sizeZ;
                double dz = z1 - fromZ;
                double offset = Math.sqrt(dz * dz + this.m_sizeH * this.m_sizeH);
                double azimuth = Math.atan2(dz, this.m_sizeH);
                double cos = Math.cos(azimuth);
                double sin = Math.sin(azimuth);
                double vs = Math.sqrt(cos * cos * vh * vh + sin * sin * vz * vz);
                double v1 = Math.sqrt(cos * cos * vh1 * vh1 + sin * sin * vz1 * vz1);
                double v = 0.5 * (vs + v1);
                this.m_time[1][iz1] = (float)(offset / v);
                this.m_fromNodeZ[1][iz1] = this.m_magicFromShot;
                this.m_fromNodeH[1][iz1] = this.m_magicFromShot;
            }
            for (int h = 1; h < this.m_numH; ++h) {
                for (int iz1 = 0; iz1 < this.m_numZ; ++iz1) {
                    int minZ = Math.max(0, iz1 - numZ);
                    int maxZ = Math.min(this.m_numZ - 1, iz1 + numZ);
                    double vz1 = this.m_velZ[h][iz1];
                    double vh1 = this.m_velH[h][iz1];
                    for (int iz2 = minZ; iz2 <= maxZ; ++iz2) {
                        double vz2 = this.m_velZ[h - 1][iz2];
                        double vh2 = this.m_velH[h - 1][iz2];
                        int dz = Math.abs(iz1 - iz2);
                        double offset = this.m_lookupOffset[dz];
                        double cos2 = this.m_lookupCos2[dz];
                        double sin2 = this.m_lookupSin2[dz];
                        double v1 = Math.sqrt(cos2 * vh1 * vh1 + sin2 * vz1 * vz1);
                        double v2 = Math.sqrt(cos2 * vh2 * vh2 + sin2 * vz2 * vz2);
                        double v = 0.5 * (v2 + v1);
                        float t = this.m_time[h - 1][iz2] + (float)(offset / v);
                        if (!(t < this.m_time[h][iz1])) continue;
                        this.m_time[h][iz1] = t;
                        this.m_fromNodeZ[h][iz1] = iz2;
                        this.m_fromNodeH[h][iz1] = h - 1;
                    }
                }
            }
            int maxIndexH = profile.maximumIndexH();
            this.prepZ(toZ, false);
            vz = this.m_lowerWeight * this.m_velZ[maxIndexH][this.m_lowerIndex] + this.m_upperWeight * this.m_velZ[maxIndexH][this.m_upperIndex];
            vh = this.m_lowerWeight * this.m_velH[maxIndexH][this.m_lowerIndex] + this.m_upperWeight * this.m_velH[maxIndexH][this.m_upperIndex];
            this.m_minTime = 1.0E7;
            int minNodeZ = 0;
            for (int iz1 = 0; iz1 < this.m_numZ; ++iz1) {
                double v1;
                double sin;
                double azimuth;
                double cos;
                double vs;
                double v;
                double vz1 = this.m_velZ[maxIndexH][iz1];
                double vh1 = this.m_velH[maxIndexH][iz1];
                double z1 = (double)iz1 * this.m_sizeZ;
                double dz = z1 - toZ;
                double offset = Math.sqrt(dz * dz + this.m_sizeH * this.m_sizeH);
                double time = (double)this.m_time[maxIndexH][iz1] + offset / (v = 0.5 * ((vs = Math.sqrt((cos = Math.cos(azimuth = Math.atan2(dz, this.m_sizeH))) * cos * vh * vh + (sin = Math.sin(azimuth)) * sin * vz * vz)) + (v1 = Math.sqrt(cos * cos * vh1 * vh1 + sin * sin * vz1 * vz1))));
                if (!(time < this.m_minTime)) continue;
                this.m_minTime = time;
                minNodeZ = iz1;
            }
        }
        catch (Exception error) {
            error.printStackTrace();
        }
    }
}

