/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Data.ByteBuffer_Shared;
import com.PecosCore.Data.Column_Abstract;
import com.PecosCore.Data.DataType;
import com.PecosCore.Shared.ExceptionMonitor;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Column_Bool
extends Column_Abstract
implements Serializable {
    protected boolean[] m_data = new boolean[100];

    public Column_Bool() {
    }

    @Override
    public String uniqueID() {
        return "Column_Bool";
    }

    public Column_Bool(String name) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            this.m_data = new boolean[100];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public Column_Bool(String name, int minLength) throws Exception {
        try {
            if (name.length() < 1) {
                throw new Exception("name cannot be zero length");
            }
            this.m_name = name;
            int len = Math.max(100, minLength + 100);
            this.m_data = new boolean[len];
            this.clearModificationFlag();
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void sort(int count) {
    }

    @Override
    public void save(RandomAccessFile writer) throws Exception {
        try {
            writer.writeInt(92876464);
            writer.writeInt(1000);
            writer.writeUTF(this.m_name);
            writer.writeInt(this.m_data.length);
            int numBytes = 2 * this.m_data.length;
            ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
            for (int n = 0; n < this.m_data.length; ++n) {
                if (this.m_data[n]) {
                    buff.putShort((short)1);
                    continue;
                }
                buff.putShort((short)0);
            }
            writer.write(buff.array(), 0, numBytes);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void read(RandomAccessFile reader) throws Exception {
        block5: {
            try {
                int magic = reader.readInt();
                if (magic != 92876464) {
                    throw new Exception("magic != Magic");
                }
                int version = reader.readInt();
                if (version == 1000) {
                    this.m_name = reader.readUTF();
                    int len = reader.readInt();
                    this.m_data = new boolean[len];
                    int numBytes = 2 * len;
                    ByteBuffer buff = ByteBuffer_Shared.buffer(0, numBytes);
                    reader.read(buff.array(), 0, numBytes);
                    for (int n = 0; n < this.m_data.length; ++n) {
                        this.m_data[n] = buff.getShort() != 0;
                    }
                    break block5;
                }
                throw new Exception("unrecognized version");
            }
            catch (Exception ex) {
                ExceptionMonitor.add(ex);
                throw ex;
            }
        }
    }

    @Override
    public Column_Abstract createExactCopy() {
        try {
            Column_Bool col = new Column_Bool(this.m_name, this.m_data.length);
            for (int n = 0; n < this.m_data.length; ++n) {
                col.putBool(n, this.m_data[n]);
            }
            col.clearModificationFlag();
            return col;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            return null;
        }
    }

    @Override
    public DataType type() {
        return DataType.Bool;
    }

    protected void resize(int row) throws Exception {
        try {
            if (row < this.m_data.length) {
                return;
            }
            int newLength = row + this.m_data.length / 2;
            boolean[] tempArray = Arrays.copyOf(this.m_data, newLength);
            for (int n = this.m_data.length; n < newLength; ++n) {
                tempArray[n] = false;
            }
            this.m_data = null;
            this.m_data = tempArray;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void remove(int row) {
        try {
            for (int n = row; n < this.m_data.length - 1; ++n) {
                this.m_data[n] = this.m_data[n + 1];
            }
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
        }
    }

    @Override
    public void putBool(int row, boolean value) throws Exception {
        try {
            this.resize(row);
            this.m_data[row] = value;
            this.setModified(row);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public boolean getBool(int row) throws Exception {
        try {
            this.resize(row);
            return this.m_data[row];
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putLong(int row, long value) throws Exception {
        try {
            this.putBool(row, value != 0L);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public long getLong(int row) throws Exception {
        try {
            if (this.getBool(row)) {
                return 1L;
            }
            return 0L;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putInt(int row, int value) throws Exception {
        try {
            this.putBool(row, value != 0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public int getInt(int row) throws Exception {
        try {
            if (this.getBool(row)) {
                return 1;
            }
            return 0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putFloat(int row, float value) throws Exception {
        try {
            this.putBool(row, value != 0.0f);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public float getFloat(int row) throws Exception {
        try {
            if (this.getBool(row)) {
                return 1.0f;
            }
            return 0.0f;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putDouble(int row, double value) throws Exception {
        try {
            this.putBool(row, value != 0.0);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public double getDouble(int row) throws Exception {
        try {
            if (this.getBool(row)) {
                return 1.0;
            }
            return 0.0;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putString(int row, String value) throws Exception {
        try {
            boolean v = Boolean.parseBoolean(value);
            this.putBool(row, v);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public String getString(int row, int numDecimals) throws Exception {
        return this.getString(row);
    }

    @Override
    public String getString(int row) throws Exception {
        try {
            return Boolean.toString(this.getBool(row));
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    @Override
    public void putIntArray(int row, int[] iVals) {
    }

    @Override
    public int[] getIntArray(int row) {
        return null;
    }

    @Override
    public void putFloatArray(int row, float[] fVals) {
    }

    @Override
    public float[] getFloatArray(int row) {
        return null;
    }

    public int getArrayLength() {
        return 0;
    }
}

