/*
 * Decompiled with CFR 0.152.
 */
package com.PecosCore.Data;

import com.PecosCore.Shared.ExceptionMonitor;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ByteBuffer_Shared {
    protected ArrayList<ByteBuffer> m_buffers = new ArrayList();
    protected static ByteBuffer_Shared m_singleton = null;

    protected ByteBuffer_Shared() {
    }

    public static ByteBuffer_Shared singleton() throws Exception {
        try {
            if (m_singleton == null) {
                m_singleton = new ByteBuffer_Shared();
            }
            return m_singleton;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    public static ByteBuffer buffer(int bufferIndex, int minimumCapacity) throws Exception {
        try {
            return ByteBuffer_Shared.singleton().getBuffer(bufferIndex, minimumCapacity);
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }

    protected ByteBuffer getBuffer(int bufferIndex, int minimumCapacity) throws Exception {
        try {
            if (bufferIndex < 0) {
                throw new Exception("(bufferIndex < 0)");
            }
            minimumCapacity = Math.max(minimumCapacity, 10000000);
            while (bufferIndex >= this.m_buffers.size()) {
                this.m_buffers.add(ByteBuffer.allocate(minimumCapacity));
            }
            ByteBuffer currentBuffer = this.m_buffers.get(bufferIndex);
            if (currentBuffer.capacity() < minimumCapacity) {
                ByteBuffer newBuff = ByteBuffer.allocate(minimumCapacity + 1000000);
                this.m_buffers.set(bufferIndex, newBuff);
                currentBuffer = null;
                System.gc();
            }
            currentBuffer = this.m_buffers.get(bufferIndex);
            ((Buffer)currentBuffer).clear();
            return currentBuffer;
        }
        catch (Exception ex) {
            ExceptionMonitor.add(ex);
            throw ex;
        }
    }
}

