/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.wavelet;

import java.util.Random;
import java.util.logging.Logger;
import org.javaseis.util.Almost;

public class WaveletTransform {
    private static final Logger LOG = Logger.getLogger("org.javaseis.wavelet");
    public static final int FORWARD = 1;
    public static final int REVERSE = -1;
    private int _transformLength;
    private float[] _scratch;
    private int _direction;
    private int _nLevels;

    private static float DOTP_H1(float[] data, int index) {
        return (data[index] + data[index + 6]) * 0.06453888f + (data[index + 1] + data[index + 5]) * -0.040689416f + (data[index + 2] + data[index + 4]) * -0.41809228f + data[index + 3] * 0.7884856f;
    }

    private static float DOTP_H0(float[] data, int index) {
        return (data[index] + data[index + 8]) * 0.037828457f + (data[index + 1] + data[index + 7]) * -0.023849465f + (data[index + 2] + data[index + 6]) * -0.1106244f + (data[index + 3] + data[index + 5]) * 0.37740284f + data[index + 4] * 0.8526987f;
    }

    private static float DOTP_EVENF1(float[] data, int index) {
        return (data[index - 2] + data[index + 2]) * 0.037828457f + (data[index - 1] + data[index + 1]) * -0.1106244f + data[index] * 0.8526987f;
    }

    private static float DOTP_EVENF0(float[] data, int index) {
        return (data[index - 2] + data[index + 1]) * -0.06453888f + (data[index - 1] + data[index]) * 0.41809228f;
    }

    private static float DOTP_ODDF1(float[] data, int index) {
        return (data[index - 1] + data[index + 2]) * 0.023849465f + (data[index] + data[index + 1]) * -0.37740284f;
    }

    private static float DOTP_ODDF0(float[] data, int index) {
        return (data[index - 1] + data[index + 1]) * -0.040689416f + data[index] * 0.7884856f;
    }

    public static int getTransformLength(int nSamples, int nLevels) {
        if (nSamples < 1) {
            throw new IllegalArgumentException("nSamples must be at least 1");
        }
        if (nLevels < 1) {
            throw new IllegalArgumentException("nLevels must be at least 1");
        }
        int minSegment = (int)Math.round(Math.pow(2.0, nLevels));
        int nSegments = nSamples / minSegment;
        if (nSegments * minSegment < nSamples) {
            ++nSegments;
        }
        return nSegments * minSegment;
    }

    public WaveletTransform(int direction, int nSamples, int nLevels) {
        if (nLevels < 1) {
            throw new IllegalArgumentException("nLevels must be at least 1");
        }
        this._direction = direction;
        this._nLevels = nLevels;
        this._transformLength = WaveletTransform.getTransformLength(nSamples, nLevels);
        this._scratch = new float[this._transformLength + 8];
    }

    public void transform1D(float[] y) {
        this.privateTransform1D(y, this._transformLength);
    }

    private void privateTransform1D_OBSOLETE(float[] y, int transformLength) {
        if (transformLength < 2) {
            throw new IllegalArgumentException("transformLength must be at least 2");
        }
        int minSegment = (int)Math.round(Math.pow(2.0, this._nLevels));
        if (transformLength % minSegment != 0) {
            throw new IllegalArgumentException("Length must be a multiple of " + minSegment + " for nLevels of " + this._nLevels + " (not " + transformLength + ")");
        }
        if (this._direction > 0) {
            int nCalls = 1;
            int length = transformLength;
            for (int j = 0; j < this._nLevels; ++j) {
                int index = 0;
                for (int i = 0; i < nCalls; ++i) {
                    this.biOrthogonalTransform(y, index, length, this._direction);
                    index += length;
                }
                nCalls *= 2;
                length /= 2;
            }
        } else {
            int nCalls = (int)Math.round(Math.pow(2.0, this._nLevels - 1));
            if (this._nLevels == 1) assert (nCalls == 1);
            int length = transformLength / minSegment * 2;
            for (int j = 0; j < this._nLevels; ++j) {
                int index = 0;
                for (int i = 0; i < nCalls; ++i) {
                    this.biOrthogonalTransform(y, index, length, this._direction);
                    index += length;
                }
                nCalls /= 2;
                length *= 2;
            }
        }
    }

    private void privateTransform1D(float[] y, int transformLength) {
        block13: {
            int eigthLength;
            int quarterLength;
            int halfLength;
            block12: {
                halfLength = transformLength / 2;
                quarterLength = transformLength / 4;
                eigthLength = transformLength / 8;
                if (this._direction <= 0) break block12;
                switch (this._nLevels) {
                    case 1: {
                        this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                        break block13;
                    }
                    case 2: {
                        this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                        this.biOrthogonalTransform(y, halfLength, halfLength, this._direction);
                        break block13;
                    }
                    case 3: {
                        this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                        this.biOrthogonalTransform(y, halfLength, halfLength, this._direction);
                        this.biOrthogonalTransform(y, 3 * quarterLength, quarterLength, this._direction);
                        break block13;
                    }
                    case 4: {
                        this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                        this.biOrthogonalTransform(y, halfLength, halfLength, this._direction);
                        this.biOrthogonalTransform(y, 3 * quarterLength, quarterLength, this._direction);
                        this.biOrthogonalTransform(y, 7 * eigthLength, eigthLength, this._direction);
                        break block13;
                    }
                    default: {
                        throw new RuntimeException("Invalid number of levels " + this._nLevels);
                    }
                }
            }
            switch (this._nLevels) {
                case 1: {
                    this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                    break;
                }
                case 2: {
                    this.biOrthogonalTransform(y, halfLength, halfLength, this._direction);
                    this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                    break;
                }
                case 3: {
                    this.biOrthogonalTransform(y, 3 * quarterLength, quarterLength, this._direction);
                    this.biOrthogonalTransform(y, halfLength, halfLength, this._direction);
                    this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                    break;
                }
                case 4: {
                    this.biOrthogonalTransform(y, 7 * eigthLength, eigthLength, this._direction);
                    this.biOrthogonalTransform(y, 3 * quarterLength, quarterLength, this._direction);
                    this.biOrthogonalTransform(y, halfLength, halfLength, this._direction);
                    this.biOrthogonalTransform(y, 0, transformLength, this._direction);
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid number of levels " + this._nLevels);
                }
            }
        }
    }

    private void biOrthogonalTransform(float[] y, int offset, int nSamples, int direction) {
        if (nSamples < 2) {
            throw new IllegalArgumentException("Length must be at least 2");
        }
        if (nSamples % 2 != 0) {
            throw new IllegalArgumentException("Length must be an even number - not " + nSamples);
        }
        if (nSamples > this._scratch.length + 8) {
            throw new IllegalArgumentException("Array length is invalid");
        }
        int halfLength = nSamples / 2;
        if (direction > 0) {
            switch (nSamples) {
                case 2: {
                    this._scratch[3] = y[offset];
                    this._scratch[4] = y[offset + 1];
                    this._scratch[5] = y[offset];
                    this._scratch[6] = y[offset + 1];
                    this._scratch[7] = y[offset];
                    this._scratch[8] = y[offset + 1];
                    break;
                }
                case 4: {
                    this._scratch[3] = y[offset];
                    this._scratch[4] = y[offset + 1];
                    this._scratch[5] = y[offset + 2];
                    this._scratch[6] = y[offset + 3];
                    this._scratch[7] = y[offset + 2];
                    this._scratch[8] = y[offset + 1];
                    this._scratch[9] = y[offset];
                    this._scratch[10] = y[offset + 1];
                    break;
                }
                default: {
                    for (int i = 0; i < nSamples; ++i) {
                        this._scratch[3 + i] = y[offset + i];
                    }
                    this._scratch[nSamples + 3] = y[offset + nSamples - 2];
                    this._scratch[nSamples + 4] = y[offset + nSamples - 3];
                    this._scratch[nSamples + 5] = y[offset + nSamples - 4];
                    this._scratch[nSamples + 6] = y[offset + nSamples - 5];
                }
            }
            this._scratch[2] = this._scratch[4];
            this._scratch[1] = this._scratch[5];
            this._scratch[0] = this._scratch[6];
            int index1 = 0;
            for (int k = 0; k < halfLength; ++k) {
                y[offset + k] = WaveletTransform.DOTP_H1(this._scratch, index1);
                y[offset + k + halfLength] = WaveletTransform.DOTP_H0(this._scratch, index1);
                index1 += 2;
            }
        } else {
            int iy2 = halfLength + 6;
            switch (nSamples) {
                case 2: {
                    this._scratch[3] = this._scratch[4] = y[offset];
                    this._scratch[2] = this._scratch[4];
                    this._scratch[1] = this._scratch[4];
                    this._scratch[0] = this._scratch[4];
                    this._scratch[iy2 - 1] = this._scratch[iy2] = y[offset + 1];
                    this._scratch[iy2 - 2] = this._scratch[iy2];
                    float f = y[offset + 1];
                    this._scratch[iy2 + 2] = f;
                    this._scratch[iy2 + 1] = f;
                    break;
                }
                case 4: {
                    this._scratch[0] = y[offset + 1];
                    this._scratch[1] = y[offset + 1];
                    this._scratch[2] = y[offset];
                    this._scratch[3] = y[offset + 1];
                    this._scratch[4] = y[offset + 1];
                    this._scratch[5] = y[offset];
                    this._scratch[iy2 - 2] = y[offset + 3];
                    this._scratch[iy2 - 1] = y[offset + 2];
                    this._scratch[iy2] = y[offset + 2];
                    this._scratch[iy2 + 1] = y[offset + 3];
                    this._scratch[iy2 + 2] = y[offset + 2];
                    this._scratch[iy2 + 3] = y[offset + 2];
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < halfLength; ++i) {
                        this._scratch[2 + i] = y[offset + i];
                    }
                    this._scratch[0] = this._scratch[4];
                    this._scratch[1] = this._scratch[3];
                    this._scratch[halfLength + 2] = this._scratch[halfLength + 1];
                    this._scratch[halfLength + 3] = this._scratch[halfLength];
                    for (i = 0; i < halfLength; ++i) {
                        this._scratch[iy2 + i] = y[offset + i + halfLength];
                    }
                    this._scratch[iy2 - 2] = this._scratch[iy2 + 1];
                    this._scratch[iy2 - 1] = this._scratch[iy2];
                    this._scratch[iy2 + halfLength] = this._scratch[iy2 + halfLength - 2];
                    this._scratch[iy2 + halfLength + 1] = this._scratch[iy2 + halfLength - 3];
                }
            }
            int index1 = 2;
            for (int n = 0; n < nSamples; n += 2) {
                y[offset + n] = WaveletTransform.DOTP_EVENF1(this._scratch, index1) + WaveletTransform.DOTP_EVENF0(this._scratch, iy2);
                y[offset + n + 1] = WaveletTransform.DOTP_ODDF1(this._scratch, index1) + WaveletTransform.DOTP_ODDF0(this._scratch, iy2);
                ++index1;
                ++iy2;
            }
        }
    }

    private static void lowTransformCheck() {
        double epsilon = 0.001192092896;
        Almost almost = new Almost(epsilon);
        Random random = new Random(35343493L);
        int nTests = 100;
        int nLevels = 2;
        for (int k = 0; k < nTests; ++k) {
            int i;
            int nSamples = (int)(random.nextDouble() * 1000.0);
            if (nSamples < 1) {
                nSamples = 1;
            }
            int transformLength = WaveletTransform.getTransformLength(nSamples, nLevels);
            float[] y1 = new float[transformLength];
            float[] ySave = new float[transformLength];
            for (i = 0; i < nSamples; ++i) {
                y1[i] = (float)(random.nextDouble() * 100.0 - 50.0);
                ySave[i] = y1[i];
            }
            for (i = nSamples; i < transformLength; ++i) {
                y1[i] = 0.0f;
                ySave[i] = 0.0f;
            }
            WaveletTransform wt = new WaveletTransform(1, nSamples, nLevels);
            wt.biOrthogonalTransform(y1, 0, transformLength, 1);
            wt.biOrthogonalTransform(y1, 0, transformLength, -1);
            for (int i2 = 0; i2 < nSamples; ++i2) {
                assert (almost.equal(y1[i2], ySave[i2])) : y1[i2] + "!=" + ySave[i2];
            }
        }
        LOG.info("WaveletTransform.lowTransformCheck ***** SUCCESS *****");
    }

    private static void fullTransformCheck() throws Exception {
        assert (WaveletTransform.getTransformLength(1, 1) == 2);
        assert (WaveletTransform.getTransformLength(2, 1) == 2);
        assert (WaveletTransform.getTransformLength(1, 2) == 4);
        assert (WaveletTransform.getTransformLength(3, 2) == 4);
        assert (WaveletTransform.getTransformLength(1, 3) == 8);
        assert (WaveletTransform.getTransformLength(9, 3) == 16);
        assert (WaveletTransform.getTransformLength(9, 4) == 16);
        assert (WaveletTransform.getTransformLength(33, 5) == 64);
        double epsilon = 0.01192092896;
        Almost almost = new Almost(epsilon);
        Random random = new Random(5535343293L);
        int nTests = 100;
        for (int k = 0; k < nTests; ++k) {
            for (int nLevels = 1; nLevels <= 4; ++nLevels) {
                int i;
                int nSamples = (int)(random.nextDouble() * 1000.0);
                if (nSamples < 1) {
                    nSamples = 1;
                }
                int transformLength = WaveletTransform.getTransformLength(nSamples, nLevels);
                float[] y1 = new float[transformLength];
                float[] ySave = new float[transformLength];
                for (i = 0; i < nSamples; ++i) {
                    y1[i] = (float)(random.nextDouble() * 100.0 - 50.0);
                    ySave[i] = y1[i];
                }
                for (i = nSamples; i < transformLength; ++i) {
                    y1[i] = 0.0f;
                    ySave[i] = 0.0f;
                }
                WaveletTransform _forwardWt = new WaveletTransform(1, nSamples, nLevels);
                WaveletTransform _inverseWt = new WaveletTransform(-1, nSamples, nLevels);
                try {
                    _forwardWt.transform1D(y1);
                    _inverseWt.transform1D(y1);
                }
                catch (Exception e) {
                    LOG.info("Caught exception at nSamples=" + nSamples + " nSamples=" + nSamples + " nLevels=" + nLevels);
                    throw e;
                }
                for (int i2 = 0; i2 < nSamples; ++i2) {
                    assert (almost.equal(y1[i2], ySave[i2])) : y1[i2] + "!=" + ySave[i2];
                }
            }
        }
        LOG.info("WaveletTransform.fullTransformCheck ***** SUCCESS *****");
    }

    public static void main(String[] args) throws Exception {
        WaveletTransform.lowTransformCheck();
        WaveletTransform.fullTransformCheck();
    }
}

