/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.util;

import org.javaseis.util.PaciferCallback;
import org.javaseis.util.PacifierSysout;

public class Pacifier {
    private long numElements;
    private double percentIncrement;
    private double percentFactor;
    private long maxTimeIncrement;
    private long lastCallValue;
    private long lastTimeValue;
    private PaciferCallback parent;

    public Pacifier(double percentIncrement_in, double maxTimeIncrement_in, PaciferCallback parent_in) {
        if (parent_in == null) {
            throw new IllegalArgumentException("parent_in cannot be null");
        }
        this.percentIncrement = percentIncrement_in;
        this.maxTimeIncrement = (long)(1.0E9 * maxTimeIncrement_in);
        this.parent = parent_in;
    }

    public void init(long numElements_in) {
        this.numElements = numElements_in;
        this.percentFactor = 100.0 / (double)this.numElements;
        this.lastCallValue = -1L;
        this.lastTimeValue = System.nanoTime();
    }

    public void update(long currentElement) {
        String buf = "Percent Complete";
        this.update(currentElement, buf);
    }

    public void update(long currentElement, String comment) {
        String msg = "";
        double perDone = this.percentFactor * (double)currentElement;
        if (this.lastCallValue == -1L) {
            msg = String.format("%s: %8.1f", comment, 0.0);
            perDone = 0.0;
            this.parent.statusMsg(msg);
            this.parent.percentDone((float)perDone);
            this.lastCallValue = currentElement;
            this.lastTimeValue = System.nanoTime();
        } else if ((double)(currentElement - this.lastCallValue) * this.percentFactor >= this.percentIncrement) {
            msg = String.format("%s: %8.1f", comment, perDone);
            this.parent.statusMsg(msg);
            this.parent.percentDone((float)perDone);
            this.lastCallValue = currentElement;
            this.lastTimeValue = System.nanoTime();
        } else if (System.nanoTime() - this.lastTimeValue > this.maxTimeIncrement) {
            msg = String.format("%s: %8.1f", comment, perDone);
            this.parent.statusMsg(msg);
            this.parent.percentDone((float)perDone);
            this.lastCallValue = currentElement;
            this.lastTimeValue = System.nanoTime();
        }
    }

    public static void main(String[] args) throws InterruptedException {
        PacifierSysout u = new PacifierSysout();
        Pacifier pac = new Pacifier(10.0, 10.0, u);
        pac.init(1000L);
        for (int i = 0; i < 1000; ++i) {
            pac.update(i);
        }
        System.out.println("*** org.javaseis.util.Pacifier SUCCESS");
    }
}

