/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io.test;

import java.io.File;
import java.io.FileDescriptor;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Random;
import mpi.MPI;
import org.javaseis.io.VirtualIO;
import org.javaseis.util.SeisException;

public class TestODirect {
    private String _path;
    private int _countPerNode;
    private int _numNodes;
    private static final int _bufSize = 32;

    public static native void setODIRECT(FileDescriptor var0);

    public TestODirect(String path, int countPerNode, int numNodes) {
        this._path = path;
        this._countPerNode = countPerNode;
        this._numNodes = numNodes;
    }

    private void comment(int rank, String msg) {
        if (rank != 0) {
            return;
        }
        System.out.println(msg);
    }

    public void parallelwrite(int rank) throws SeisException {
        VirtualIO vio = new VirtualIO(this._path);
        ByteBuffer buf = ByteBuffer.allocateDirect(32);
        IntBuffer ibuf = buf.asIntBuffer();
        int[] ival = new int[1];
        int minIndex = rank * this._countPerNode;
        int maxIndex = minIndex + this._countPerNode;
        while (true) {
            this.comment(rank, "writing random numbers");
            this.writeRandomNumbers(vio, buf, ibuf, ival, minIndex, maxIndex);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            this.comment(rank, "writing constant values (rank)");
            this.writeConstant(vio, buf, ibuf, ival, minIndex, maxIndex, rank);
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        vio.close();
    }

    private void writeRandomNumbers(VirtualIO vio, ByteBuffer buf, IntBuffer ibuf, int[] ival, int minIndex, int maxIndex) throws SeisException {
        Random rand = new Random();
        for (int i = minIndex; i < maxIndex; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(i * 32);
            ival[0] = rand.nextInt();
            ibuf.put(ival);
            vio.write(buf);
            vio.flush();
        }
    }

    private void writeConstant(VirtualIO vio, ByteBuffer buf, IntBuffer ibuf, int[] ival, int minIndex, int maxIndex, int value) throws SeisException {
        Random rand = new Random();
        for (int i = minIndex; i < maxIndex; ++i) {
            buf.clear();
            ibuf.clear();
            vio.setPosition(i * 32);
            ival[0] = value;
            ibuf.put(ival);
            vio.write(buf);
            vio.flush();
        }
    }

    public void monitor() throws SeisException {
        if (new File(this._path).exists()) {
            new File(this._path).delete();
            System.gc();
        }
        VirtualIO vio = new VirtualIO(this._path);
        int[][] data = new int[this._numNodes][this._countPerNode];
        TestODirect.setODIRECT(vio.getFD());
        ByteBuffer buf = ByteBuffer.allocateDirect(32);
        IntBuffer ibuf = buf.asIntBuffer();
        int[] ival = new int[1];
        block2: while (true) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                break;
            }
            System.out.println(System.currentTimeMillis());
            int i = 0;
            while (true) {
                if (i >= data.length) continue block2;
                for (int j = 0; j < data[0].length; ++j) {
                    long position = (i * this._countPerNode + j) * 32;
                    buf.clear();
                    ibuf.clear();
                    vio.setPosition(position);
                    vio.read(buf);
                    ibuf.get(ival);
                    data[i][j] = ival[0];
                }
                System.out.println("node=" + i + " " + Arrays.toString(data[i]));
                System.out.flush();
                ++i;
            }
            break;
        }
        vio.close();
    }

    private static String usage() {
        StringBuffer buf = new StringBuffer();
        buf.append("This test program has two uses, first to write to a javaseis VirtualIO file\n");
        buf.append("in parallel which requires MPI and second to monitor that file to see if\n");
        buf.append("the contents are updating properly.\n");
        buf.append("Start the monitor program first with the following command line\n");
        buf.append("java -ea org.javaseis.io.test.TestODirect path count\n");
        buf.append(" - path = A fully qualified path to a file system and file to be used for testing\n");
        buf.append(" - count = The number of nodes that are going to be used during writing\n");
        buf.append("Next start the mpi application that is going to do the parallel writing\n");
        buf.append("mpiexec -l -n count java -ea org.javasies.io.test.TestODirect path\n");
        buf.append(" - count = The number of nodes that are going to be used during writing\n");
        buf.append(" - path = A fully qualified path to a file system and file to be used for testing\n");
        return buf.toString();
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args.length > 2) {
            System.out.println(TestODirect.usage());
            System.exit(1);
        }
        int ints_per_node = 10;
        if (args.length == 2) {
            new TestODirect(args[0], 10, Integer.parseInt(args[1])).monitor();
            System.exit(0);
        }
        MPI.Init((String[])args);
        TestODirect oDirect = new TestODirect(args[0], 10, MPI.COMM_WORLD.Size());
        oDirect.parallelwrite(MPI.COMM_WORLD.Rank());
        MPI.Finalize();
    }

    static {
        System.loadLibrary("utilfile");
    }
}

