/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.io;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JSUtilFile
extends File {
    private static boolean _can_set_o_direct = false;
    private static boolean _can_set_sparse = false;

    private static native int nSetODirect(FileDescriptor var0, String var1, int var2);

    private static native boolean nODirectIsSet(FileDescriptor var0, String var1);

    private static native boolean nSetSparse(String var0);

    private static native long nDiskCapacityBytes(String var0);

    public JSUtilFile(File file) {
        super(file.getPath());
    }

    public JSUtilFile(String path) {
        super(path);
    }

    public JSUtilFile(String path, String name) {
        super(path, name);
    }

    public JSUtilFile(File dir, String name) {
        super(dir, name);
    }

    public boolean recursiveDelete() throws SecurityException {
        return JSUtilFile._recursiveDelete(this);
    }

    private static boolean _recursiveDelete(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children != null) {
                for (File child : children) {
                    if (JSUtilFile._recursiveDelete(child)) continue;
                    return false;
                }
            }
            return file.delete();
        }
        return file.delete();
    }

    private static boolean isWindows() {
        return !File.separator.equals("/");
    }

    private static boolean isSunOS() {
        String os_name = System.getProperty("os.name");
        return os_name.equalsIgnoreCase("SunOS");
    }

    public static int setODirect(FileDescriptor fd, String filename, int set) {
        int retval = -1;
        retval = _can_set_o_direct ? JSUtilFile.nSetODirect(fd, filename, set) : 0;
        return retval;
    }

    public static boolean isSet(FileDescriptor fd, String filename) {
        boolean retval = false;
        if (_can_set_o_direct) {
            retval = JSUtilFile.nODirectIsSet(fd, filename);
        }
        return retval;
    }

    public static boolean setSparse(String filename) {
        boolean retval = false;
        retval = _can_set_sparse ? JSUtilFile.nSetSparse(filename) : !JSUtilFile.isWindows();
        return retval;
    }

    public static long diskCapacityBytes(String dir) {
        return JSUtilFile.nDiskCapacityBytes(dir);
    }

    public static void main(String[] args) {
        String filename = null;
        if (args.length > 0 && args[0].length() > 0) {
            filename = args[0];
        }
        if (filename == null) {
            return;
        }
        FileDescriptor fd = null;
        try {
            fd = new RandomAccessFile(filename, "rw").getFD();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
            return;
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
            return;
        }
        int err = JSUtilFile.setODirect(fd, filename, 1);
        if (err == 0) {
            err = JSUtilFile.setODirect(fd, filename, 0);
        }
        System.out.println("Return from UtilFile().exec: " + err);
    }

    static {
        try {
            System.loadLibrary("JSUtilFile");
            _can_set_o_direct = true;
            if (JSUtilFile.isWindows()) {
                _can_set_sparse = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            if (!JSUtilFile.isWindows()) {
                System.out.println("Warning for Linux 2.6 users: ");
                System.out.println("No mechanism to set the O_DIRECT flag is available.");
                System.out.println("This is necessary to reliably do I/O files across a cluster.");
            } else {
                System.out.println("Warning for Windows - link error:" + e.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Warning for Linux 2.6 users: ");
            System.out.println("No mechanism to set the O_DIRECT flag is available.");
            System.out.println("This is necessary to reliably do I/O files across a cluster.");
            e.printStackTrace();
        }
    }
}

