/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array.beta.test;

import edu.mines.jtk.util.ArrayMath;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.javaseis.array.beta.FlexArray;
import org.javaseis.array.beta.IFlexArray;
import org.javaseis.array.beta.PositionIterator;
import org.javaseis.array.beta.test.JPerfTestShapes;
import org.javaseis.iterators.beta.IPositionIterator;
import org.javaseis.util.MemoryReporter;

public class JPerfTestMultiArrayTraceFrame {
    private int _logLevel;
    private boolean _doChecks;

    public JPerfTestMultiArrayTraceFrame() {
        this(Level.INFO, false);
    }

    public JPerfTestMultiArrayTraceFrame(Level level, boolean doChecks) {
        this.setLevel(level);
        this._doChecks = doChecks;
    }

    private void testTrace(int[] inshape) {
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        IFlexArray<float[]> m = FlexArray.createFloatArray(inshape);
        this.fillArray(m);
        this.logFine("After fill");
        double startTime = JPerfTestMultiArrayTraceFrame.getTime();
        int[] position = new int[inshape.length];
        PositionIterator dapi = new PositionIterator(inshape, position, IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.TRACE_AXIS);
        while (dapi.hasNext()) {
            dapi.next();
            float[] intrc = m.getTrace(position);
            float[] outtrc = new float[inshape[0]];
            ArrayMath.copy((float[])intrc, (float[])outtrc);
            m.putTrace(outtrc, position);
        }
        double elapsedTime = JPerfTestMultiArrayTraceFrame.getTime() - startTime;
        this.logInfo("Get trace: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter get by trace");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
    }

    private void testFrame(int[] inshape) {
        double arraySize = 3.814697265625E-6;
        for (int i = 0; i < inshape.length; ++i) {
            arraySize *= (double)inshape[i];
        }
        IFlexArray<float[]> m = FlexArray.createFloatArray(inshape);
        this.fillArray(m);
        this.logFine("After fill");
        double startTime = JPerfTestMultiArrayTraceFrame.getTime();
        int[] position = new int[inshape.length];
        PositionIterator dapi = new PositionIterator(inshape, position, IPositionIterator.Direction.FORWARD, IPositionIterator.Scope.FRAME_AXIS);
        while (dapi.hasNext()) {
            dapi.next();
            float[][] intrc = m.getFrame(position);
            float[][] outtrc = new float[inshape[1]][inshape[0]];
            ArrayMath.copy((float[][])intrc, (float[][])outtrc);
            m.putFrame((T[])outtrc, position);
        }
        double elapsedTime = JPerfTestMultiArrayTraceFrame.getTime() - startTime;
        this.logInfo("Get frame: size " + arraySize + " MB, time " + elapsedTime + " sec, bandwidth " + arraySize / elapsedTime + " MB/sec, input shape " + Arrays.toString(m.getShape()));
        this.logFine("\nAfter get by frame");
        this.printArray(m);
        if (this._doChecks) {
            this.checkArray(m, m.getShape());
        }
    }

    private int pvalue(int[] position, int is) {
        int value = is;
        int mult = 1;
        for (int i = 0; i < position.length; ++i) {
            value += mult * position[i];
            mult *= 10;
        }
        return value;
    }

    private void fillArray(IFlexArray<float[]> m) {
        PositionIterator it = new PositionIterator(m.getShape(), new int[m.getDimensions()], IPositionIterator.Direction.FORWARD, 1);
        while (it.hasNext()) {
            int[] pos = it.next();
            float[] buf = m.getTrace(pos);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = this.pvalue(pos, i);
            }
        }
    }

    private void checkArray(IFlexArray<float[]> m, int[] checkShape) {
        PositionIterator it = new PositionIterator(checkShape, new int[m.getDimensions()], IPositionIterator.Direction.FORWARD, 1);
        float[] bufTrue = new float[m.getShape()[0]];
        while (it.hasNext()) {
            int i;
            int[] pos = it.next();
            float[] buf = m.getTrace(pos);
            boolean ret = false;
            for (i = 1; i < pos.length; ++i) {
                if (pos[i] < checkShape[i]) continue;
                ret = true;
            }
            if (ret) continue;
            for (i = 0; i < buf.length && i < checkShape[0]; ++i) {
                bufTrue[i] = this.pvalue(pos, i);
                if (buf[i] == bufTrue[i]) continue;
                System.err.println("Check failed at position " + Arrays.toString(pos) + " expected " + bufTrue[i] + " actual " + buf[i]);
            }
        }
    }

    private void printArray(IFlexArray<float[]> m) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        PositionIterator it = new PositionIterator(m.getShape(), new int[m.getDimensions()], IPositionIterator.Direction.FORWARD, 1);
        int[] shape = m.getShape();
        while (it.hasNext()) {
            int[] pos = it.next();
            System.out.println("Values at position " + Arrays.toString(pos));
            float[] buf = m.getTrace(pos);
            for (int i0 = 0; i0 < shape[0]; ++i0) {
                System.out.println("val[" + i0 + "] = " + buf[i0]);
            }
        }
    }

    private void logInfo(String message) {
        if (!this.isLoggable(Level.INFO)) {
            return;
        }
        System.out.println(message);
    }

    private void logFine(String message) {
        if (!this.isLoggable(Level.FINE)) {
            return;
        }
        System.out.println(message);
    }

    private void setLevel(Level level) {
        this._logLevel = level.intValue();
    }

    private boolean isLoggable(Level level) {
        return level.intValue() >= this._logLevel && this._logLevel != Level.OFF.intValue();
    }

    private static double getTime() {
        return 1.0E-9 * (double)System.nanoTime();
    }

    public static void main(String[] args) {
        Boolean memoryPrint = true;
        JPerfTestShapes.Size s = JPerfTestShapes.parseArgs(args, memoryPrint);
        List<int[]> shapes3 = JPerfTestShapes.getShapes(s, JPerfTestShapes.Dimensions.THREE);
        MemoryReporter memrp = null;
        if (memoryPrint.booleanValue()) {
            memrp = new MemoryReporter();
        }
        JPerfTestMultiArrayTraceFrame tester = new JPerfTestMultiArrayTraceFrame(Level.INFO, false);
        for (int[] shape : shapes3) {
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for frame: " + memrp.getMemoryUsage());
            }
            tester.testFrame(shape);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for frame: " + memrp.getMemoryUsage());
            }
            if (memoryPrint.booleanValue()) {
                memrp.reset();
            }
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Start memory for trace: " + memrp.getMemoryUsage());
            }
            tester.testTrace(shape);
            if (memoryPrint.booleanValue()) {
                tester.logInfo("Memory report for trace: " + memrp.getMemoryUsage());
            }
            if (!memoryPrint.booleanValue()) continue;
            memrp.reset();
        }
    }
}

