/*
 * Decompiled with CFR 0.152.
 */
package org.javaseis.array;

import java.util.Arrays;
import org.javaseis.array.BackingArray;
import org.javaseis.array.IBackingArray;
import org.javaseis.util.ArrayUtil;

public class ArrayStorage
implements IBackingArray {
    protected int _length = 1;
    protected int _bufLength = 1;
    protected int _offset = 0;
    protected Class _classType = Float.TYPE;
    protected Object[] _objects = null;
    protected byte[] _bytes = null;
    protected short[] _shorts = null;
    protected int[] _ints = null;
    protected long[] _longs = null;
    protected float[] _floats = null;
    protected double[] _doubles = null;

    public ArrayStorage() {
        this._classType = null;
        this._length = 0;
        this._bufLength = 0;
        this._offset = 0;
    }

    public ArrayStorage(Class classType, long length) {
        this._classType = classType;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Requested length exceeds maximum allowed length: requested length = " + length + ", maximum length = " + Integer.MAX_VALUE);
        }
        this._length = (int)length;
        this._bufLength = (int)length;
        this._offset = 0;
        this.allocate();
    }

    public <T> ArrayStorage(T[] buf) {
        this.setArray(buf);
    }

    public ArrayStorage(byte[] buf) {
        this.setArray(buf);
    }

    public ArrayStorage(short[] buf) {
        this.setArray(buf);
    }

    public ArrayStorage(int[] buf) {
        this.setArray(buf);
    }

    public ArrayStorage(long[] buf) {
        this.setArray(buf);
    }

    public ArrayStorage(float[] buf) {
        this.setArray(buf);
    }

    public ArrayStorage(double[] buf) {
        this.setArray(buf);
    }

    @Override
    public IBackingArray view(long length, long offset) {
        return ArrayStorage.view(this, length, offset);
    }

    public static IBackingArray view(ArrayStorage a, long length, long offset) {
        if (length > a.getLength() - offset) {
            throw new IndexOutOfBoundsException("Requested offset and length exceed Backing Storage length");
        }
        ArrayStorage b = new ArrayStorage();
        b.setArray(a.getArray());
        b.setBufferView(offset, length);
        return b;
    }

    @Override
    public Class getClassType() {
        return this._classType;
    }

    @Override
    public void setClassType(Class classType) {
        this._classType = classType;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    @Override
    public void setLength(long length) {
        if (length > (long)(this._bufLength - this._offset)) {
            throw new IndexOutOfBoundsException("Requested length exceeds Backing Storage length");
        }
        this._length = (int)length;
    }

    @Override
    public long getOffset() {
        return this._offset;
    }

    @Override
    public void setOffset(long offset) {
        if ((long)this._length + offset > (long)this._bufLength) {
            throw new IndexOutOfBoundsException("Requested offset exceeds Backing Storage length");
        }
        this._offset = (int)offset;
    }

    @Override
    public void setBufferView(long offset, long length) {
        if (offset + length > (long)this._bufLength) {
            throw new IndexOutOfBoundsException("Requested offset and length exceeds Backing Storage length");
        }
        this._offset = (int)offset;
        this._length = (int)length;
    }

    public void setArray(Object buf) {
        if (buf.getClass().getComponentType().equals(Byte.TYPE)) {
            this._bytes = (byte[])buf;
            this._bufLength = this._length = this._bytes.length;
        } else if (buf.getClass().getComponentType().equals(Short.TYPE)) {
            this._shorts = (short[])buf;
            this._bufLength = this._length = this._shorts.length;
        } else if (buf.getClass().getComponentType().equals(Integer.TYPE)) {
            this._ints = (int[])buf;
            this._bufLength = this._length = this._ints.length;
        } else if (buf.getClass().getComponentType().equals(Float.TYPE)) {
            this._floats = (float[])buf;
            this._bufLength = this._length = this._floats.length;
        } else if (buf.getClass().getComponentType().equals(Long.TYPE)) {
            this._longs = (long[])buf;
            this._bufLength = this._length = this._longs.length;
        } else if (buf.getClass().getComponentType().equals(Double.TYPE)) {
            this._doubles = (double[])buf;
            this._bufLength = this._length = this._doubles.length;
        } else {
            this._objects = (Object[])buf;
            this._bufLength = this._length = this._objects.length;
        }
    }

    public Object getArray() {
        Object[] result = this.getClassType().equals(Byte.TYPE) ? this._bytes : (this.getClassType().equals(Short.TYPE) ? (Object[])this._shorts : (this.getClassType().equals(Integer.TYPE) ? (Object[])this._ints : (this.getClassType().equals(Float.TYPE) ? (Object[])this._floats : (this.getClassType().equals(Long.TYPE) ? (Object[])this._longs : (this.getClassType().equals(Double.TYPE) ? (Object[])this._doubles : (Object[])this._objects)))));
        return result;
    }

    @Override
    public long getBackingArrayLength() {
        long result = this.getClassType().equals(Byte.TYPE) ? (long)this._bytes.length : (this.getClassType().equals(Short.TYPE) ? (long)this._shorts.length : (this.getClassType().equals(Integer.TYPE) ? (long)this._ints.length : (this.getClassType().equals(Float.TYPE) ? (long)this._floats.length : (this.getClassType().equals(Long.TYPE) ? (long)this._longs.length : (this.getClassType().equals(Double.TYPE) ? (long)this._doubles.length : (long)this._objects.length)))));
        return result;
    }

    @Override
    public void arraycopy(IBackingArray src, long srcOffset, IBackingArray dest, long destOffset, long count) {
        Class classType = src.getClassType();
        if (classType != dest.getClassType()) {
            throw new RuntimeException("Class Type Mismatch");
        }
        ArrayStorage a = (ArrayStorage)src;
        ArrayStorage b = (ArrayStorage)dest;
        int aoff = (int)srcOffset + (int)src.getOffset();
        int boff = (int)destOffset + (int)dest.getOffset();
        int length = (int)count;
        if (classType == Byte.TYPE) {
            ArrayUtil.arraycopy(a._bytes, aoff, b._bytes, boff, length);
        } else if (classType == Integer.TYPE) {
            ArrayUtil.arraycopy(a._ints, aoff, b._ints, boff, length);
        } else if (classType == Long.TYPE) {
            ArrayUtil.arraycopy(a._longs, aoff, b._longs, boff, length);
        } else if (classType == Short.TYPE) {
            ArrayUtil.arraycopy(a._shorts, aoff, b._shorts, boff, length);
        } else if (classType == Float.TYPE) {
            ArrayUtil.arraycopy(a._floats, aoff, b._floats, boff, length);
        } else if (classType == Double.TYPE) {
            ArrayUtil.arraycopy(a._doubles, aoff, b._doubles, boff, length);
        } else {
            ArrayUtil.arraycopy(a._objects, aoff, b._objects, boff, length);
        }
    }

    protected <T> void setArray(T[] buf) {
        this._classType = buf.getClass();
        this._objects = buf;
        this._length = this._bufLength = buf.length;
    }

    protected void setArray(byte[] buf) {
        this._classType = buf.getClass();
        this._bytes = buf;
        this._length = this._bufLength = buf.length;
    }

    protected void setArray(short[] buf) {
        this._classType = buf.getClass();
        this._shorts = buf;
        this._length = this._bufLength = buf.length;
    }

    protected void setArray(int[] buf) {
        this._classType = buf.getClass();
        this._ints = buf;
        this._length = this._bufLength = buf.length;
    }

    protected void setArray(long[] buf) {
        this._classType = buf.getClass();
        this._longs = buf;
        this._length = this._bufLength = buf.length;
    }

    protected void setArray(float[] buf) {
        this._classType = buf.getClass();
        this._floats = buf;
        this._length = this._bufLength = buf.length;
    }

    protected void setArray(double[] buf) {
        this._classType = buf.getClass();
        this._doubles = buf;
        this._length = this._bufLength = buf.length;
    }

    @Override
    public void allocate() {
        if (this._classType == Byte.TYPE) {
            this._bytes = new byte[this._bufLength];
        } else if (this._classType == Integer.TYPE) {
            this._ints = new int[this._bufLength];
        } else if (this._classType == Long.TYPE) {
            this._longs = new long[this._bufLength];
        } else if (this._classType == Short.TYPE) {
            this._shorts = new short[this._bufLength];
        } else if (this._classType == Float.TYPE) {
            this._floats = new float[this._bufLength];
        } else if (this._classType == Double.TYPE) {
            this._doubles = new double[this._bufLength];
        } else {
            throw new RuntimeException("Object array allocation is not supported");
        }
    }

    @Override
    public <T> void getArray(T[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._objects, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public void getArray(byte[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._bytes, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public void getArray(short[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._shorts, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public void getArray(int[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._ints, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public void getArray(long[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._longs, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public void getArray(float[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._floats, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public void getArray(double[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(this._doubles, (int)(index + (long)this._offset), buf, offset, length);
    }

    @Override
    public byte getByte(long index) {
        return this._bytes[(int)(index + (long)this._offset)];
    }

    @Override
    public double getDouble(long index) {
        return this._doubles[(int)(index + (long)this._offset)];
    }

    @Override
    public float getFloat(long index) {
        return this._floats[(int)(index + (long)this._offset)];
    }

    @Override
    public int getInt(long index) {
        return this._ints[(int)(index + (long)this._offset)];
    }

    @Override
    public long getLong(long index) {
        return this._longs[(int)(index + (long)this._offset)];
    }

    @Override
    public <T> T getObject(long index) {
        return (T)this._objects[(int)(index + (long)this._offset)];
    }

    @Override
    public short getShort(long index) {
        return this._shorts[(int)(index + (long)this._offset)];
    }

    @Override
    public <T> void putArray(T[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._objects, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putArray(byte[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._bytes, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putArray(short[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._shorts, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putArray(int[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._ints, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putArray(long[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._longs, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putArray(float[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._floats, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putArray(double[] buf, int offset, int length, long index) {
        ArrayUtil.arraycopy(buf, offset, this._doubles, (int)(index + (long)this._offset), length);
    }

    @Override
    public void putByte(byte buf, long index) {
        this._bytes[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public void putDouble(double buf, long index) {
        this._doubles[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public void putFloat(float buf, long index) {
        this._floats[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public void putInt(int buf, long index) {
        this._ints[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public void putLong(long buf, long index) {
        this._longs[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public <T> void putObject(T buf, long index) {
        this._objects[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public void putShort(short buf, long index) {
        this._shorts[(int)(index + (long)this._offset)] = buf;
    }

    @Override
    public <T> void fill(T value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._objects[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(byte value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._bytes[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(short value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._shorts[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(int value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._ints[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(long value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._longs[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(float value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._floats[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public void fill(double value, long index, long stride, long count) {
        int ia = (int)(index + (long)this._offset);
        int inc = (int)stride;
        int i = 0;
        while ((long)i < count) {
            this._doubles[ia] = value;
            ++i;
            ia += inc;
        }
    }

    @Override
    public BackingArray.Type getBackingArrayType() {
        return BackingArray.Type.JAVA_ARRAY;
    }

    public String toString() {
        if (this._classType == Byte.TYPE) {
            return Arrays.toString(this._bytes);
        }
        if (this._classType == Integer.TYPE) {
            return Arrays.toString(this._ints);
        }
        if (this._classType == Long.TYPE) {
            return Arrays.toString(this._longs);
        }
        if (this._classType == Short.TYPE) {
            return Arrays.toString(this._shorts);
        }
        if (this._classType == Float.TYPE) {
            return Arrays.toString(this._floats);
        }
        if (this._classType == Double.TYPE) {
            return Arrays.toString(this._doubles);
        }
        return Arrays.toString(this._objects);
    }
}

