/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmListException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.PackageLine;
import com.macrovision.flexlm.lictext.ServerLine;
import com.macrovision.flexlm.lictext.UpgradeLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import com.macrovision.flexlm.misc.Glob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class LicenseGroup
implements FlexlmConstants,
FlexlmInternalConstants {
    String licenseFileSpec;
    VendorInfo vInfo;
    String[] licenseServers;
    FeatureLine[] featuresAvailable;
    LinkedList serverList;
    LinkedList featureList;
    LinkedList upgradeList;
    LinkedList packageList;
    LinkedList elementExceptionList;
    LinkedList generalExceptionList;
    LinkedList allExceptionList;
    LinkedList certificateList;

    public LicenseGroup(Reader reader, VendorInfo vendorInfo, boolean bl) throws FlexlmException {
        this.vInfo = vendorInfo;
        this.initLists();
        LicenseCertificate licenseCertificate = this.getCertificateData(reader, null);
        this.certificateList.add(licenseCertificate);
        this.validateCertificate(licenseCertificate, bl);
        this.aggregate();
    }

    public LicenseGroup(String string, VendorInfo vendorInfo, boolean bl) throws FlexlmException {
        this.licenseFileSpec = string;
        this.vInfo = vendorInfo;
        this.initLists();
        String[] stringArray = LicenseGroup.expandFileNames(this.licenseFileSpec);
        String string2 = vendorInfo.getVendorName();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3;
            int n;
            int n2 = 0;
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(stringArray[i]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.generalExceptionList.add(new FlexlmException(-1, 4042, stringArray[i]));
                continue;
            }
            catch (SecurityException securityException) {
                this.generalExceptionList.add(new FlexlmException(-30, 4043, stringArray[i]));
                continue;
            }
            InputStreamReader inputStreamReader = null;
            try {
                inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.generalExceptionList.add(new FlexlmException(-506, 4044));
            }
            LicenseCertificate licenseCertificate = this.getCertificateData(inputStreamReader, stringArray[i]);
            if (licenseCertificate.useServerPresent()) {
                n2 = 1;
            }
            for (n = 0; n < licenseCertificate.getVendors().size() && (n2 = this.matchToken(string2, string3 = licenseCertificate.getVendors().get(n).toString())) != 1; ++n) {
            }
            if (n2 != 1) {
                String string4;
                for (n = 0; n < licenseCertificate.getFeatures().size() && (n2 = this.matchToken(string2, string4 = licenseCertificate.getFeatures().get(n).toString())) != 1; ++n) {
                }
            }
            if (n2 != true) continue;
            this.certificateList.add(licenseCertificate);
            if (bl) {
                this.validateCertificate(licenseCertificate, true);
            }
            try {
                fileInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.getMessage());
            }
        }
        if (this.certificateList.size() == 0) {
            this.allExceptionList.addAll(this.generalExceptionList);
            this.allExceptionList.addAll(this.elementExceptionList);
            FlexlmException[] flexlmExceptionArray = this.allExceptionList.toArray(new FlexlmException[this.allExceptionList.size()]);
            throw new FlexlmListException(-513, 4052, flexlmExceptionArray);
        }
        if (bl) {
            this.aggregate();
        }
    }

    private int matchToken(String string, String string2) {
        String[] stringArray = string2.split(" ");
        if ((stringArray[0].equals("VENDOR") || stringArray[0].equals("DAEMON")) && string.equalsIgnoreCase(stringArray[1]) || (stringArray[0].equals("FEATURE") || stringArray[0].equals("INCREMENT")) && string.equalsIgnoreCase(stringArray[2])) {
            return 1;
        }
        return 0;
    }

    private static String[] expandFileNames(String string) {
        String[] stringArray = Glob.parseSourceString(string);
        String[] stringArray2 = null;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            stringArray2 = file.isDirectory() ? Glob.matchFiles(stringArray[i] + File.separator + "*.lic") : Glob.matchFiles(stringArray[i]);
            if (stringArray2 == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                vector.add(stringArray2[j]);
            }
        }
        String[] stringArray3 = vector.toArray(new String[vector.size()]);
        return stringArray3;
    }

    private void initLists() {
        this.generalExceptionList = new LinkedList();
        this.elementExceptionList = new LinkedList();
        this.allExceptionList = new LinkedList();
        this.serverList = new LinkedList();
        this.featureList = new LinkedList();
        this.upgradeList = new LinkedList();
        this.packageList = new LinkedList();
        this.certificateList = new LinkedList();
    }

    private LicenseCertificate getCertificateData(Reader reader, String string) throws FlexlmException {
        LicenseCertificate licenseCertificate = null;
        try {
            licenseCertificate = new LicenseCertificate(reader, string, this.vInfo);
        }
        catch (IOException iOException) {
            throw new FlexlmException(-30, 4049, iOException.getMessage());
        }
        return licenseCertificate;
    }

    private void validateCertificate(LicenseCertificate licenseCertificate, boolean bl) {
        LinkedList linkedList = licenseCertificate.getServers();
        if (linkedList != null && linkedList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            ListIterator listIterator = linkedList.listIterator(0);
            while (listIterator.hasNext()) {
                ServerLine serverLine = (ServerLine)listIterator.next();
                int n = serverLine.getPortNumber();
                String string = serverLine.getServerName();
                String string2 = n == 0 ? "" : Integer.toString(n);
                stringBuffer.append("," + string2 + "@" + string);
            }
            stringBuffer.deleteCharAt(0);
            this.serverList.add(new String(stringBuffer));
        }
        if (!licenseCertificate.useServerPresent() && licenseCertificate.authenticate(bl)) {
            this.featureList.addAll(licenseCertificate.getAuthenticFeatures());
            this.upgradeList.addAll(licenseCertificate.getAuthenticUpgrades());
            this.packageList.addAll(licenseCertificate.getAuthenticPackages());
        }
        this.elementExceptionList.addAll(licenseCertificate.getElementExceptions());
    }

    private void aggregate() throws FlexlmException {
        Object[] objectArray;
        if (this.serverList.size() > 0) {
            this.licenseServers = this.serverList.toArray(new String[this.serverList.size()]);
        }
        LicenseElement.applySupersede(this.upgradeList, true);
        UpgradeLine.applyUpgrades(this.featureList, this.upgradeList);
        this.featureList.addAll(this.upgradeList);
        if (this.featureList.size() > 0) {
            objectArray = this.featureList.toArray(new FeatureLine[this.featureList.size()]);
            Arrays.sort(objectArray);
            this.featureList.clear();
            LicenseGroup.addArrayToList(this.featureList, objectArray);
            LicenseElement.applySupersede(this.featureList, true);
            LicenseElement.applySupersede(this.packageList, true);
            try {
                PackageLine.applyPackages(this.featureList, this.packageList, this.upgradeList);
            }
            catch (FlexlmException flexlmException) {
                this.elementExceptionList.add(flexlmException);
            }
            this.featureList = this.removeDuplicates(this.featureList);
            this.featuresAvailable = this.featureList.toArray(new FeatureLine[this.featureList.size()]);
        }
        if (this.featuresAvailable == null && this.licenseServers == null) {
            this.allExceptionList.addAll(this.generalExceptionList);
            this.allExceptionList.addAll(this.elementExceptionList);
            objectArray = this.allExceptionList.toArray(new FlexlmException[this.allExceptionList.size()]);
            throw new FlexlmListException(-513, 4050, (FlexlmException[])objectArray);
        }
    }

    private LinkedList removeDuplicates(LinkedList linkedList) {
        if (linkedList == null) {
            return null;
        }
        LinkedList<FeatureLine> linkedList2 = new LinkedList<FeatureLine>();
        FeatureLine[] featureLineArray = linkedList.toArray(new FeatureLine[0]);
        for (int i = 0; i < featureLineArray.length; ++i) {
            boolean bl;
            int n;
            for (n = 0; n < i && !(bl = featureLineArray[n].cryptEquals(featureLineArray[i])); ++n) {
            }
            if (n < i) continue;
            linkedList2.add(featureLineArray[i]);
        }
        return linkedList2;
    }

    public FeatureLine[] getFeaturesAvailable() {
        return this.featuresAvailable;
    }

    public String[] getServers() {
        return this.licenseServers;
    }

    public LinkedList getAllExceptions() {
        return this.allExceptionList;
    }

    public LinkedList getGeneralExceptions() {
        return this.generalExceptionList;
    }

    public LinkedList getElementExceptions() {
        return this.elementExceptionList;
    }

    public LicenseCertificate[] getLicenseCertificates() {
        return this.certificateList.toArray(new LicenseCertificate[this.certificateList.size()]);
    }

    public LinkedList getLicenseCertificateList() {
        return this.certificateList;
    }

    private static void addArrayToList(LinkedList linkedList, Object[] objectArray) {
        if (objectArray == null || linkedList == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            linkedList.add(objectArray[i]);
        }
    }
}

